/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.ele.remote.ElePersonLevelByDeptRemote;
import com.zkteco.zkbiosecurity.ele.service.EleLevelService;
import com.zkteco.zkbiosecurity.ele.service.ElePersonLevelByDeptService;
import com.zkteco.zkbiosecurity.ele.service.ElePersonService;
import com.zkteco.zkbiosecurity.ele.vo.ElePersonLevelByDeptItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ElePersonLevelByDeptController
extends BaseController
implements ElePersonLevelByDeptRemote {
    private Logger logger = LoggerFactory.getLogger(ElePersonLevelByDeptController.class);
    @Autowired
    private ElePersonLevelByDeptService elePersonLevelByDeptService;
    @Autowired
    private ElePersonService elePersonService;
    @Autowired
    private EleLevelService eleLevelService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"ele:personLevelByDept"})
    public ModelAndView index() {
        return new ModelAndView("ele/personLevelByDept/elePersonLevelByDept");
    }

    @RequiresPermissions(value={"ele:personLevelByDept:refresh"})
    public DxGrid list(ElePersonLevelByDeptItem condition) {
        Pager pager = this.elePersonLevelByDeptService.getPagerFilterAuth(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:personLevelByDept:addLevel"})
    @LogRequest(module="ele_module", object="common_leftMenu_levelSetByDept", opType="common_level_addDefaultLevel", requestParams={"deptCode", "levelNames"}, opContent="common_level_name")
    public ZKResultMsg addLevel(String deptId, String levelIds, String immeUpdate) {
        try {
            if (StringUtils.isNotBlank((CharSequence)deptId) && StringUtils.isNotBlank((CharSequence)levelIds)) {
                this.elePersonLevelByDeptService.setDeptLinkLevel(deptId, levelIds);
                if ("true".equals(immeUpdate)) {
                    List personIds = this.elePersonService.getPersonByDept(deptId);
                    if (Objects.nonNull(personIds) && !personIds.isEmpty()) {
                        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
                        List<String> personArrayIds = this.cutToArray(personIds);
                        int total = personArrayIds.size();
                        for (int i = 0; i < personArrayIds.size(); ++i) {
                            this.eleLevelService.addPersonLevel(levelIds, personArrayIds.get(i));
                            personArrayIds.set(i, null);
                            System.gc();
                            Thread.sleep(1000L);
                            this.progressCache.setProcess(new ProcessBean(0, (int)((double)(i + 1) * 1.0 / (double)total * 100.0)));
                        }
                    }
                    this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
                }
            }
        }
        catch (Exception e) {
            throw new ZKBusinessException("ele dept add level error", (Throwable)e);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    private List<String> cutToArray(List<String> personIds) {
        ArrayList<String> idsList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < personIds.size(); ++j) {
            sb.append(personIds.get(j) + ",");
            if ((j + 1) % 500 != 0) continue;
            idsList.add(sb.substring(0, sb.length() - 1) + ",");
            sb = new StringBuffer();
        }
        if (sb.length() > 0) {
            idsList.add(sb.substring(0, sb.length() - 1));
        }
        return idsList;
    }

    @RequiresPermissions(value={"ele:personLevelByDept:delLevel"})
    @LogRequest(module="ele_module", object="common_leftMenu_levelSetByDept", opType="common_level_delDefaultLevel", requestParams={"deptCode", "levelName"}, opContent="common_level_name")
    public ZKResultMsg delLevel(String leftIds, String rightIds, String immeUpdate) {
        if (StringUtils.isNotBlank((CharSequence)leftIds) && StringUtils.isNotBlank((CharSequence)rightIds)) {
            this.elePersonLevelByDeptService.delLevel(leftIds, rightIds);
            if ("true".equals(immeUpdate)) {
                try {
                    this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
                    ArrayList<String> levelIdList = new ArrayList<String>(Arrays.asList(rightIds.split(",")));
                    String personIds = this.elePersonService.getPersonIdByDept(leftIds);
                    List personArrayIds = this.elePersonService.splitPersonIds(personIds, 200);
                    int total = personArrayIds.size();
                    for (int i = 0; i < total; ++i) {
                        this.eleLevelService.immeDelPersonLevel(levelIdList, (String)personArrayIds.get(i));
                        personArrayIds.set(i, null);
                        System.gc();
                        Thread.sleep(1000L);
                        this.progressCache.setProcess(new ProcessBean(0, (int)((double)(i + 1) * 1.0 / (double)total * 100.0)));
                    }
                    this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    this.logger.error("deletePerson with level error", (Throwable)e);
                }
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getLevelListByDept(String deptId) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.elePersonLevelByDeptService.getLevelListByDept(deptId)));
    }
}

