/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleGlobalLinkageMediaRemote;
import com.zkteco.zkbiosecurity.ele.service.EleGlobalLinkageMediaService;
import com.zkteco.zkbiosecurity.ele.vo.EleGlobalLinkageMediaItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleGlobalLinkageMediaController
extends BaseController
implements EleGlobalLinkageMediaRemote {
    @Autowired
    private EleGlobalLinkageMediaService eleGlobalLinkageMediaService;

    @RequiresPermissions(value={"ele:globalLinkageMedia"})
    public ModelAndView index() {
        return new ModelAndView("ele/globalLinkageMedia/eleGlobalLinkageMedia");
    }

    @RequiresPermissions(value={"ele:globalLinkageMedia:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleGlobalLinkageMediaService.getItemById(id));
        }
        return new ModelAndView("ele/globalLinkageMedia/editEleGlobalLinkageMedia");
    }

    @RequiresPermissions(value={"ele:globalLinkageMedia:edit"})
    public ZKResultMsg save(EleGlobalLinkageMediaItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleGlobalLinkageMediaService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:globalLinkageMedia:refresh"})
    public DxGrid list(EleGlobalLinkageMediaItem condition) {
        Pager pager = this.eleGlobalLinkageMediaService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:globalLinkageMedia:del"})
    public ZKResultMsg del(String ids) {
        this.eleGlobalLinkageMediaService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

