/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleFloorRemote;
import com.zkteco.zkbiosecurity.ele.service.EleBaseDictionaryService;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.service.EleFloorService;
import com.zkteco.zkbiosecurity.ele.service.EleRTMonitorService;
import com.zkteco.zkbiosecurity.ele.vo.EleFloorItem;
import com.zkteco.zkbiosecurity.ele.vo.EleGlobalLinkageFloorItem;
import com.zkteco.zkbiosecurity.ele.vo.EleLevelFloorItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleFloorController
extends BaseController
implements EleFloorRemote {
    @Autowired
    private EleFloorService eleFloorService;
    @Autowired
    private EleDeviceService eleDeviceService;
    @Autowired
    private EleRTMonitorService eleRTMonitorService;
    @Autowired
    private EleBaseDictionaryService eleBaseDictionaryService;

    @RequiresPermissions(value={"ele:floor"})
    public ModelAndView index() {
        return new ModelAndView("ele/floor/eleFloor");
    }

    @RequiresPermissions(value={"ele:floor:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleFloorService.getItemById(id));
        }
        return new ModelAndView("ele/floor/editEleFloor");
    }

    public ModelAndView getFloorIds(String type, String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        Map retMap = this.eleFloorService.getFloorIds(idList);
        this.request.setAttribute("ids", retMap.get("ids"));
        this.request.setAttribute("floorsName", retMap.get("floorsName"));
        this.request.setAttribute("floorNormalOpen", retMap.get("floorNormalOpen"));
        this.request.setAttribute("disabledFloorsName", retMap.get("disabledFloorsName"));
        this.request.setAttribute("offlineFloorsName", retMap.get("offlineFloorsName"));
        this.request.setAttribute("type", (Object)type);
        return new ModelAndView("ele/floor/opEleFloor");
    }

    @RequiresPermissions(value={"ele:floor:edit"})
    @LogRequest(module="ele_module", object="ele_floor_entity", opType="common_op_edit", requestParams={"name"}, opContent="ele_floor_name")
    public ZKResultMsg save(EleFloorItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String applyTo = this.request.getParameter("applyTo");
        this.eleFloorService.saveFloor(item, applyTo, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:floor:refresh"})
    public DxGrid list(EleFloorItem condition) {
        Pager pager = this.eleFloorService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:floor:del"})
    public ZKResultMsg del(String ids) {
        this.eleFloorService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExist(EleFloorItem item) {
        String floorName = this.request.getParameter("floorName");
        if (!item.getName().equals(floorName)) {
            return this.eleFloorService.isExist(item.getName());
        }
        return true;
    }

    public DxGrid getGlobalLinkageFloorList(EleGlobalLinkageFloorItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if (condition.getType().equals("noSelected")) {
            StringBuilder filterIds = new StringBuilder(condition.getSelectId());
            if (StringUtils.isNotBlank((CharSequence)condition.getFilterId())) {
                filterIds.append(",").append(condition.getFilterId());
            }
            condition.setNotInId(filterIds.toString());
        } else if (condition.getType().equals("selected")) {
            condition.setInId(condition.getSelectId());
        }
        String authAreaIds = this.eleDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            condition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.eleFloorService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getLevelFloor(EleLevelFloorItem condition) {
        Pager pager = this.eleFloorService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public TreeItem getDevFloorTree() {
        List items = this.eleFloorService.createDevFloorTree();
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList((Collection)items);
        return new TreeItem("0", treeItems);
    }

    @LogRequest(module="ele_module", object="ele_floor_entity", opType="ele_eventNo_8", requestParams={"floorName"}, opContent="ele_floor_name")
    @RequiresPermissions(value={"ele:floor:openFloor"})
    public ZKResultMsg openFloor(String ids, String interval) {
        Map dataMap = this.eleRTMonitorService.operateFloor("openFloor", interval, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="ele_module", object="ele_floor_entity", opType="ele_eventNo_9", requestParams={"floorName"}, opContent="ele_floor_name")
    @RequiresPermissions(value={"ele:floor:closeFloor"})
    public ZKResultMsg closeFloor(String ids) {
        Map dataMap = this.eleRTMonitorService.operateFloor("closeFloor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="ele_module", object="ele_floor_entity", opType="ele_eventNo_205", requestParams={"floorName"}, opContent="ele_floor_name")
    @RequiresPermissions(value={"ele:floor:normalOpenFloor"})
    public ZKResultMsg normalOpenFloor(String ids) {
        Map dataMap = this.eleRTMonitorService.operateFloor("normalOpenFloor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="ele_module", object="ele_floor_entity", opType="ele_eventNo_11", requestParams={"floorName"}, opContent="ele_floor_name")
    @RequiresPermissions(value={"ele:floor:enableNormalOpenFloor"})
    public ZKResultMsg enableNormalOpenFloor(String ids) {
        Map dataMap = this.eleRTMonitorService.operateFloor("enableNormalOpenFloor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="ele_module", object="ele_floor_entity", opType="ele_eventNo_10", requestParams={"floorName"}, opContent="ele_floor_name")
    @RequiresPermissions(value={"ele:floor:disableNormalOpenFloor"})
    public ZKResultMsg disableNormalOpenFloor(String ids) {
        Map dataMap = this.eleRTMonitorService.operateFloor("disableNormalOpenFloor", null, ids);
        return this.dealResultData(dataMap);
    }

    private ZKResultMsg dealResultData(Map<String, String> dataMap) {
        String cmdIdData = dataMap.get("cmdId");
        String msg = "";
        ZKResultMsg resultMsg = new ZKResultMsg();
        if ("true".equals(dataMap.get("notExistDev"))) {
            msg = I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]);
            resultMsg.setMsg(msg);
            return resultMsg;
        }
        if (!"".equals(cmdIdData)) {
            for (String cmdData : cmdIdData.split(",")) {
                String cmdId = cmdData.split("=")[0];
                String floorName = cmdData.split("=")[1];
                Map resultMap = this.eleDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (Objects.isNull(resultMap)) {
                    msg = msg + floorName + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + ";";
                    continue;
                }
                Integer ret = Integer.valueOf((String)resultMap.get("result"));
                if (Objects.isNull(ret)) {
                    msg = msg + floorName + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + ";";
                    continue;
                }
                if (ret >= 0) continue;
                String failedInfo = I18nUtil.i18nCode((String)this.eleBaseDictionaryService.getCommReason(ret.intValue()), (Object[])new Object[0]);
                msg = msg + floorName + "," + I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0]) + failedInfo + ";";
            }
        }
        if (!"".equals(dataMap.get("offline"))) {
            for (String floorName : dataMap.get("offline").split(",")) {
                msg = msg + floorName + "," + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + ";";
            }
        }
        if (!"".equals(msg)) {
            resultMsg.setRet("400");
            resultMsg.setMsg(msg);
        }
        resultMsg.setData((Object)"");
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

