/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.zkteco.zkbiosecurity.auth.exception.ZKAuthException;
import com.zkteco.zkbiosecurity.auth.remote.LoginRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthBioVerifyService;
import com.zkteco.zkbiosecurity.auth.service.AuthSecurityParamsService;
import com.zkteco.zkbiosecurity.auth.service.AuthUserService;
import com.zkteco.zkbiosecurity.auth.service.AuthenticationServiceStrategy;
import com.zkteco.zkbiosecurity.auth.vo.AuthAppItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthAreaItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthDepartmentItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthUserItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.security.SessionManager;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;

@Controller
public class LoginController
extends BaseController
implements LoginRemote {
    @Autowired
    private AuthUserService authUserService;
    @Autowired
    private AuthenticationServiceStrategy authenticationServiceStrategy;
    @Autowired
    private AuthSecurityParamsService authSecurityParamsService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired(required=false)
    private BaseLicenseService baseLicenseService;
    @Autowired
    private AuthBioVerifyService authBioVerifyService;
    @Value(value="${system.homePage:main.do?home}")
    private String homeSkip;
    @Value(value="${system.language:zh_CN}")
    private String language;

    @LogRequest(module="system_module", object="auth_leftMenu_userManage", opType="auth_login_userLogin", requestParams={"username"}, opContent="auth_login_userLogin")
    public ZKResultMsg login(String username, String password, String checkCode, String loginType, String fpLogin, String verifyTemplate) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        loginType = StringUtils.isBlank((CharSequence)loginType) ? "NORMAL" : loginType;
        String allowType = "isSuperUser".equals(loginType) ? "NORMAL" : loginType;
        boolean isFilterException = false;
        try {
            if (!"fpLogin".equals(fpLogin) && StringUtils.equals((CharSequence)loginType, (CharSequence)"NORMAL")) {
                isFilterException = true;
                if (!this.authSecurityParamsService.allowLogin(username + allowType).booleanValue()) {
                    isFilterException = false;
                    throw ZKBusinessException.warnException((String)I18nUtil.i18nCode((String)"auth_security_errorLock", (Object[])new Object[]{this.authSecurityParamsService.getRemainingLockTime(username + allowType)}), (Object[])new Object[0]);
                }
                Boolean needValCode = this.authSecurityParamsService.getIsNeedVerCodeParams(this.request.getSession().getId());
                if (needValCode.booleanValue()) {
                    String codeValue = this.authSecurityParamsService.getVerCodeValue(this.request.getSession().getId());
                    if (StringUtils.isBlank((CharSequence)checkCode) || !checkCode.toUpperCase().equals(codeValue)) {
                        isFilterException = false;
                        throw ZKBusinessException.warnException((String)I18nUtil.i18nCode((String)"auth_license_validateCodeError", (Object[])new Object[0]), (Object[])new Object[0]);
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)fpLogin) && "fpLogin".equals(fpLogin)) {
                isFilterException = false;
                AuthUserItem fpUser = this.getFpLoginUser(verifyTemplate);
                if (fpUser == null || fpUser != null && StringUtils.isBlank((CharSequence)fpUser.getId())) {
                    throw new ZKBusinessException("notExist");
                }
                if (fpUser.getIsActive() == null || !fpUser.getIsActive().booleanValue()) {
                    throw new ZKBusinessException("disabled");
                }
                username = fpUser.getUsername();
                password = fpUser.getLoginPwd();
            }
            AuthUserItem authUser = this.authenticationServiceStrategy.login(loginType, username, password);
            this.authSecurityParamsService.clearLoginErrorCount(username + loginType, this.request.getSession().getId());
            if (authUser != null) {
                Integer count;
                if (this.baseLicenseService != null) {
                    this.baseLicenseService.checkLicensePreLogin(loginType, authUser.getIsSuperuser());
                }
                SecuritySubject securitySubject = new SecuritySubject(authUser.getId(), authUser.getUsername(), authUser.getName(), authUser.getIsSuperuser());
                securitySubject.setPermissions(authUser.getPermissionSet());
                securitySubject.setRoles(authUser.getRoleSet());
                securitySubject.setLoginType(loginType);
                securitySubject.setStaff(authUser.getIsStaff());
                securitySubject.setAreaIds(this.loadAreaIds(authUser, authUser.getAreaList()));
                securitySubject.setDepartmentIds(this.loadDepartmentIds(authUser, authUser.getDepartmentList()));
                securitySubject.setCompanyId(authUser.getCompanyId());
                securitySubject.setAppIds(this.loadAppIds(authUser, authUser.getAppList()));
                HttpSession session = this.request.getSession(false);
                if (session != null && !session.isNew()) {
                    HttpSession sessionOld = session;
                    sessionOld.removeAttribute("user");
                    HashMap<String, Object> sessionObj = new HashMap<String, Object>();
                    Enumeration keys = sessionOld.getAttributeNames();
                    while (keys.hasMoreElements()) {
                        String keyName = (String)keys.nextElement();
                        this.log.debug("sessionOld = key = " + keyName + " value= " + sessionOld.getAttribute(keyName));
                        sessionObj.put(keyName, sessionOld.getAttribute(keyName));
                    }
                    sessionOld.invalidate();
                    session = this.request.getSession(true);
                    for (String key : sessionObj.keySet()) {
                        session.setAttribute(key, sessionObj.get(key));
                    }
                    session.setAttribute("user", (Object)securitySubject);
                    this.licenseInfoForLogin(session);
                }
                Integer loginLimit = null;
                loginLimit = "PERS".equals(loginType) ? authUser.getUserLoginLimit() : this.authSecurityParamsService.getLoginPlaceCount(username);
                if (!Objects.isNull(loginLimit) && loginLimit > 0 && (count = this.sessionManager.countSessionByTarget(username + loginType)) >= loginLimit) {
                    isFilterException = false;
                    throw ZKAuthException.errorException((String)I18nUtil.i18nCode((String)"auth_authSecurity_exceededLoginLimit", (Object[])new Object[0]), (Object[])new Object[0]);
                }
                this.sessionManager.targetSession(this.request, username + loginType);
                if ("PERS".equals(loginType)) {
                    this.homeSkip = "main.do?home";
                }
                zkResultMsg.setData((Object)this.homeSkip);
            }
        }
        catch (ZKBusinessException e) {
            if (e.getMessage().equals("auth_login_userOrPwdError")) {
                this.log.error("login error", (Object)e.getMessage());
            } else {
                this.log.error("login error", (Throwable)e);
            }
            Integer count = null;
            if (isFilterException) {
                count = this.authSecurityParamsService.loginError(username + allowType, this.request.getSession().getId());
            }
            zkResultMsg = !Objects.isNull(count) ? (count <= 0 ? ZKResultMsg.getFailMsg((String)I18nUtil.i18nCode((String)"auth_security_errorLock", (Object[])new Object[]{this.getLockTime()})) : ZKResultMsg.getFailMsg((String)I18nUtil.i18nCode((String)"auth_authSecurity_loginError", (Object[])new Object[]{count, this.getLockTime()}))) : ZKResultMsg.getFailMsg((String)e.getMessage());
            throw new ZKBusinessException(e.getLevel(), zkResultMsg.getMsg());
        }
        catch (Exception e) {
            this.log.error("login error", (Throwable)e);
            zkResultMsg = ZKResultMsg.getFailMsg((String)"auth_login_exception");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    private void licenseInfoForLogin(HttpSession session) {
        session.setAttribute("language", (Object)this.language);
        session.setAttribute("companyName", (Object)this.baseLicenseService.getLicenseCompany().getName());
        session.setAttribute("systemModules", (Object)this.baseLicenseService.getLicenseModules());
        session.setAttribute("currentYear", (Object)Calendar.getInstance().get(1));
    }

    private Set<String> loadAreaIds(AuthUserItem authUser, List<AuthAreaItem> areas) {
        HashSet<String> ids = new HashSet<String>();
        for (AuthAreaItem item : areas) {
            ids.add(item.getId());
        }
        if (!authUser.getIsSuperuser().booleanValue()) {
            ids.add("-1");
        }
        return ids;
    }

    private Set<String> loadDepartmentIds(AuthUserItem authUser, List<AuthDepartmentItem> departments) {
        HashSet<String> ids = new HashSet<String>();
        for (AuthDepartmentItem item : departments) {
            ids.add(item.getId());
        }
        if (!authUser.getIsSuperuser().booleanValue()) {
            ids.add("-1");
        }
        return ids;
    }

    private Set<String> loadAppIds(AuthUserItem authUser, List<AuthAppItem> apps) {
        HashSet<String> ids = new HashSet<String>();
        for (AuthAppItem item : apps) {
            ids.add(item.getApplicationId());
        }
        if (!authUser.getIsSuperuser().booleanValue()) {
            ids.add("-1");
        }
        return ids;
    }

    private Long getLockTime() {
        Map lockMap = this.authSecurityParamsService.getParams("lockTime");
        Long lockTime = 10L;
        if (lockMap != null && StringUtils.isNotBlank((CharSequence)((CharSequence)lockMap.get("lockTime")))) {
            lockTime = this.authSecurityParamsService.getUserLockTime((String)lockMap.get("lockTime"));
            lockTime = TimeUnit.MILLISECONDS.toMinutes(lockTime);
        }
        return lockTime;
    }

    private AuthUserItem getFpLoginUser(String verifyTemplate) {
        String userId = this.authBioVerifyService.comparison(verifyTemplate);
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            AuthUserItem item = this.authUserService.getItemById(userId);
            return item;
        }
        return null;
    }

    public ZKResultMsg getFingerServiceConn() {
        if (this.authBioVerifyService.existFpServer()) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
    }
}

