/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.biometric.ZKCropFace;
import com.zkteco.zkbiosecurity.base.utils.SystemOsUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.dll.LibraryService;
import com.zkteco.zkbiosecurity.dll.LibraryUtil;
import com.zkteco.zkbiosecurity.system.service.BaseCropFaceService;
import com.zkteco.zkbiosecurity.system.service.impl.BaseFingerComparisonServiceImpl;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
@Order(value=12)
public class BaseCropFaceServiceImpl
implements BaseCropFaceService,
CommandLineRunner {
    private static Logger logger = LoggerFactory.getLogger(BaseFingerComparisonServiceImpl.class);
    @Autowired
    private LibraryService libraryService;
    private String serverIp = "localhost";
    private int serverPort = 26110;
    private String zkFaceInfo = "http://%s:%d/ZKDetectFace/info";
    private String zkFaceDetect = "http://%s:%d/ZKDetectFace/detect";
    @Autowired
    private RestTemplate restTemplate;
    private Boolean loadSuccess = false;
    private Boolean loadServiceSuccess = false;

    public void run(String ... args) throws Exception {
        try {
            this.loadServiceSuccess = this.existDetectFaceServer();
            logger.info("---------------- detect face service already exists is: " + this.loadServiceSuccess);
            if (!this.loadServiceSuccess.booleanValue()) {
                if (SystemOsUtil.isWindow()) {
                    this.libraryService.loadLibrary("cropface/simage");
                    this.libraryService.loadLibrary("cropface/zkipbase");
                    if (System.getProperty("sun.arch.data.model").equals("32")) {
                        this.libraryService.loadLibrary("cropface/vcomp140");
                        this.libraryService.loadLibrary("cropface/libgcc_s_dw2-1");
                    } else {
                        this.libraryService.loadLibrary("cropface/libgcc_s_sjlj-1");
                    }
                    this.libraryService.loadLibrary("cropface/libquadmath-0");
                    this.libraryService.loadLibrary("cropface/libgfortran-3");
                    this.libraryService.loadLibrary("cropface/libopenblas");
                    this.libraryService.loadLibrary("cropface/zkdnnapi");
                    this.libraryService.loadLibrary("cropface/zkcropface");
                    this.libraryService.loadLibrary("cropface/zkdnnfd");
                    this.libraryService.loadLibrary("cropface/zkcropfacejni");
                    int result = ZKCropFace.zkCropFaceInit(LibraryUtil.getDynamicLibAbsolutePath((String)"/cropface/zkdnn_fd.bin").getBytes());
                    this.loadSuccess = true;
                    logger.info("----------------  init crop Face result " + result + "----loadSuccess=" + this.loadSuccess);
                } else if (SystemOsUtil.isLinux()) {
                    this.libraryService.loadLibrary("simage");
                    this.libraryService.loadLibrary("zkipbase");
                    this.libraryService.loadLibrary("zkdnnapi");
                    this.libraryService.loadLibrary("zkcropface");
                    this.libraryService.loadLibrary("zkcropfacejni");
                    int result = ZKCropFace.zkCropFaceInit(LibraryUtil.getDynamicLibAbsolutePath((String)"/zkdnn_fd.bin").getBytes());
                    this.loadSuccess = true;
                    logger.info("----------------  init crop Face result " + result + "----loadSuccess=" + this.loadSuccess);
                }
            }
        }
        catch (Error e) {
            this.loadSuccess = false;
            logger.error("load crop library error", (Throwable)e);
        }
    }

    public int cropFace(String photoPath, String pin) {
        String cropFacePath = FileUtil.getCropFacePath((String)pin);
        return this.detectorCrop(photoPath, cropFacePath, pin);
    }

    public int cropFace(String photoPath, String business, String fileName) {
        String cropFacePath = FileUtil.getCropFacePath((String)business, (String)fileName);
        return this.detectorCrop(photoPath, cropFacePath, fileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int validCropFace(String photoPath) {
        if (!new File(photoPath).exists()) {
            logger.error("----------------  crop Face Failed  ----------  File is not find.");
            return -1002;
        }
        if (!this.loadServiceSuccess.booleanValue()) return 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "3");
        map.put("srcfilename", photoPath);
        String ret = this.postUriInfo(this.zkFaceDetect, map);
        if (StringUtils.isNotBlank((CharSequence)ret)) {
            JSONObject retJson = JSONObject.parseObject((String)ret);
            if (retJson.containsKey((Object)"ret")) {
                if (retJson.getString("ret").equals("0") || !retJson.containsKey((Object)"code")) return 0;
                logger.info("-----------------detect face fail! the code is:" + retJson.getString("code") + ". image is:" + photoPath);
                String[] codes = retJson.getString("code").split("#");
                if (StringUtils.isNotBlank((CharSequence)codes[0])) {
                    return Integer.parseInt(codes[0]);
                }
                logger.error("-----------------detect face fail! the result is:" + retJson + ". image is:" + photoPath);
                return -100;
            }
            logger.error("-----------------detect face fail! the result is:" + retJson + ". image is:" + photoPath);
            return -100;
        }
        logger.error("-----------------detect face fail! image is:" + photoPath);
        return -100;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int detectorCrop(String photoPath, String cropFacePath, String fileName) {
        if (!new File(photoPath).exists()) {
            logger.error("----------------  crop Face Failed  ----------  File is not find.");
            return -1002;
        }
        if (this.loadServiceSuccess.booleanValue()) {
            File cropFaceDirectory = new File(FileUtil.getLocalFullPath((String)cropFacePath));
            if (!cropFaceDirectory.exists()) {
                cropFaceDirectory.mkdirs();
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", "2");
            map.put("srcfilename", photoPath);
            map.put("desfilename", cropFaceDirectory.getAbsolutePath() + File.separator + fileName + ".jpg");
            String ret = this.postUriInfo(this.zkFaceDetect, map);
            if (StringUtils.isNotBlank((CharSequence)ret)) {
                JSONObject retJson = JSONObject.parseObject((String)ret);
                if (retJson.containsKey((Object)"ret")) {
                    if (retJson.getString("ret").equals("0")) {
                        JSONObject dataJson;
                        if (!retJson.containsKey((Object)"data") || !(dataJson = retJson.getJSONObject("data")).containsKey((Object)"score")) return 0;
                        logger.info("-----------------detect face score is:" + dataJson.getString("score") + ". image is:" + photoPath);
                        return dataJson.getInteger("score");
                    }
                    if (!retJson.containsKey((Object)"code")) return 0;
                    logger.info("-----------------detect face fail! the code is:" + retJson.getString("code") + ". image is:" + photoPath);
                    String[] codes = retJson.getString("code").split("#");
                    if (StringUtils.isNotBlank((CharSequence)codes[0])) {
                        return Integer.parseInt(codes[0]);
                    }
                    logger.error("-----------------detect face fail! the result is:" + retJson + ". image is:" + photoPath);
                    return -100;
                }
                logger.error("-----------------detect face fail! the result is:" + retJson + ". image is:" + photoPath);
                return -100;
            }
            logger.error("-----------------detect face fail! image is:" + photoPath);
            return -100;
        }
        if (!this.loadSuccess.booleanValue()) {
            logger.error("----------------  crop library load error can not crop.");
            return -1001;
        }
        File cropFaceDirectory = new File(FileUtil.getLocalFullPath((String)cropFacePath));
        if (!cropFaceDirectory.exists()) {
            cropFaceDirectory.mkdirs();
        }
        try {
            int result = ZKCropFace.zkCropFaceCrop(photoPath.getBytes(), (cropFaceDirectory.getAbsolutePath() + File.separator + fileName + ".jpg").getBytes());
            if (result > 0) return result;
            FileUtil.deleteFile((String)(cropFaceDirectory.getAbsolutePath() + File.separator + fileName + ".jpg"));
            logger.error(fileName + "----------------  crop Face Failed  ----------  result:" + result);
            return result;
        }
        catch (Exception e) {
            logger.error("----------------  crop Face Failed Exception ", (Throwable)e);
        }
        return 0;
    }

    private String getUriInfo(String format) {
        String uri = String.format(format, this.serverIp, this.serverPort);
        String ret = "";
        try {
            ret = (String)this.restTemplate.getForObject(uri, String.class, new Object[0]);
        }
        catch (Exception e) {
            logger.info("Connect the face service failed!");
        }
        return ret;
    }

    private String postUriInfo(String format, Map<String, Object> map) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity entity = new HttpEntity(map, (MultiValueMap)headers);
        String uri = String.format(format, this.serverIp, this.serverPort);
        String result = "";
        try {
            result = (String)this.restTemplate.postForObject(uri, (Object)entity, String.class, new Object[0]);
        }
        catch (Exception e) {
            logger.info("Connect the face service failed!");
        }
        return result;
    }

    public boolean existDetectFaceServer() {
        JSONObject retJson;
        String ret = this.getUriInfo(this.zkFaceInfo);
        return StringUtils.isNotBlank((CharSequence)ret) && (retJson = JSONObject.parseObject((String)ret)) != null;
    }

    public boolean loadDetectServiceSuccess() {
        return this.loadServiceSuccess;
    }
}

