/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POSID_ACCOUNT t ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={})
public class PosIDTransactionRecordCardBlanceItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sort="na", show=false)
    private String id;
    @Column(name="t.PERSON_ID")
    @GridColumn(label="posid_transactionCard_personId", show=false)
    private String personId;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100", i18n=true)
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="posid_card_deptName", width="110")
    private String deptName;
    @Column(name="t.ACCOUNT_NO")
    @GridColumn(label="posid_card_accountNum", width="85")
    private String accountNo;
    @Column(name="t.STATUS")
    @GridColumn(label="posid_account_name", width="85", format="1=posid_card_changeOperator,0=posid_iccard_initName")
    private Integer status;
    @Column(name="t.ISSUE_DATE")
    @GridColumn(label="posid_card_sendCardDate", width="210")
    private Date issueDate;
    @Column(name="t.BALANCE")
    @GridColumn(label="posid_common_money", format="0=0.0", columnType="custom", convert="convertFen2Yuan")
    private Integer balance;
    @Condition(value="t.ISSUE_DATE", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.ISSUE_DATE", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;

    public PosIDTransactionRecordCardBlanceItem() {
    }

    public PosIDTransactionRecordCardBlanceItem(Boolean equals) {
        super(equals);
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public Integer getBalance() {
        return this.balance;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public PosIDTransactionRecordCardBlanceItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDTransactionRecordCardBlanceItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDTransactionRecordCardBlanceItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDTransactionRecordCardBlanceItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDTransactionRecordCardBlanceItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDTransactionRecordCardBlanceItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDTransactionRecordCardBlanceItem setAccountNo(String accountNo) {
        this.accountNo = accountNo;
        return this;
    }

    public PosIDTransactionRecordCardBlanceItem setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public PosIDTransactionRecordCardBlanceItem setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public PosIDTransactionRecordCardBlanceItem setBalance(Integer balance) {
        this.balance = balance;
        return this;
    }

    public PosIDTransactionRecordCardBlanceItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosIDTransactionRecordCardBlanceItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosIDTransactionRecordCardBlanceItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDTransactionRecordCardBlanceItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String toString() {
        return "PosIDTransactionRecordCardBlanceItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptName=" + this.getDeptName() + ", accountNo=" + this.getAccountNo() + ", status=" + this.getStatus() + ", issueDate=" + this.getIssueDate() + ", balance=" + this.getBalance() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ")";
    }
}

