/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.UUID;

@From(after="POSID_ORDER_PRODUCT p LEFT JOIN POSID_ORDER_PRODUCT_MEAL m ON m.ORDER_PRODUCT_ID = p.ID LEFT JOIN POSID_ORDER_STORE_DETAIL d ON d.ORDER_PRODUCT_MEAL_ID = m.ID ")
@GroupBy(after="d.STORE_DETAIL_NAME, d.STORE_DETAIL_CODE, d.STORE_IMAGE_PATH")
@OrderBy(after="d.STORE_DETAIL_CODE ASC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={})
public class PosIDStoreDetailSumItem
extends BaseItem {
    @GridColumn(show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="d.STORE_DETAIL_CODE")
    @GridColumn(label="posid_storeDetail_code", width="200")
    private String storeDetailCode;
    @Column(name="d.STORE_DETAIL_NAME")
    @GridColumn(label="posid_storeDetail_name", width="200")
    private String storeDetailName;
    @Column(name="d.STORE_IMAGE_PATH")
    @GridColumn(label="posid_storeDetail_imgPath", width="140", columnType="custom", convert="changePic", align="center")
    private String storeImagePath;
    @Column(name="SUM(d.STORE_DETAIL_NUMBER)")
    @GridColumn(label="posid_storeDetail_amount", width="200")
    private String storeDetailNumber;
    @Condition(value="p.HALLING_ID", equalTag="=")
    private String hallingId;
    @Condition(value="m.MEAL_ID", equalTag="=")
    private String mealId;
    @Condition(value="p.ORDER_DATE", equalTag=">=")
    private Date startTime;
    @Condition(value="p.ORDER_DATE", equalTag="<=")
    private Date endTime;
    private String orderTime;

    public String getId() {
        return this.id;
    }

    public String getStoreDetailCode() {
        return this.storeDetailCode;
    }

    public String getStoreDetailName() {
        return this.storeDetailName;
    }

    public String getStoreImagePath() {
        return this.storeImagePath;
    }

    public String getStoreDetailNumber() {
        return this.storeDetailNumber;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getMealId() {
        return this.mealId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getOrderTime() {
        return this.orderTime;
    }

    public PosIDStoreDetailSumItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDStoreDetailSumItem setStoreDetailCode(String storeDetailCode) {
        this.storeDetailCode = storeDetailCode;
        return this;
    }

    public PosIDStoreDetailSumItem setStoreDetailName(String storeDetailName) {
        this.storeDetailName = storeDetailName;
        return this;
    }

    public PosIDStoreDetailSumItem setStoreImagePath(String storeImagePath) {
        this.storeImagePath = storeImagePath;
        return this;
    }

    public PosIDStoreDetailSumItem setStoreDetailNumber(String storeDetailNumber) {
        this.storeDetailNumber = storeDetailNumber;
        return this;
    }

    public PosIDStoreDetailSumItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDStoreDetailSumItem setMealId(String mealId) {
        this.mealId = mealId;
        return this;
    }

    public PosIDStoreDetailSumItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public PosIDStoreDetailSumItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public PosIDStoreDetailSumItem setOrderTime(String orderTime) {
        this.orderTime = orderTime;
        return this;
    }

    public String toString() {
        return "PosIDStoreDetailSumItem(id=" + this.getId() + ", storeDetailCode=" + this.getStoreDetailCode() + ", storeDetailName=" + this.getStoreDetailName() + ", storeImagePath=" + this.getStoreImagePath() + ", storeDetailNumber=" + this.getStoreDetailNumber() + ", hallingId=" + this.getHallingId() + ", mealId=" + this.getMealId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", orderTime=" + this.getOrderTime() + ")";
    }
}

