/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POSID_TRANSACTION T")
@GroupBy(after=" T.DEPT_ID, T.DEPT_NAME")
@OrderBy(after="T.DEPT_ID")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDDeptConsumeExportItem
extends BaseItem {
    @GridColumn(show=false)
    private String id;
    @Column(name="t.DEPT_ID")
    @GridColumn(label="posid_transaction_deptId", show=false)
    private String deptId;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="posid_card_deptName", width="110", i18n=true)
    private String deptName;
    @Column(name="sum(case when t.TYPE_NAME = 6  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_conTimes", width="120")
    private Integer conTimes;
    @Column(name="sum(case when t.TYPE_NAME = 6  then t.MONEY  else 0 end)")
    @GridColumn(label="posid_countTable_consumTotal", width="115", columnType="custom", convert="convertFen2Yuan")
    private Double consumtotal;
    @Column(name="sum(case when t.TYPE_NAME = 6  then t.DISCOUNT_MONEY  else 0 end)")
    @GridColumn(label="posid_consume_discount_money_sum", width="115", columnType="custom", convert="convertFen2Yuan")
    private Double discountMoney;
    @Column(name="sum(case when t.TYPE_NAME = 10 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_orderTimes", width="100")
    private Integer ordertimes;
    @Column(name="sum(case when t.TYPE_NAME = 9  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_errorTimes", width="170")
    private Integer errortimes;
    @Column(name="sum(case when t.TYPE_NAME = 9  then t.MONEY else 0 end)")
    @GridColumn(label="posid_countTable_errorTotal", width="135", columnType="custom", convert="convertFen2Yuan")
    private Double errortotal;
    @Column(name="(sum(case when t.TYPE_NAME = 8  then 1 else 0 end))")
    @GridColumn(label="posid_countTable_suppleTimes", width="130")
    private Integer suppletimes;
    @Column(name="sum(case when t.TYPE_NAME = 8  then t.MONEY else 0 end)")
    @GridColumn(label="posid_countTable_suppleTotal", width="160", columnType="custom", convert="convertFen2Yuan")
    private Double suppletotal;
    @Column(name="(sum(case when t.TYPE_NAME = 11  then 1 else 0 end))")
    @GridColumn(label="posid_countTable_accountTimes", width="70", show=false)
    private Integer accounttimes;
    @Column(name="sum(case when t.TYPE_NAME = 11  then t.MONEY else 0 end)")
    @GridColumn(label="posid_countTable_accountTotal", width="80", columnType="custom", convert="convertFen2Yuan", show=false)
    private Double accountTotal;
    @Column(name="sum(case when t.TYPE_NAME = 6 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_actualTimes", width="120")
    private Integer actualtimes;
    @Column(name="sum(case when t.TYPE_NAME = 6  then t.MONEY else 0 end)")
    @GridColumn(label="posid_countTable_equipTotal", width="130", columnType="custom", convert="convertFen2Yuan")
    private Double equipTotal;
    @Column(name="(sum(case when t.TYPE_NAME = 6  then t.MONEY else 0 end)+sum(case when t.TYPE_NAME = 8  then t.MONEY else 0 end))")
    @GridColumn(label="posid_countTable_sysTotal", width="150", columnType="custom", convert="convertFen2Yuan")
    private Double sysTotal;
    @Column(name="(sum(case when t.TYPE_NAME = 6  then t.MONEY else 0 end)+sum(case when t.TYPE_NAME = 11  then t.MONEY else 0 end))")
    @GridColumn(label="posid_countTable_containAccTotal", width="150", columnType="custom", convert="convertFen2Yuan")
    private Double containAccTotal;
    @GridColumn(label="posid_countTable_conTimeStr", minWidth="160", width="170", sort="na")
    private String posTime;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;

    public PosIDDeptConsumeExportItem() {
        this.id = UUID.randomUUID().toString();
    }

    public PosIDDeptConsumeExportItem(Boolean equals) {
        super(equals);
    }

    public PosIDDeptConsumeExportItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Integer getConTimes() {
        return this.conTimes;
    }

    public Double getConsumtotal() {
        return this.consumtotal;
    }

    public Double getDiscountMoney() {
        return this.discountMoney;
    }

    public Integer getOrdertimes() {
        return this.ordertimes;
    }

    public Integer getErrortimes() {
        return this.errortimes;
    }

    public Double getErrortotal() {
        return this.errortotal;
    }

    public Integer getSuppletimes() {
        return this.suppletimes;
    }

    public Double getSuppletotal() {
        return this.suppletotal;
    }

    public Integer getAccounttimes() {
        return this.accounttimes;
    }

    public Double getAccountTotal() {
        return this.accountTotal;
    }

    public Integer getActualtimes() {
        return this.actualtimes;
    }

    public Double getEquipTotal() {
        return this.equipTotal;
    }

    public Double getSysTotal() {
        return this.sysTotal;
    }

    public Double getContainAccTotal() {
        return this.containAccTotal;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public PosIDDeptConsumeExportItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDDeptConsumeExportItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDDeptConsumeExportItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDDeptConsumeExportItem setConTimes(Integer conTimes) {
        this.conTimes = conTimes;
        return this;
    }

    public PosIDDeptConsumeExportItem setConsumtotal(Double consumtotal) {
        this.consumtotal = consumtotal;
        return this;
    }

    public PosIDDeptConsumeExportItem setDiscountMoney(Double discountMoney) {
        this.discountMoney = discountMoney;
        return this;
    }

    public PosIDDeptConsumeExportItem setOrdertimes(Integer ordertimes) {
        this.ordertimes = ordertimes;
        return this;
    }

    public PosIDDeptConsumeExportItem setErrortimes(Integer errortimes) {
        this.errortimes = errortimes;
        return this;
    }

    public PosIDDeptConsumeExportItem setErrortotal(Double errortotal) {
        this.errortotal = errortotal;
        return this;
    }

    public PosIDDeptConsumeExportItem setSuppletimes(Integer suppletimes) {
        this.suppletimes = suppletimes;
        return this;
    }

    public PosIDDeptConsumeExportItem setSuppletotal(Double suppletotal) {
        this.suppletotal = suppletotal;
        return this;
    }

    public PosIDDeptConsumeExportItem setAccounttimes(Integer accounttimes) {
        this.accounttimes = accounttimes;
        return this;
    }

    public PosIDDeptConsumeExportItem setAccountTotal(Double accountTotal) {
        this.accountTotal = accountTotal;
        return this;
    }

    public PosIDDeptConsumeExportItem setActualtimes(Integer actualtimes) {
        this.actualtimes = actualtimes;
        return this;
    }

    public PosIDDeptConsumeExportItem setEquipTotal(Double equipTotal) {
        this.equipTotal = equipTotal;
        return this;
    }

    public PosIDDeptConsumeExportItem setSysTotal(Double sysTotal) {
        this.sysTotal = sysTotal;
        return this;
    }

    public PosIDDeptConsumeExportItem setContainAccTotal(Double containAccTotal) {
        this.containAccTotal = containAccTotal;
        return this;
    }

    public PosIDDeptConsumeExportItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDDeptConsumeExportItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosIDDeptConsumeExportItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosIDDeptConsumeExportItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public String toString() {
        return "PosIDDeptConsumeExportItem(id=" + this.getId() + ", deptId=" + this.getDeptId() + ", deptName=" + this.getDeptName() + ", conTimes=" + this.getConTimes() + ", consumtotal=" + this.getConsumtotal() + ", discountMoney=" + this.getDiscountMoney() + ", ordertimes=" + this.getOrdertimes() + ", errortimes=" + this.getErrortimes() + ", errortotal=" + this.getErrortotal() + ", suppletimes=" + this.getSuppletimes() + ", suppletotal=" + this.getSuppletotal() + ", accounttimes=" + this.getAccounttimes() + ", accountTotal=" + this.getAccountTotal() + ", actualtimes=" + this.getActualtimes() + ", equipTotal=" + this.getEquipTotal() + ", sysTotal=" + this.getSysTotal() + ", containAccTotal=" + this.getContainAccTotal() + ", posTime=" + this.getPosTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ")";
    }
}

