/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.license.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.remote.BaseLicenseRemote;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.license.vo.bean.LicCompany;
import com.zkteco.zkbiosecurity.license.vo.bean.SystemClientInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BaseLicenseController
extends BaseController
implements BaseLicenseRemote {
    private static final Logger logger = LoggerFactory.getLogger(BaseLicenseController.class);
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Value(value="${system.language:zh_CN}")
    private String language;
    @Value(value="${cloud.server.register.url:}")
    private String cloudRegiterUrl;
    public static final String EMAIL_VALIDATE_CODE_SESSION_STR = "emailValiateCode";
    @Value(value="${system.software.environment:Windows 7, Windows 8, Windows10, Windows Server 2008/2012, PostgreSQL, Oracle 11g/12c, SQLServer 2005/2008/2012}")
    private String softwareEnvironment;
    @Value(value="${system.software.resolution:1024\u00d7768}")
    private String softwareResolution;
    @Value(value="${system.software.browsers:Internet Explorer 11+/Firefox 27+/Chrome 33+}")
    private String softwareBrowsers;
    @Value(value="${system.productCode:}")
    private String productCode;

    public ModelAndView getLicenseInfo() {
        Map map = this.baseLicenseService.getLicenseInfo();
        this.request.getServletContext().setAttribute("language", (Object)this.language);
        this.request.getServletContext().setAttribute("systemVersion", map.get("systemVersion"));
        this.request.setAttribute("curVersion", map.get("curVersion"));
        this.request.setAttribute("jarVersionMap", map.get("jarVersionMap"));
        this.request.setAttribute("packageBits", map.get("packageBits"));
        this.request.setAttribute("packageTime", map.get("packageTime"));
        this.request.setAttribute("licenseId", map.get("licenseId"));
        this.request.setAttribute("licenseInfoListT", map.get("licenseInfoListT"));
        this.request.setAttribute("hasLicenseModule", map.get("hasLicenseModule"));
        this.request.setAttribute("hasLicenseId", map.get("hasLicenseId"));
        this.request.setAttribute("productName", map.get("productName"));
        this.request.setAttribute("curYear", map.get("curYear"));
        this.request.setAttribute("zkposCount", map.get("zkposCount"));
        this.request.setAttribute("zkposVersion", map.get("zkposVersion"));
        this.request.setAttribute("zktimeCount", map.get("zktimeCount"));
        this.request.setAttribute("zktimeVersion", map.get("zktimeVersion"));
        this.request.setAttribute("count", map.get("count"));
        this.request.setAttribute("zkecoVersion", map.get("zkecoVersion"));
        this.request.setAttribute("ecoIntegate", map.get("ecoIntegate"));
        this.request.setAttribute("appId", (Object)this.baseLicenseService.getAppId());
        this.request.getSession().setAttribute("isLicenseTest", map.get("isLicenseTest"));
        this.request.setAttribute("cloudRegiterUrl", (Object)this.cloudRegiterUrl);
        this.licenseInfoForLogin();
        this.softwareEnvironment();
        return new ModelAndView("system/license/authLicense");
    }

    private void softwareEnvironment() {
        String[] softwareEnvironments;
        ArrayList<String> list = new ArrayList<String>();
        for (String en : softwareEnvironments = this.softwareEnvironment.split(",")) {
            if (!"ZKBioAccess".equals(this.productCode)) {
                list.add(" " + en);
                continue;
            }
            if (en.contains("Oracle") || en.contains("SQLServer")) continue;
            list.add(" " + en);
        }
        this.request.getSession().setAttribute("softwareEnvironment", (Object)StringUtils.join(list, (String)","));
        this.request.getSession().setAttribute("softwareResolution", (Object)this.softwareResolution);
        this.request.getSession().setAttribute("softwareBrowsers", (Object)this.softwareBrowsers);
    }

    public ModelAndView getLicenseDetails() {
        Map map = this.baseLicenseService.getLicenseDetails();
        this.request.setAttribute("licenseDetailList", map.get("licenseDetailList"));
        return new ModelAndView("system/license/authLicenseDetails");
    }

    public ZKResultMsg getCountries() {
        String continentCode = this.request.getParameter("continent");
        String countryCode = this.request.getParameter("country");
        List countries = this.baseLicenseService.getCountries(continentCode, countryCode);
        return new ZKResultMsg((Object)countries);
    }

    public ZKResultMsg sendEmailValidateCode() {
        String email = this.request.getParameter("email");
        String code = this.baseLicenseService.sendEmailValidateCode(email);
        this.request.getSession().setAttribute(EMAIL_VALIDATE_CODE_SESSION_STR, (Object)code);
        ZKResultMsg retMsg = new ZKResultMsg();
        retMsg.setMsg(code);
        return retMsg;
    }

    public ZKResultMsg validateValidateCode() {
        String rCode;
        ZKResultMsg retMsg = new ZKResultMsg();
        String code = this.request.getParameter("validateCode");
        boolean flag = this.baseLicenseService.validateValidateCode(code, rCode = (String)this.request.getSession().getAttribute(EMAIL_VALIDATE_CODE_SESSION_STR));
        if (flag) {
            return retMsg;
        }
        retMsg.setRet("fail");
        return retMsg;
    }

    public ModelAndView registPage(@RequestParam String activeType) {
        Map map = this.baseLicenseService.registPage();
        this.request.setAttribute("continents", map.get("continents"));
        this.request.setAttribute("countries", map.get("countries"));
        this.request.setAttribute("industries", map.get("industries"));
        this.request.setAttribute("company", map.get("company"));
        this.request.setAttribute("language", (Object)this.language);
        this.request.getSession().setAttribute("isLocal", (Object)("zh_CN".equals(this.language) ? 1 : 0));
        this.licenseInfoForLogin();
        if ("online".equals(activeType)) {
            return new ModelAndView("system/license/authLicenseReg");
        }
        return new ModelAndView("system/license/authLicenseRegOff");
    }

    public ModelAndView activeOffline() {
        return new ModelAndView("system/license/authLicenseActiveOff");
    }

    public ZKResultMsg doRegiest(@RequestParam(value="upload") MultipartFile upload, @RequestParam String activeType, LicCompany company) throws Exception {
        boolean online = "online".equals(activeType);
        String ret = "";
        if (upload != null) {
            ret = this.baseLicenseService.doRegiest(upload.getInputStream(), activeType, JSONObject.toJSONString((Object)company));
        }
        this.licenseInfoForLogin();
        return new ZKResultMsg((Object)ret);
    }

    public ZKResultMsg uploadLicenseFile(@RequestParam(value="upload") MultipartFile upload) throws Exception {
        if (upload == null) {
            throw new ZKBusinessException("LicenseError:E0008");
        }
        String ret = this.baseLicenseService.uploadLicenseFile(upload.getInputStream());
        ZKResultMsg msg = new ZKResultMsg();
        msg.setMsg(ret);
        return msg;
    }

    public String downloadUpkFile() {
        String agent = this.request.getHeader("User-Agent");
        String fileNamePrefix = this.baseLicenseService.downloadUpkFile(agent);
        InputStream in = null;
        OutputStream out = null;
        try {
            this.response.setHeader("content-disposition", String.format("attachment;filename=\"%s_lic_upk.xml\"", fileNamePrefix));
            File file = new File(ClassUtil.getRootPath() + "/license/licdl.xml");
            in = new FileInputStream(file);
            int len = 0;
            byte[] buffer = new byte[1024];
            out = this.response.getOutputStream();
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    out.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    public ZKResultMsg licenseFileExists() {
        this.baseLicenseService.licenseFileExists();
        return new ZKResultMsg();
    }

    public void exportLicenseFile() throws Exception {
        ServletOutputStream out = null;
        String agent = this.request.getHeader("User-Agent");
        String fileNamePrefix = this.baseLicenseService.exportLicenseFile(agent);
        this.response.setHeader("content-disposition", String.format("attachment;filename=%s-License.xml", fileNamePrefix));
        out = this.response.getOutputStream();
        this.baseLicenseService.exportLicenseFile((OutputStream)out);
    }

    public ZKResultMsg importLicenseFile(@RequestParam(value="upload") MultipartFile upload) throws Exception {
        if (upload == null) {
            throw new ZKBusinessException("LicenseError:E0008");
        }
        String ret = this.baseLicenseService.importLicenseFile(upload.getInputStream(), upload.getOriginalFilename());
        this.licenseInfoForLogin();
        return new ZKResultMsg((Object)ret);
    }

    public ZKResultMsg cancelLicense() {
        String ret = this.baseLicenseService.cancelLicense();
        this.licenseInfoForLogin();
        this.request.getServletContext().setAttribute("companyName", (Object)"");
        return new ZKResultMsg((Object)ret);
    }

    public ModelAndView importLicensePage() {
        return new ModelAndView("system/license/authLicenseImport");
    }

    public ZKResultMsg updateServerLicense() {
        String ret = this.baseLicenseService.updateServerLicense();
        this.licenseInfoForLogin();
        return new ZKResultMsg((Object)ret);
    }

    public ZKResultMsg registerCloudService(SystemClientInfo systemClientInfo) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.baseLicenseService.registerCloudService(systemClientInfo));
    }

    public ZKResultMsg licenseInfoForLogin() {
        Map map = this.baseLicenseService.licenseInfoForLogin();
        this.request.getSession().setAttribute("language", (Object)this.language);
        this.request.getSession().setAttribute("companyName", map.get("companyName"));
        this.request.getSession().setAttribute("LICENSE_OVER_LIMIT", map.get("LICENSE_OVER_LIMIT"));
        this.request.getSession().setAttribute("systemModules", map.get("systemModules"));
        this.request.getSession().setAttribute("currentYear", (Object)Calendar.getInstance().get(1));
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)map);
        return new ZKResultMsg((Object)jsonObject);
    }

    public ZKResultMsg getAppId() {
        return new ZKResultMsg((Object)this.baseLicenseService.getAppId());
    }

    public ModelAndView getLicenseCompany() {
        this.request.setAttribute("item", (Object)this.baseLicenseService.getLicenseCompany());
        return new ModelAndView("system/license/registCompany");
    }

    public ModelAndView toCloudActivatePage() {
        return new ModelAndView("system/license/cloudActivate");
    }

    public ZKResultMsg cloudActivateByAppIdAndKey(String appId, String appKey) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.baseLicenseService.cloudActivate(appId, appKey));
    }

    public ZKResultMsg testLicenseServer() {
        return this.baseLicenseService.testLicenseServer() ? ZKResultMsg.successMsg() : ZKResultMsg.failMsg();
    }

    public ModelAndView connectError() {
        return new ModelAndView("system/license/authLicenseConnectError");
    }
}

