/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.JavaConsole;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.applet.AppletSecurityContextManager;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginCallRequest;
import sun.applet.PluginDebug;
import sun.applet.PluginException;
import sun.applet.PluginMessageConsumer;
import sun.applet.RequestQueue;

public class PluginStreamHandler {
    public static final PluginStreamHandler DummyHandler = new PluginStreamHandler(new InputStream(){

        @Override
        public int read() throws IOException {
            return 0;
        }
    }, new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    });
    private final BufferedReader pluginInputReader;
    private final BufferedWriter pluginOutputWriter;
    private final RequestQueue queue = new RequestQueue();
    private final PluginMessageConsumer consumer;
    private volatile boolean shuttingDown = false;

    public PluginStreamHandler(InputStream inputstream, OutputStream outputstream) {
        PluginDebug.debug("Current context CL=", Thread.currentThread().getContextClassLoader());
        PluginDebug.debug("Creating consumer...");
        this.consumer = new PluginMessageConsumer(this);
        this.pluginInputReader = new BufferedReader(new InputStreamReader(inputstream, Charset.forName("UTF-8")));
        this.pluginOutputWriter = new BufferedWriter(new OutputStreamWriter(outputstream, Charset.forName("UTF-8")));
    }

    public void startProcessing() {
        Thread listenerThread = new Thread("PluginStreamHandlerListenerThread"){

            @Override
            public void run() {
                while (true) {
                    PluginDebug.debug("Waiting for data...");
                    String s = PluginStreamHandler.this.read();
                    if (s != null) {
                        PluginStreamHandler.this.consumer.queue(s);
                        continue;
                    }
                    try {
                        PluginStreamHandler.this.pluginInputReader.close();
                        PluginStreamHandler.this.pluginOutputWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    AppletSecurityContextManager.dumpStore(0);
                    PluginDebug.debug("APPLETVIEWER: exiting appletviewer");
                    JNLPRuntime.exit(0);
                }
            }
        };
        listenerThread.start();
    }

    private int readPair(String message, int start, String[] array) {
        int end = start;
        array[0] = null;
        array[1] = null;
        if (message.length() > start) {
            int firstSpace = message.indexOf(32, start);
            if (firstSpace == -1) {
                array[0] = message.substring(start);
                end = message.length();
            } else {
                array[0] = message.substring(start, firstSpace);
                if (message.length() > firstSpace + 1) {
                    int secondSpace = message.indexOf(32, firstSpace + 1);
                    if (secondSpace == -1) {
                        array[1] = message.substring(firstSpace + 1);
                        end = message.length();
                    } else {
                        array[1] = message.substring(firstSpace + 1, secondSpace);
                        end = secondSpace + 1;
                    }
                }
            }
        }
        PluginDebug.debug("readPair: '", array[0], "' - '", array[1], "' ", end);
        return end;
    }

    public void handleMessage(String message) throws PluginException {
        int reference = -1;
        String src = null;
        String[] privileges = null;
        String rest = "";
        String[] msgComponents = new String[2];
        int oldPos = 0;
        int pos = this.readPair(message, oldPos, msgComponents);
        if (msgComponents[0] == null || msgComponents[1] == null) {
            return;
        }
        if (msgComponents[0].startsWith("plugin")) {
            this.handlePluginMessage(message);
            return;
        }
        String type = msgComponents[0];
        int identifier = Integer.parseInt(msgComponents[1]);
        oldPos = pos;
        pos = this.readPair(message, oldPos, msgComponents);
        if ("reference".equals(msgComponents[0])) {
            reference = Integer.parseInt(msgComponents[1]);
            oldPos = pos;
            pos = this.readPair(message, oldPos, msgComponents);
        }
        if ("src".equals(msgComponents[0])) {
            src = msgComponents[1];
            oldPos = pos;
            pos = this.readPair(message, oldPos, msgComponents);
        }
        if ("privileges".equals(msgComponents[0])) {
            String privs = msgComponents[1];
            privileges = privs.split(",");
            oldPos = pos;
        }
        if (message.length() > oldPos) {
            rest = message.substring(oldPos);
        }
        try {
            PluginDebug.debug("Breakdown -- type: ", type, " identifier: ", identifier, " reference: ", reference, " src: ", src, " privileges: ", privileges, " rest: \"", rest, "\"");
            if (rest.contains("JavaScriptGetWindow") || rest.contains("JavaScriptGetMember") || rest.contains("JavaScriptSetMember") || rest.contains("JavaScriptGetSlot") || rest.contains("JavaScriptSetSlot") || rest.contains("JavaScriptEval") || rest.contains("JavaScriptRemoveMember") || rest.contains("JavaScriptCall") || rest.contains("JavaScriptFinalize") || rest.contains("JavaScriptToString")) {
                this.finishCallRequest("reference " + reference + " " + rest);
                return;
            }
            int freference = reference;
            String frest = rest;
            switch (type) {
                case "instance": {
                    PluginAppletViewer.handleMessage(identifier, freference, frest);
                    break;
                }
                case "context": {
                    PluginDebug.debug("Sending to PASC: ", identifier, "/", reference, " and ", rest);
                    AppletSecurityContextManager.handleMessage(identifier, reference, src, privileges, rest);
                }
            }
        }
        catch (Exception e) {
            throw new PluginException(this, identifier, reference, e);
        }
    }

    private void handlePluginMessage(String message) {
        switch (message) {
            case "plugin showconsole": {
                if (JavaConsole.isEnabled()) {
                    JavaConsole.getConsole().showConsoleLater();
                    break;
                }
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("DPJavaConsoleDisabledHint"));
                break;
            }
            case "plugin hideconsole": {
                if (JavaConsole.isEnabled()) {
                    JavaConsole.getConsole().hideConsoleLater();
                    break;
                }
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("DPJavaConsoleDisabledHint"));
                break;
            }
            default: {
                this.finishCallRequest(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCallRequest(PluginCallRequest request) {
        RequestQueue requestQueue = this.queue;
        synchronized (requestQueue) {
            this.queue.post(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCallRequest(String message) {
        PluginDebug.debug("DISPATCHCALLREQUESTS 1");
        RequestQueue requestQueue = this.queue;
        synchronized (requestQueue) {
            PluginDebug.debug("DISPATCHCALLREQUESTS 2");
            PluginCallRequest request = this.queue.pop();
            if (this.queue.size() != 0) {
                int size = this.queue.size();
                int count = 0;
                while (!request.serviceable(message)) {
                    PluginDebug.debug(request, " cannot service ", message);
                    if (count >= size) {
                        throw new RuntimeException("Unable to find processor for message " + message);
                    }
                    this.queue.post(request);
                    request = this.queue.pop();
                    ++count;
                }
            }
            PluginDebug.debug("DISPATCHCALLREQUESTS 3");
            if (request != null) {
                PluginDebug.debug("DISPATCHCALLREQUESTS 5");
                PluginCallRequest pluginCallRequest = request;
                synchronized (pluginCallRequest) {
                    request.parseReturn(message);
                    request.notifyAll();
                }
                PluginDebug.debug("DISPATCHCALLREQUESTS 6");
                PluginDebug.debug("DISPATCHCALLREQUESTS 7");
            }
        }
        PluginDebug.debug("DISPATCHCALLREQUESTS 8");
    }

    private String read() {
        String message;
        block4: {
            message = null;
            try {
                message = this.pluginInputReader.readLine();
                PluginDebug.debug("  PIPE: appletviewer read: ", message);
                if (message != null && !message.equals("shutdown")) break block4;
                this.shuttingDown = true;
                try {
                    this.pluginInputReader.close();
                    this.pluginOutputWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                AppletSecurityContextManager.dumpStore(0);
                PluginDebug.debug("APPLETVIEWER: exiting appletviewer");
                JNLPRuntime.exit(0);
            }
            catch (IOException e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String message) {
        PluginDebug.debug("  PIPE: appletviewer wrote: ", message);
        BufferedWriter bufferedWriter = this.pluginOutputWriter;
        synchronized (bufferedWriter) {
            try {
                this.pluginOutputWriter.write(message + "\n", 0, message.length());
                this.pluginOutputWriter.write(0);
                this.pluginOutputWriter.flush();
            }
            catch (IOException e) {
                if (!this.shuttingDown) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
                }
                PluginDebug.debug("Unable to write to PIPE. APPLETVIEWER exiting");
                JNLPRuntime.exit(1);
            }
        }
    }
}

