/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisTipStgAddPicRemote;
import com.zkteco.zkbiosecurity.sis.service.SisTipPicService;
import com.zkteco.zkbiosecurity.sis.service.SisTipStrategyService;
import com.zkteco.zkbiosecurity.sis.vo.SisTipPicItem;
import com.zkteco.zkbiosecurity.sis.vo.SisTipStrategyItem;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisTipStgAddPicController
extends ExportController
implements SisTipStgAddPicRemote {
    @Autowired
    private SisTipPicService sisTipPicService;
    @Autowired
    private SisTipStrategyService sisTipStrategyService;

    @RequiresPermissions(value={"sis:tipStgAddPic"})
    public ModelAndView index() {
        return new ModelAndView("sis/tipStgAddPic/sisTipStgAddPic");
    }

    @RequiresPermissions(value={"sis:tipStgAddPic:edit"})
    public ModelAndView edit() {
        String stdId = this.request.getParameter("stgId");
        SisTipStrategyItem item = this.sisTipStrategyService.findById(stdId);
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("sis/tipStgAddPic/editSisTipStgAddPic");
    }

    @RequiresPermissions(value={"sis:tipStgAddPic:edit"})
    public ZKResultMsg save(SisTipPicItem item) {
        ZKResultMsg ret = new ZKResultMsg();
        String tipPicIds = this.request.getParameter("tipPicIds");
        String stgId = this.request.getParameter("stgId");
        this.sisTipStrategyService.addTipPic(stgId, tipPicIds);
        return ret;
    }

    @RequiresPermissions(value={"sis:tipStgAddPic:refresh"})
    public DxGrid list(SisTipPicItem condition) {
        Pager pager = this.sisTipPicService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"sis:tipStgAddPic:del"})
    public ZKResultMsg del(String stgId, String ids) {
        ZKResultMsg ret = this.sisTipStrategyService.delTipPicByStgId(stgId, ids);
        return ret;
    }

    public ZKResultMsg loadStrategyPic(String id) {
        List result = this.sisTipStrategyService.getTipPicByStgId(id);
        return new ZKResultMsg((Object)result);
    }
}

