/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.bean.Tree;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisTipPicRemote;
import com.zkteco.zkbiosecurity.sis.service.SisTipPicService;
import com.zkteco.zkbiosecurity.sis.service.SisTipPicTypeService;
import com.zkteco.zkbiosecurity.sis.service.SisTipStrategyService;
import com.zkteco.zkbiosecurity.sis.vo.SisTipPicItem;
import com.zkteco.zkbiosecurity.sis.vo.SisTipPicTypeItem;
import java.io.File;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisTipPicController
extends ExportController
implements SisTipPicRemote {
    @Autowired
    private SisTipPicService sisTipPicService;
    @Autowired
    private SisTipPicTypeService sisTipPicTypeService;
    @Autowired
    private SisTipStrategyService sisTipStrategyService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;

    @RequiresPermissions(value={"sis:sisTipPic"})
    public ModelAndView index() {
        return new ModelAndView("sis/tipPic/sisTipPic");
    }

    @RequiresPermissions(value={"sis:sisTipPic:edit"})
    public ModelAndView edit(String id) {
        return new ModelAndView("sis/tipPic/editSisTipPic");
    }

    @RequiresPermissions(value={"sis:sisTipPic:edit"})
    @LogRequest(module="sis_module", object="sis_tip_pic", opType="common_op_edit", requestParams={"name"}, opContent="sis_tippic_name")
    public ZKResultMsg save(SisTipPicItem item) {
        return null;
    }

    @RequiresPermissions(value={"sis:sisTipPic:refresh"})
    public DxGrid list(SisTipPicItem condition) {
        condition.setNotInType("zkx");
        Pager pager = this.sisTipPicService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"sis:sisTipPic:del"})
    @LogRequest(module="sis_module", object="sis_tip_pic", opType="common_op_del", requestParams={"name"}, opContent="sis_tippic_name")
    public ZKResultMsg del(String ids) {
        boolean ret = this.sisTipPicService.deleteByIds(ids);
        if (!ret) {
            I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)"\u64cd\u4f5c\u5931\u8d25\uff01\u56fe\u7247\u5b58\u5728\u4e8e\u7b56\u7565\u4e2d"));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)"\u64cd\u4f5c\u5b8c\u6210\uff01"));
    }

    public Tree dynaTree(String id) {
        SisTipPicTypeItem condition = new SisTipPicTypeItem();
        List sisTipPicTypeItems = this.sisTipPicTypeService.getByCondition(condition);
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        for (SisTipPicTypeItem type : sisTipPicTypeItems) {
            item = new TreeItem();
            item.setId(type.getId());
            item.setText(type.getName());
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        Tree tree = new Tree(treeItems);
        tree.setId(StringUtils.isBlank((CharSequence)id) ? "0" : id);
        return tree;
    }

    public JSONArray getAllJPGPhoto() {
        String typeId = this.request.getParameter("typeId");
        JSONArray jsons = new JSONArray();
        SisTipPicItem condition = new SisTipPicItem();
        if (StringUtils.isNotBlank((CharSequence)typeId)) {
            condition.setPicTypeId(typeId);
        }
        List list = this.sisTipPicService.getByCondition(condition);
        for (SisTipPicItem item : list) {
            jsons.add(JSONObject.toJSON((Object)item));
        }
        return jsons;
    }

    @RequiresPermissions(value={"sis:sisTipPic:refresh"})
    public ZKResultMsg loadTipPic(String typeId, String stgId) {
        SisTipPicItem condition = new SisTipPicItem();
        condition.setNotInType(".zkx");
        if (StringUtils.isNotBlank((CharSequence)stgId)) {
            String ids = this.sisTipStrategyService.getTipPicIdsByStgId(stgId);
            condition.setNotInId(ids);
        }
        if (StringUtils.isNotBlank((CharSequence)typeId)) {
            condition.setPicTypeId(typeId);
        }
        List result = this.sisTipPicService.getByCondition(condition);
        return new ZKResultMsg((Object)result);
    }

    public ZKResultMsg getTipPicTypeList() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        List list = this.sisTipPicTypeService.getByCondition(new SisTipPicTypeItem());
        for (SisTipPicTypeItem item : list) {
            items.add(new SelectItem((Object)item.getName(), item.getId()));
        }
        return new ZKResultMsg(items);
    }

    @RequiresPermissions(value={"sis:sisTipPic:exportPhoto"})
    @LogRequest(module="sis_module", object="sis_tipPic", opType="\u5bfc\u51faTip\u56fe\u5e93", opContent="\u5bfc\u51faTip\u56fe\u5e93")
    public void exportPhoto(SisTipPicItem sisTipPicItem) throws Exception {
        boolean isMSIE;
        List list;
        String sisTipPicTypeId;
        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"start");
        this.stringRedisTemplate.expire((Object)("export-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        SisTipPicItem condition = new SisTipPicItem();
        if (StringUtils.equals((CharSequence)sisTipPicItem.getName(), (CharSequence)"type") && StringUtils.isNotBlank((CharSequence)(sisTipPicTypeId = this.sisTipPicTypeService.findByType(sisTipPicItem.getPicTypeName())))) {
            condition.setPicTypeId(sisTipPicTypeId);
        }
        if ((list = this.sisTipPicService.getAllTipPhotoByAuthUserFilter(condition)).size() == 0) {
            throw ZKBusinessException.warnException((String)"common_report_dataSourceNull", (Object[])new Object[0]);
        }
        ArrayList<File> files = new ArrayList<File>();
        for (SisTipPicItem item : list) {
            File file = new File(FileUtils.getLocalFullPath((String)item.getJpgPath()));
            if (!file.exists()) continue;
            files.add(file);
        }
        if (files.isEmpty()) {
            throw ZKBusinessException.warnException((String)"common_report_dataSourceNull", (Object[])new Object[0]);
        }
        String fileNamePrefix = I18nUtil.i18nCode((String)"sis_tip_pic", (Object[])new Object[0]);
        String agent = this.request.getHeader("User-Agent");
        boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
        if (isMSIE) {
            fileNamePrefix = URLEncoder.encode(fileNamePrefix, "UTF-8");
            fileNamePrefix = fileNamePrefix.replaceAll("\\+", " ");
        } else {
            fileNamePrefix = new String(fileNamePrefix.getBytes("UTF-8"), "ISO-8859-1");
        }
        if (this.request.getHeader("User-Agent") != null && this.request.getHeader("User-Agent").indexOf("Edge") != -1) {
            fileNamePrefix = fileNamePrefix.replaceAll(" ", "%20");
            fileNamePrefix = URLEncoder.encode(fileNamePrefix, "ISO-8859-1");
            fileNamePrefix = fileNamePrefix.replace("%2520", " ");
        }
        String tempPath = (ClassUtil.getRootPath() + File.separator + FileUtil.systemFilePath).replace("/", "\\") + "\\" + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".zip";
        this.response = FileUtil.downLoadFiles((String)tempPath, (File[])files.toArray(new File[0]), (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        this.response.flushBuffer();
        File zipTempFile = new File(tempPath);
        if (zipTempFile.exists()) {
            zipTempFile.delete();
        }
        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
    }

    @RequiresPermissions(value={"sis:sisTipPic:import"})
    @LogRequest(module="sis_module", object="sis_tipPic", opType="sis_tipAdd_import", opContent="sis_tipAdd_import")
    public ZKResultMsg importTipPic(MultipartFile uploadFile, String type) {
        if (Objects.nonNull(uploadFile) && !uploadFile.isEmpty()) {
            String filePath = FileUtil.saveFileToServer((String)"sicm", (String)"photo/tip/template", (String)uploadFile.getOriginalFilename(), (MultipartFile)uploadFile);
            Boolean isChinese = this.sisTipPicService.isContainChinese(filePath);
            if (!isChinese.booleanValue()) {
                return new ZKResultMsg("error", I18nUtil.i18nCode((String)"sis_tip_file_upload_error", (Object[])new Object[0]));
            }
            this.log.info("\u89e3\u538b\u4e0a\u4f20\u7684\u538b\u7f29\u5305\u6587\u4ef6");
            String zipPath = this.sisTipPicService.unZipToFile(filePath, "/upload/sicm/photo/tip/uplodeTemplate");
            this.log.info("\u89e3\u538b\u4e0a\u4f20\u7684\u538b\u7f29\u5305\u6587\u4ef6\u6210\u529f");
            this.log.info("\u5220\u9664\u538b\u7f29\u5305\u6587\u4ef6");
            this.delAllFile(FileUtil.getLocalFullPath((String)"/upload/sicm/photo/tip/template"));
            this.log.info("\u5220\u9664\u538b\u7f29\u5305\u6587\u4ef6\u6210\u529f");
            this.log.info("\u5f00\u59cb\u4fdd\u5b58\u4fe1\u606f\u5165\u5e93");
            return I18nUtil.i18nMsg((ZKResultMsg)this.sisTipPicService.handlerZipTicPic(zipPath, type));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"common_op_failed"));
    }

    public ZKResultMsg importData(MultipartFile upload, String type) {
        return null;
    }

    public boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            this.delAllFile(path + File.separator + tempList[i]);
            this.delFolder(path + File.separator + tempList[i]);
            flag = true;
        }
        return flag;
    }

    public void delFolder(String folderPath) {
        try {
            this.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

