/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisPersonAddDeviceRemote;
import com.zkteco.zkbiosecurity.sis.service.SisPersonAddDeviceService;
import com.zkteco.zkbiosecurity.sis.vo.SisDeviceInPersonItem;
import com.zkteco.zkbiosecurity.sis.vo.SisPersonAddDeviceItem;
import com.zkteco.zkbiosecurity.sis.vo.SisPersonSelectDeviceItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisPersonAddDeviceController
extends BaseController
implements SisPersonAddDeviceRemote {
    Logger logger = Logger.getLogger(SisPersonAddDeviceController.class);
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private SisPersonAddDeviceService sisPersonAddDeviceService;

    @RequiresPermissions(value={"sis:personAddDevice"})
    public ModelAndView index() {
        return new ModelAndView("sis/personAddDevice/sisPersonAddDevice");
    }

    @RequiresPermissions(value={"sis:personAddDevice:edit"})
    public ModelAndView edit(String id) {
        return null;
    }

    @RequiresPermissions(value={"sis:personAddDevice:edit"})
    public ZKResultMsg save(SisPersonAddDeviceItem item) {
        return null;
    }

    @RequiresPermissions(value={"sis:personAddDevice:refresh"})
    public DxGrid list(SisPersonAddDeviceItem condition) {
        Pager pager = this.sisPersonAddDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"sis:personAddDevice:del"})
    public ZKResultMsg del(String ids) {
        String personPin = this.request.getParameter("personPin");
        this.sisPersonAddDeviceService.deleteByIdsAndPersonPins(ids, personPin);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"sis:personAddDevice:refresh"})
    public DxGrid getPersonDeviceList(SisDeviceInPersonItem condition) {
        Pager pager = this.sisPersonAddDeviceService.loadDevicePagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectDeviceList(SisPersonSelectDeviceItem condition) {
        Pager pager = new Pager();
        if (StringUtils.equals((CharSequence)"noSelected", (CharSequence)condition.getType())) {
            pager = this.sisPersonAddDeviceService.getNoExistDevice(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (StringUtils.equals((CharSequence)"Selected", (CharSequence)condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"sis:personAddDevice:addDevice"})
    @LogRequest(module="sis_module", object="sis_person_addByPerson", opType="sis_person_addByPerson", requestParams={"personPin", "deviceNames"}, opContent="common_dev_name")
    public ZKResultMsg addDevice(String personId, String deviceIds) {
        String clientId = this.request.getParameter("clientId");
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
        if (StringUtils.isNotBlank((CharSequence)personId) && StringUtils.isNotBlank((CharSequence)deviceIds)) {
            try {
                List deviceArrayIds = this.sisPersonAddDeviceService.splitIds(deviceIds, 200);
                int[] currentCount = new int[]{0};
                int[] totalCount = new int[]{deviceArrayIds.size()};
                deviceArrayIds.parallelStream().forEach(areaArrayId -> {
                    this.sisPersonAddDeviceService.addDeviceByPersonIds(personId, deviceIds);
                    currentCount[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
            }
            catch (Exception e) {
                this.logger.error((Object)"addDevice with area error", (Throwable)e);
            }
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

