/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisMapRemote;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.service.SisMapPosService;
import com.zkteco.zkbiosecurity.sis.service.SisMapService;
import com.zkteco.zkbiosecurity.sis.vo.SisMapItem;
import com.zkteco.zkbiosecurity.sis.vo.SisMapPosItem;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisMapController
extends ExportController
implements SisMapRemote {
    @Autowired
    private SisMapService sisMapService;
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;
    @Autowired
    private SisDeviceService sisDeviceService;
    @Autowired
    private SisMapPosService sisMapPosService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    private static final long MAX_FILE_SIZE = 0x200000L;

    public ModelAndView index() {
        return new ModelAndView("sis/map/sisMap");
    }

    @RequiresPermissions(value={"sis:map:add", "sis:map:addBoard"})
    public ModelAndView editBoard(String id) {
        SisMapItem item = new SisMapItem();
        item.setType("borad");
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("sis/map/editSisMap");
    }

    @RequiresPermissions(value={"sis:map:add", "sis:map:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.sisMapService.getItemById(id));
            this.request.setAttribute("editPage", (Object)true);
        }
        return new ModelAndView("sis/map/editSisMap");
    }

    @RequiresPermissions(value={"sis:map:add", "sis:map:edit"})
    public ZKResultMsg save(@RequestParam(value="file", required=false) MultipartFile file, SisMapItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String modify = this.request.getParameter("modify_path");
        String path = this.systemFilePath + File.separator + "/upload/sis/sisMap";
        if (StringUtils.isBlank((CharSequence)item.getId()) || StringUtils.equals((CharSequence)"no", (CharSequence)modify)) {
            SisMapItem oldMap;
            File oldPic;
            if (file == null || file.getSize() > 0x200000L) {
                throw ZKBusinessException.warnException((String)"base_map_imgSizeError", (Object[])new Object[0]);
            }
            File upLoadPicPath = new File(path);
            if (!upLoadPicPath.isAbsolute()) {
                path = ClassUtil.getRootPath() + File.separator + path;
                upLoadPicPath = new File(path);
            }
            if (!upLoadPicPath.exists()) {
                upLoadPicPath.mkdirs();
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{item.getId()}) && (oldPic = new File((oldMap = this.sisMapService.getItemById(item.getId())).getMapPath())).exists()) {
                oldPic.delete();
            }
            long fName = System.currentTimeMillis();
            if (!StringUtils.equals((CharSequence)"", (CharSequence)item.getType())) {
                item.setMapPath("/upload/sis/sisMap" + File.separator + fName + ".jpg");
            } else {
                item.setMapPath(path + File.separator + fName + ".jpg");
            }
            try {
                String mapName = path + File.separator + fName + ".jpg";
                File mapFile = new File(mapName);
                file.transferTo(mapFile);
            }
            catch (IOException e) {
                throw new ZKBusinessException("AccMapItem SaveMap Exception");
            }
        }
        this.sisMapService.saveItem(item);
        res.setData((Object)item.getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg saveTest(SisMapItem item) {
        ZKResultMsg res = new ZKResultMsg();
        return res;
    }

    public ZKResultMsg isExists() {
        ZKResultMsg res = new ZKResultMsg();
        SisMapItem sisMapItem = this.sisMapService.getItemByType("borad");
        if (sisMapItem != null) {
            res.setMsg(I18nUtil.i18nCode((String)"sis_map_add_board_existing", (Object[])new Object[0]));
            return res;
        }
        res.setMsg("ok");
        return res;
    }

    public DxGrid list(SisMapItem codition) {
        Pager pager = this.sisMapService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg del(String ids) {
        this.sisMapService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public TreeItem getMapTree() {
        List items = this.sisMapService.createMapTree(this.request.getSession().getId());
        if (items == null || items.isEmpty()) {
            TreeItem infoItem = new TreeItem();
            infoItem.setId("_");
            infoItem.setText("<span class='warningColor'>" + I18nUtil.i18nCode((String)"base_map_addMap", (Object[])new Object[0]) + "</span>");
            infoItem.setIm0("comm_iconAlert.png");
            items.add(infoItem);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList((Collection)items);
        return new TreeItem("0", treeItems);
    }

    public ModelAndView getMap(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            SisMapItem tempMapItem = this.sisMapService.getItemById(id);
            String imgBase64Str = "";
            String mapPath = tempMapItem.getMapPath();
            File mapfile = new File(mapPath);
            if (mapfile.exists()) {
                try {
                    FileInputStream in = new FileInputStream(mapfile);
                    byte[] data = new byte[((InputStream)in).available()];
                    ((InputStream)in).read(data);
                    imgBase64Str = Base64Utils.encodeToString((byte[])data);
                    tempMapItem.setMapPath("data:image/jpg;base64," + imgBase64Str);
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new ZKBusinessException("AccMapController getMap base64 error");
                }
            }
            ArrayList<JSONObject> entityList = new ArrayList<JSONObject>();
            JSONObject tempObject = null;
            ArrayList<SisMapPosItem> posList = new ArrayList<SisMapPosItem>();
            SisMapPosItem sisMapPosItem = new SisMapPosItem();
            sisMapPosItem.setMapId(id);
            List mapPosItemList = this.sisMapPosService.getByCondition(sisMapPosItem);
            for (SisMapPosItem pos : mapPosItemList) {
                if (StringUtils.equals((CharSequence)"SisDevice", (CharSequence)pos.getEntityType())) {
                    tempObject = this.sisMapService.getDeviceInfoByNameAndId(pos);
                } else if (StringUtils.equals((CharSequence)"SisGateDevice", (CharSequence)pos.getEntityType())) {
                    tempObject = this.sisMapService.getGateDeviceInfoByNameAndId(pos);
                }
                if (tempObject == null) continue;
                entityList.add(tempObject);
                posList.add(pos);
            }
            this.request.setAttribute("mapId", (Object)id);
            this.request.setAttribute("mapPosList", posList);
            this.request.setAttribute("tempMap", (Object)tempMapItem);
            this.request.setAttribute("entityList", entityList);
        }
        return new ModelAndView("sis/map/sisMapRTMonitor");
    }

    public ModelAndView setMap(String id) {
        SisMapItem sisMapItem = this.sisMapService.getItemByType("borad");
        if (sisMapItem != null) {
            String imgBase64Str = "";
            String mapPath = sisMapItem.getMapPath();
            File mapfile = new File(mapPath);
            if (mapfile.exists()) {
                try {
                    FileInputStream in = new FileInputStream(mapfile);
                    byte[] data = new byte[((InputStream)in).available()];
                    ((InputStream)in).read(data);
                    imgBase64Str = Base64Utils.encodeToString((byte[])data);
                    sisMapItem.setMapPath("data:image/jpg;base64," + imgBase64Str);
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new ZKBusinessException("AccMapController getMap base64 error");
                }
            }
            ArrayList<JSONObject> entityList = new ArrayList<JSONObject>();
            JSONObject tempObject = null;
            ArrayList<SisMapPosItem> posList = new ArrayList<SisMapPosItem>();
            SisMapPosItem sisMapPosItem = new SisMapPosItem();
            sisMapPosItem.setMapId(id);
            List mapPosItemList = this.sisMapPosService.getByCondition(sisMapPosItem);
            for (SisMapPosItem pos : mapPosItemList) {
                if (StringUtils.equals((CharSequence)"SisDevice", (CharSequence)pos.getEntityType())) {
                    tempObject = this.sisMapService.getDeviceInfoByNameAndId(pos);
                } else if (StringUtils.equals((CharSequence)"SisGateDevice", (CharSequence)pos.getEntityType())) {
                    tempObject = this.sisMapService.getGateDeviceInfoByNameAndId(pos);
                }
                if (tempObject == null) continue;
                entityList.add(tempObject);
                posList.add(pos);
            }
            this.request.setAttribute("mapId", (Object)sisMapItem.getId());
            this.request.setAttribute("mapPosList", posList);
            this.request.setAttribute("tempMap", (Object)sisMapItem);
            this.request.setAttribute("entityList", entityList);
        }
        return new ModelAndView("sis/homePage/sisBillboardMap");
    }

    private Map<String, String> getVidParams() {
        return this.baseSysParamService.getParamsByModule("vid");
    }

    private String getParamValByName(String paramName) {
        return this.baseSysParamService.getValByName(paramName);
    }

    public ZKResultMsg saveMapPos(String mapId, Double mapWidth, Double mapHeight, String posArray) {
        this.sisMapService.saveMapPos(mapId, mapWidth, mapHeight, posArray);
        if ("addEntityToMap".equals(this.request.getParameter("flag"))) {
            return null;
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg addDoor(String mapId, Double width, String entityType, String entityIds, String logMethod) {
        this.sisMapService.addEntity(mapId, width, entityType, entityIds, logMethod);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExist(SisMapItem item) {
        String mapName = this.request.getParameter("mapName");
        if (!item.getName().equals(mapName)) {
            return this.sisMapService.isExist(item.getName());
        }
        return true;
    }

    @RequiresPermissions(value={"acc:map:addDoorToMap", "acc:map:addChannelToMap"})
    public ModelAndView getEntitySelectItem(String mapId, String entityType, String width) {
        this.request.setAttribute("mapId", (Object)mapId);
        this.request.setAttribute("entityType", (Object)entityType);
        this.request.setAttribute("width", (Object)width);
        if (entityType.equals("SisGateDevice")) {
            this.request.setAttribute("logMethod", (Object)"addDoorToMap");
            return new ModelAndView("sis/map/sisMapSelectGateDevice");
        }
        this.request.setAttribute("logMethod", (Object)"addDeviceToMap");
        return new ModelAndView("sis/map/sisMapSelectGateDevice");
    }

    public ZKResultMsg getDeviceDev(String id) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        SisMapPosItem sisMapPosItem = new SisMapPosItem();
        sisMapPosItem.setMapId(id);
        ArrayList<JSONObject> entityList = new ArrayList<JSONObject>();
        JSONObject tempObject = null;
        JSONObject data = new JSONObject();
        ArrayList<SisMapPosItem> posList = new ArrayList<SisMapPosItem>();
        List mapPosItemList = this.sisMapPosService.getByCondition(sisMapPosItem);
        for (SisMapPosItem pos : mapPosItemList) {
            if (StringUtils.equals((CharSequence)"SisDevice", (CharSequence)pos.getEntityType())) {
                tempObject = this.sisMapService.getDeviceInfoByNameAndId(pos);
            } else if (StringUtils.equals((CharSequence)"SisGateDevice", (CharSequence)pos.getEntityType())) {
                tempObject = this.sisMapService.getGateDeviceInfoByNameAndId(pos);
            }
            if (tempObject == null) continue;
            entityList.add(tempObject);
            posList.add(pos);
        }
        data.put("mapId", (Object)id);
        data.put("mapPosList", posList);
        resultMsg.setData((Object)data);
        return resultMsg;
    }

    public ZKResultMsg getDoardMap() {
        ZKResultMsg resultMsg = new ZKResultMsg();
        SisMapItem sisMapItem = this.sisMapService.getItemByType("borad");
        if (sisMapItem != null) {
            String mapPath = FileUtil.getLocalFullPath((String)sisMapItem.getMapPath());
            File picture = new File(mapPath);
            JSONObject obj = new JSONObject();
            String imgBase64Str = "";
            SisMapPosItem sisMapPosItem = new SisMapPosItem();
            sisMapPosItem.setMapId(sisMapItem.getId());
            List mapPosItemList = this.sisMapPosService.getByCondition(sisMapPosItem);
            obj.put("posList", (Object)mapPosItemList);
            if (picture.exists()) {
                try {
                    obj.put("path", (Object)sisMapItem.getMapPath());
                    BufferedImage sourceImg = ImageIO.read(new FileInputStream(picture));
                    obj.put("imgWidth", (Object)sourceImg.getWidth());
                    obj.put("imgHeight", (Object)sourceImg.getHeight());
                }
                catch (IOException e) {
                    throw new ZKBusinessException("Failed to obtain electronic map error");
                }
            }
            resultMsg.setData((Object)obj);
        }
        return resultMsg;
    }
}

