/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.cloud.sdk.websocket;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.cloud.sdk.websocket.ApiResultMsg;
import com.zkteco.cloud.sdk.websocket.FailMessageHandler;
import com.zkteco.cloud.sdk.websocket.MessageHandler;
import com.zkteco.cloud.sdk.websocket.ZKCloudTmcClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ZKCloudTmcClientHandler
extends SimpleChannelInboundHandler<Object> {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final WebSocketClientHandshaker handshaker;
    private MessageHandler messageHandler;
    private FailMessageHandler failMessageHandler;
    private ChannelPromise handshakeFuture;
    private ZKCloudTmcClient zkCloudTmcClient;
    URI uri;
    String appId;
    String appKey;

    public ZKCloudTmcClient getZkCloudTmcClient() {
        return this.zkCloudTmcClient;
    }

    public void setZkCloudTmcClient(ZKCloudTmcClient zkCloudTmcClient) {
        this.zkCloudTmcClient = zkCloudTmcClient;
    }

    public ZKCloudTmcClientHandler(WebSocketClientHandshaker handshaker) {
        this.handshaker = handshaker;
    }

    public ZKCloudTmcClientHandler(WebSocketClientHandshaker handshaker, MessageHandler messageHandler, FailMessageHandler failMessageHandler) {
        this.handshaker = handshaker;
        this.messageHandler = messageHandler;
        this.failMessageHandler = failMessageHandler;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.handshaker.handshake(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.log.warn("\u8fd0\u884c\u65f6\uff0c\u6389\u7ebf\u4e86\u63e1\u624b\u5931\u8d25..." + ctx.channel().id().asLongText());
        EventLoop eventLoop = ctx.channel().eventLoop();
        eventLoop.schedule(new Runnable(){

            @Override
            public void run() {
                ZKCloudTmcClientHandler.this.log.warn("\u8fd0\u884c\u65f6\uff0c\u6389\u7ebf\u4e86...\u6b63\u5728\u91cd\u65b0\u542f\u52a8...zkCloudTmcClient= " + (ZKCloudTmcClientHandler.this.zkCloudTmcClient != null));
                if (ZKCloudTmcClientHandler.this.zkCloudTmcClient != null) {
                    ZKCloudTmcClientHandler.this.zkCloudTmcClient;
                    ZKCloudTmcClient.connectType = "running";
                    ZKCloudTmcClientHandler.this.zkCloudTmcClient.connect(ZKCloudTmcClientHandler.this.getUri());
                } else {
                    ZKCloudTmcClientHandler.this.log.warn("\u8fd0\u884c\u65f6\u51fa\u73b0\u5bf9\u8c61\u4e3a\u7a7a\u91cd\u65b0\u521b\u5efa\u5bf9\u8c61..");
                    new ZKCloudTmcClient(ZKCloudTmcClientHandler.this.appId, ZKCloudTmcClientHandler.this.appKey).connect(ZKCloudTmcClientHandler.this.getUri());
                }
            }
        }, 5L, TimeUnit.SECONDS);
        super.channelInactive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        block17: {
            Channel ch = ctx.channel();
            if (!this.handshaker.isHandshakeComplete()) {
                try {
                    FullHttpResponse response = (FullHttpResponse)msg;
                    this.handshaker.finishHandshake(ch, response);
                    this.handshakeFuture.setSuccess();
                    this.log.warn("ZKCloudTmcClientHandler + \u94fe\u63a5\u670d\u52a1\u7aef\u63e1\u624b\u6210\u529f...WebSocket Client connected");
                    this.log.info("WebSocket Client connected! response headers[sec-websocket-extensions]:{}" + response.headers() + " " + response.content());
                    if (this.failMessageHandler != null) {
                        this.failMessageHandler.handlerFailMessage();
                    }
                    break block17;
                }
                catch (WebSocketHandshakeException var7) {
                    FullHttpResponse res = (FullHttpResponse)msg;
                    String errorMsg = String.format("WebSocket Client failed to connect,status:%s,reason:%s", res.status(), res.content().toString(CharsetUtil.UTF_8));
                    this.log.error(errorMsg);
                    this.handshakeFuture.setFailure((Throwable)new Exception(errorMsg));
                    if (res.status().equals((Object)HttpResponseStatus.UNAUTHORIZED)) {
                        String msg2 = res.content().retain().toString(CharsetUtil.UTF_8).replace(HttpResponseStatus.UNAUTHORIZED.toString(), "");
                        ApiResultMsg resultMsg = (ApiResultMsg)JSONObject.parseObject((String)msg2, ApiResultMsg.class);
                        if (this.failMessageHandler != null) {
                            this.failMessageHandler.handlerFailMessage(resultMsg);
                        }
                    }
                    break block17;
                }
            }
            if (msg instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)msg;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
            }
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                this.log.debug("TextWebSocketFrame   == " + textFrame.text());
                ApiResultMsg resultMsg = (ApiResultMsg)JSONObject.parseObject((String)textFrame.text(), ApiResultMsg.class);
                if ("heart".equals(resultMsg.getRespone()) || "\u6210\u529f".equals(resultMsg.getMsg())) {
                    return;
                }
                if (this.messageHandler != null) {
                    this.messageHandler.onMessage(resultMsg);
                }
            } else if (frame instanceof BinaryWebSocketFrame) {
                BinaryWebSocketFrame binFrame = (BinaryWebSocketFrame)frame;
                this.log.info("BinaryWebSocketFrame");
            } else if (frame instanceof PongWebSocketFrame) {
                this.log.info("WebSocket Client received pong");
            } else if (frame instanceof CloseWebSocketFrame) {
                this.log.info("receive close frame");
                ch.close();
            } else {
                this.log.info("receive frame" + frame.getClass().getName());
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent event;
        super.userEventTriggered(ctx, evt);
        if (evt instanceof IdleStateEvent && !(event = (IdleStateEvent)evt).state().equals((Object)IdleState.READER_IDLE)) {
            if (event.state().equals((Object)IdleState.WRITER_IDLE)) {
                ApiResultMsg apiResultMsg = new ApiResultMsg();
                apiResultMsg.setRespone("heart");
                ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(JSONObject.toJSONString((Object)apiResultMsg)));
            } else if (event.state().equals((Object)IdleState.ALL_IDLE)) {
                // empty if block
            }
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }
}

