/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.push.processor;

import com.zkteco.zkbiosecurity.adms.bean.Adms2PidDevUploadInfo;
import com.zkteco.zkbiosecurity.adms.cache.AdmsCacheManager;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.BaseProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.utils.DeviceDataUtil;
import com.zkteco.zkbiosecurity.adms.distributor.utils.JSONObjectUtil;
import com.zkteco.zkbiosecurity.adms.distributor.utils.RequestUtil;
import com.zkteco.zkbiosecurity.adms.service.Adms4PidService;
import com.zkteco.zkbiosecurity.adms.service.AdmsAuthDeviceService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDevCmdService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDeviceService;
import com.zkteco.zkbiosecurity.adms.vo.AdmsAuthDeviceItem;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PidPushProcessor
extends BaseProcessor {
    @Autowired
    private AdmsDeviceService admsDeviceService;
    @Autowired
    private AdmsAuthDeviceService admsAuthDeviceService;
    @Autowired(required=false)
    private Adms4PidService adms4PidService;
    @Autowired
    private AdmsDevCmdService admsDevCmdService;
    @Autowired
    private AdmsCacheManager admsCacheManager;

    @Override
    public String handleReqData(ChannelHandlerContext ctx, HttpRequest httpRequest, String sn) throws Exception {
        boolean exist;
        String uri = httpRequest.getUri();
        URI uriObj = new URI(uri);
        String requestPath = uriObj.getPath();
        this.printLog(sn, uri);
        boolean firstReq = uri.contains("options") && uri.contains("pushver") && uri.contains("language");
        String rs = "UNKNOWN DEVICE";
        String clientIP = this.getClientIP(ctx, httpRequest);
        if (firstReq) {
            String language = RequestUtil.getParams(uri, "language");
            int serverPort = this.getServerPort(httpRequest);
            String pushOptionsFlag = RequestUtil.getParams(uri, "PushOptionsFlag");
            String pushver = RequestUtil.getParams(uri, "pushver");
            rs = this.dealFirstReq(sn, pushver, language, clientIP, serverPort, pushOptionsFlag);
        } else if (this.admsDeviceService.isAuthIp(clientIP) && (exist = this.admsDeviceService.existDevice(sn))) {
            String encoding = "83";
            if (requestPath.startsWith("/iclock/ping")) {
                rs = "OK";
            } else if (requestPath.startsWith("/iclock/cdata")) {
                String table = RequestUtil.getParams(uri, "table");
                String stamp = RequestUtil.getParams(uri, "Stamp");
                rs = this.pidCdataUpload(sn, table, stamp, httpRequest, encoding);
            } else if (requestPath.startsWith("/iclock/getrequest")) {
                rs = this.getRequest(sn, uri);
            } else if (requestPath.startsWith("/iclock/devicecmd")) {
                String data = this.getContentData(httpRequest, encoding.equals("83") ? "GB2312" : "UTF-8");
                if (data.contains("FILENAME") && data.contains("CMD=GetFile")) {
                    this.getPidLicense56File(data);
                    return null;
                }
                rs = this.deviceCmd(sn, data);
            } else if (requestPath.startsWith("/iclock/BioSecurityFile")) {
                FullHttpRequest request = (FullHttpRequest)httpRequest;
                uri = uri.split("\\?")[0].replaceAll("/iclock/", "");
                try {
                    uri = URLDecoder.decode(uri, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error(e);
                }
                Pattern INSECURE_URI = Pattern.compile(".*[<>\"].*");
                uri = uri.replace('/', File.separatorChar);
                if (uri.contains(File.separator + '.') || uri.contains('.' + File.separator) || uri.charAt(0) == '.' || uri.charAt(uri.length() - 1) == '.' || INSECURE_URI.matcher(uri).matches()) {
                    return null;
                }
                String path = SystemPropertyUtil.get((String)"user.dir") + File.separator + uri;
                File file = new File(path);
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                this.writeDownLoadResponse(httpRequest, ctx, raf, file);
                rs = null;
            }
        }
        return rs;
    }

    private void writeDownLoadResponse(HttpRequest request, ChannelHandlerContext ctx, RandomAccessFile raf, File file) throws Exception {
        long fileLength = raf.length();
        boolean close = "close".equalsIgnoreCase(request.headers().get("Connection")) || request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0) && !"keep-alive".equalsIgnoreCase(request.headers().get("Connection"));
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
        PidPushProcessor.setContentHeader((HttpResponse)response, file);
        if (!close) {
            response.headers().set("Connection", (Object)"keep-alive");
        }
        ctx.write((Object)response);
        this.log.info("download file size=" + fileLength);
        DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), 0L, 1000L);
        ChannelFuture writeFuture = ctx.write((Object)region, (ChannelPromise)ctx.newProgressivePromise());
        writeFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

            public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                if (total < 0L) {
                    System.err.println(future.channel() + " Transfer progress: " + progress);
                } else {
                    System.err.println(future.channel() + " Transfer progress: " + progress + " / " + total);
                }
            }

            public void operationComplete(ChannelProgressiveFuture future) {
            }
        });
        ChannelFuture lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (close) {
            raf.close();
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static void setContentHeader(HttpResponse response, File file) {
        String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
        String HTTP_DATE_GMT_TIMEZONE = "GMT";
        int HTTP_CACHE_SECONDS = 60;
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        response.headers().set("Content-Type", (Object)mimeTypesMap.getContentType(file.getPath()));
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, HTTP_CACHE_SECONDS);
        response.headers().set("Expires", (Object)dateFormatter.format(time.getTime()));
        response.headers().set("Cache-Control", (Object)("private, max-age=" + HTTP_CACHE_SECONDS));
        response.headers().set("Last-Modified", (Object)dateFormatter.format(new Date(file.lastModified())));
    }

    private String getRequest(String sn, String uri) {
        String info;
        String rs = "OK";
        String cmd = this.admsDeviceService.getCmd(sn, 10);
        if (StringUtils.isNotBlank((CharSequence)cmd)) {
            rs = cmd;
        }
        if (StringUtils.isNotBlank((CharSequence)(info = RequestUtil.getParams(uri, "INFO")))) {
            this.pidUploadInfo(sn, info);
        }
        return rs;
    }

    private void pidUploadInfo(String sn, String info) {
        String[] devInfoArray = info.split(",");
        Adms2PidDevUploadInfo devUploadInfo = new Adms2PidDevUploadInfo();
        devUploadInfo.setSn(sn);
        devUploadInfo.setFwVersion(devInfoArray[0]);
        devUploadInfo.setUsercCount(Integer.valueOf(devInfoArray[1]));
        devUploadInfo.setFpCount(Integer.valueOf(devInfoArray[2]));
        devUploadInfo.setTransactionCount(Integer.valueOf(devInfoArray[3]));
        devUploadInfo.setIpAddress(devInfoArray[4]);
        devUploadInfo.setFpVersion(devInfoArray[5]);
        devUploadInfo.setFaceVersion(devInfoArray[6]);
        devUploadInfo.setFaceCount(Integer.valueOf(devInfoArray[8]));
        if (this.adms4PidService != null) {
            this.adms4PidService.uploadDevInfo(devUploadInfo);
        }
        this.admsDeviceService.updatePidLoadInfo(sn, info);
    }

    private String deviceCmd(String sn, String data) {
        return this.admsDevCmdService.devReturnCmd(sn, data);
    }

    public String dealFirstReq(String sn, String pushver, String language, String ip, int port, String pushOptionsFlag) {
        this.log.info("pid device options request.....sn=" + sn);
        AdmsAuthDeviceItem authInfo = this.admsAuthDeviceService.getAuthDeviceInfo(sn);
        String retInfo = "UNKNOWN DEVICE";
        this.admsDeviceService.setDevEncoding("pid", sn, language);
        if (authInfo != null && authInfo.getAuthFlag() != null && authInfo.getAuthFlag().booleanValue()) {
            Map<String, String> deviceOptions = this.createPidDeviceOpt(sn, pushver, language, ip, port, pushOptionsFlag);
            retInfo = this.admsDeviceService.regPidDevice(sn, deviceOptions);
        } else {
            this.log.info("pid device sn=" + sn + " no auth ,request reject");
            if (authInfo == null || !authInfo.getIp().equals(ip)) {
                String ipAddress = ip;
                String netMask = "";
                String gateway = "";
                String mac = "";
                String deviceType = "pid";
                String deviceName = "";
                String server = "";
                AdmsAuthDeviceItem item = new AdmsAuthDeviceItem(ipAddress, mac, netMask, gateway, sn, deviceType, server, deviceName);
                this.admsAuthDeviceService.setAuthDeviceInfo(item);
            }
        }
        return retInfo;
    }

    private Map<String, String> createPidDeviceOpt(String sn, String pushver, String language, String ip, int port, String pushOptionsFlag) {
        HashMap<String, String> optionsJson = new HashMap<String, String>();
        optionsJson.put("SN", sn);
        optionsJson.put("language", language);
        optionsJson.put("IDCARDStamp", "0");
        optionsJson.put("ATTLOGStamp", "0");
        optionsJson.put("OPERLOGStamp", "0");
        optionsJson.put("BIODATAStamp", "0");
        optionsJson.put("ATTPHOTOStamp", "0");
        optionsJson.put("ErrorDelay", "60");
        optionsJson.put("Delay", "2");
        optionsJson.put("TransTimes", "00:00\t14:00");
        optionsJson.put("TransInterval", "1");
        optionsJson.put("TransFlag", "111111111111");
        optionsJson.put("TimeZone", "8");
        optionsJson.put("Realtime", "1");
        optionsJson.put("Encrypt", "0");
        optionsJson.put("DeviceType", "pid");
        optionsJson.put("ServerVer", "adms2.0");
        optionsJson.put("language", language);
        optionsJson.put("~DeviceName", sn);
        optionsJson.put("CommType", "3");
        optionsJson.put("IPAddress", ip);
        optionsJson.put("RegDeviceType", "");
        optionsJson.put("IpPort", port + "");
        optionsJson.put("PushOptionsFlag", pushOptionsFlag == null ? "0" : pushOptionsFlag);
        optionsJson.put("SupportPing", "1");
        optionsJson.put("enabled", "true");
        return optionsJson;
    }

    public String pidCdataUpload(String sn, String table, String stamp, HttpRequest request, String encoding) {
        String flag = "OK";
        String data = "";
        if ("options".equals(table)) {
            data = this.getContentData(request, encoding.equals("83") ? "GBK" : "UTF-8");
            this.log.info("options data=" + data);
            this.updateDeviceOption(sn, data);
        } else if ("ATTLOG".equals(table)) {
            data = this.getContentData(request, encoding.equals("83") ? "GBK" : "UTF-8");
            this.log.info("ATTLOG data=" + data);
            this.admsDeviceService.savePidLog(sn, data, stamp);
        } else if ("IDCARD".equals(table)) {
            data = this.getContentData(request, encoding.equals("83") ? "GBK" : "UTF-8");
            this.log.info("IDCARD data=" + data);
            this.admsDeviceService.savePidIdCard(sn, data, stamp);
        } else if ("ATTPHOTO".equals(table)) {
            data = this.getPidPhotoData((HttpContent)request);
            this.savePidPhoto(sn, data);
        } else if ("OPERLOG".equals(table)) {
            data = this.getContentData(request, encoding.equals("83") ? "GBK" : "UTF-8");
            this.handlerUserData(sn, data);
        } else if ("BIODATA".equals(table)) {
            data = this.getContentData(request, encoding.equals("83") ? "GB2312" : "UTF-8");
            if (StringUtils.isNotBlank((CharSequence)data)) {
                this.admsDeviceService.setPidBioData(sn, data, stamp);
            } else {
                flag = "UNKNOWN DEVICE";
            }
        }
        return flag;
    }

    private void handlerUserData(String sn, String data) {
        if (this.adms4PidService != null) {
            this.adms4PidService.handlerUserData(sn, data);
        }
    }

    private void savePidPhoto(String sn, String data) {
        if (this.adms4PidService != null) {
            this.adms4PidService.savePidPhoto(sn, data);
        }
    }

    private void getPidLicense56File(String data) {
        if (StringUtils.isNotBlank((CharSequence)data)) {
            String[] headArray = data.split("Content=", 2);
            JSONObject jsonData = new JSONObject();
            Map<String, String> preInfoMap = DeviceDataUtil.formateStrToMap(headArray[0], "\n");
            for (String key : preInfoMap.keySet()) {
                JSONObjectUtil.setKeyValue(jsonData, key, preInfoMap.get(key));
            }
            try {
                String content = headArray[1];
                String sn = jsonData.getString("SN").replaceAll("\r", "");
                String path = ClassUtil.getRootPath() + File.separator + "BioSecurityFile/upload/pid/device/licese56/" + sn;
                File file = new File(path);
                if (file.exists()) {
                    file.delete();
                } else {
                    file.mkdirs();
                }
                File file2 = new File(path + "/zklivefacedevfp.txt");
                if (!file2.exists()) {
                    file2.createNewFile();
                }
                FileWriter fileWriter = new FileWriter(file2);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(content);
                bufferedWriter.close();
            }
            catch (Exception e) {
                this.log.error("getPidLicense56File error", (Throwable)e);
            }
        }
    }

    private String getPidPhotoData(HttpContent request) {
        HttpContent httpContent = request;
        ByteBuf contentByteBuf = httpContent.content();
        contentByteBuf.readableBytes();
        int bufLen = contentByteBuf.readableBytes();
        byte[] bufArray = new byte[bufLen];
        contentByteBuf.readBytes(bufArray);
        String data = new String(bufArray);
        if (StringUtils.isNotBlank((CharSequence)data)) {
            String[] headArray = data.split("CMD=uploadphoto", 2);
            JSONObject jsonData = new JSONObject();
            Map<String, String> preInfoMap = DeviceDataUtil.formateStrToMap(headArray[0], "\n");
            for (String key : preInfoMap.keySet()) {
                JSONObjectUtil.setKeyValue(jsonData, key, preInfoMap.get(key));
            }
            int photoBufLength = Integer.parseInt(preInfoMap.get("size"));
            byte[] fileDataBytesBase64 = Base64.encodeBase64((byte[])ArrayUtils.subarray((byte[])bufArray, (int)(bufLen - photoBufLength), (int)(bufLen - 1)));
            String fileDataStrBase64 = new String(fileDataBytesBase64);
            JSONObjectUtil.setKeyValue(jsonData, "photo", fileDataStrBase64);
            return jsonData.toString();
        }
        return "";
    }

    public String getEncoding(String sn) {
        return this.admsDeviceService.getDevEncoding(sn);
    }

    private void updateDeviceOption(String sn, String data) {
        Map<String, String> deviceOptionMap = this.getDataMap(data);
        deviceOptionMap.put("SN", sn);
        if (this.adms4PidService != null) {
            this.adms4PidService.updateDeviceOptions(deviceOptionMap);
        }
        this.admsDeviceService.updatePidLoadInfo(sn, data);
    }

    private Map<String, String> getDataMap(String data) {
        String[] attField;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (String dataInfo : attField = data.split(",")) {
            String[] dataIn = dataInfo.split("=", 2);
            dataMap.put(dataIn[0], (String)StringUtils.defaultIfBlank((CharSequence)dataIn[1], (CharSequence)""));
        }
        return dataMap;
    }
}

