/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.push.processor;

import com.zkteco.zkbiosecurity.adms.cache.AdmsCacheManager;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.BaseProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.utils.DeviceDataUtil;
import com.zkteco.zkbiosecurity.adms.distributor.utils.JSONObjectUtil;
import com.zkteco.zkbiosecurity.adms.distributor.utils.RequestUtil;
import com.zkteco.zkbiosecurity.adms.service.Adms4AiService;
import com.zkteco.zkbiosecurity.adms.service.AdmsAuthDeviceService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDevCmdService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDeviceService;
import com.zkteco.zkbiosecurity.adms.vo.AdmsAuthDeviceItem;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@Component
public class AiPushProcessor
extends BaseProcessor {
    @Autowired
    private AdmsDeviceService admsDeviceService;
    @Autowired
    private AdmsAuthDeviceService admsAuthDeviceService;
    @Autowired
    private AdmsDevCmdService admsDevCmdService;
    @Autowired
    private AdmsCacheManager admsCacheManager;
    @Autowired(required=false)
    private Adms4AiService adms4AiService;

    @Override
    public String handleReqData(ChannelHandlerContext ctx, HttpRequest httpRequest, String sn) throws Exception {
        String data = this.getContentData(httpRequest, "UTF-8");
        String cookieStr = httpRequest.headers().get("Cookie");
        int port = this.getServerPort(httpRequest);
        String token = "";
        if (StringUtils.isNotBlank((CharSequence)cookieStr)) {
            token = cookieStr.split("=")[1];
        }
        String rs = "OK";
        String uri = httpRequest.getUri();
        URI uriObj = new URI(uri);
        String requestPath = uriObj.getPath();
        this.printLog(sn, uri);
        String sessionId = ctx.channel().id().asLongText();
        switch (requestPath) {
            case "/iclock/registry": {
                rs = this.registry(sn, data, port, sessionId);
                break;
            }
            case "/iclock/push": {
                rs = this.push(sn);
                break;
            }
            case "/iclock/cdata": {
                String table = RequestUtil.getParams(uri, "table");
                String tablename = RequestUtil.getParams(uri, "tablename");
                String authType = RequestUtil.getParams(uri, "AuthType");
                String count = RequestUtil.getParams(uri, "count");
                String options = RequestUtil.getParams(uri, "options");
                String type = RequestUtil.getParams(uri, "type");
                rs = this.cdata(sn, table, tablename, authType, count, options, data, type, port, sessionId);
                break;
            }
            case "/iclock/getrequest": {
                rs = this.getRequest(sn, token);
                break;
            }
            case "/iclock/devicecmd": {
                rs = this.deviceCmd(sn, token, data);
                break;
            }
            case "/iclock/rtdata": {
                rs = this.rtdata(sn, RequestUtil.getParams(uri, "type"));
                break;
            }
            case "/iclock/querydata": {
                Integer actualCount = StringUtils.isEmpty((CharSequence)data) ? 0 : data.split("\r\n").length;
                rs = this.querydata(sn, RequestUtil.getParams(uri, "tablename"), RequestUtil.getParams(uri, "count"), actualCount, RequestUtil.getParams(uri, "type"), data, RequestUtil.getParams(uri, "datafmt"), RequestUtil.getParams(uri, "cmdid"), RequestUtil.getParams(uri, "packcnt"), RequestUtil.getParams(uri, "packidx"), port, sessionId);
                break;
            }
            case "/iclock/rtlog": {
                break;
            }
            case "/iclock/ping": {
                break;
            }
            case "/iclock/file": {
                String fileseq = RequestUtil.getParams(uri, "fileseq");
                String contenttype = RequestUtil.getParams(uri, "contenttype");
                String url = RequestUtil.getParams(uri, "url");
                String datacode = RequestUtil.getParams(uri, "datacode");
                if (fileseq != null && "tgz".equals(contenttype) || url == null) break;
                rs = this.downFile(sn, datacode, url);
                break;
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registry(String devSn, String regContent, int serverPort, String sessionId) {
        this.admsCacheManager.setDevModuleType(devSn, "ai");
        String retInfo = "";
        boolean allowConcurrentReg = this.admsDeviceService.allowConcurrentReg(devSn);
        if (!allowConcurrentReg) {
            this.log.info("device concurrent reg over limit " + this.admsDeviceService.getMaxConcurrentRegCount());
            retInfo = "406";
            return retInfo;
        }
        this.log.info("ai device registry info\uff1a" + regContent);
        try {
            AdmsAuthDeviceItem authInfo = this.admsAuthDeviceService.getAuthDeviceInfo(devSn);
            if (authInfo != null && authInfo.getAuthFlag() != null && authInfo.getAuthFlag().booleanValue()) {
                retInfo = "RegistryCode=" + this.admsDeviceService.regAiDevice(devSn, sessionId, serverPort, regContent);
            } else {
                this.log.info("ai device sn=" + devSn + " no auth ,request reject");
                Map<String, String> optionsMap = DeviceDataUtil.formateStrToMap(regContent, ",");
                String gateway = optionsMap.get("GATEIPAddress");
                String ipAddress = optionsMap.get("IPAddress");
                String deviceType = optionsMap.get("DeviceType");
                if (!(authInfo != null && (gateway + ipAddress).equals(authInfo.getGateway() + authInfo.getIp()) && "2".equals(authInfo.getModeType()) && deviceType.equals(authInfo.getDeviceType()))) {
                    String netMask = optionsMap.get("NetMask");
                    String mac = optionsMap.get("MAC");
                    String deviceName = optionsMap.get("~DeviceName");
                    String server = optionsMap.get("WebServerURL");
                    AdmsAuthDeviceItem item = new AdmsAuthDeviceItem(ipAddress, mac, netMask, gateway, devSn, deviceType, server, deviceName);
                    item.setProtype("push");
                    item.setModeType("2");
                    if (!deviceType.equals("ai")) {
                        this.log.error("Ai deviceType request params error,please check!!!");
                    }
                    this.admsAuthDeviceService.setAuthDeviceInfo(item);
                }
                retInfo = "406";
            }
        }
        catch (Exception e) {
            retInfo = "Result=false, Message=Unknown Device";
            this.log.error("reg device error sn=" + devSn, (Throwable)e);
        }
        finally {
            this.admsDeviceService.regFinish(devSn);
        }
        return retInfo;
    }

    public String push(String sn) {
        String retInfo = "ServerVersion=%s\nServerName=%s\nPushVersion=%s\nErrorDelay=%s\nRequestDelay=%s\nTransTimes=%s\nTransInterval=%s\nTransTables=%s\nRealtime=%s\nSessionID=%s\nTimeoutSec=%s";
        try {
            String devJson = this.admsCacheManager.getDeviceInfo(sn);
            if (StringUtils.isNotBlank((CharSequence)devJson)) {
                JSONObject json = new JSONObject(devJson);
                retInfo = String.format(retInfo, JSONObjectUtil.getValueByKey(json, "ServerVersion"), JSONObjectUtil.getValueByKey(json, "ServerName"), JSONObjectUtil.getValueByKey(json, "PushVersion"), JSONObjectUtil.getValueByKey(json, "ErrorDelay"), JSONObjectUtil.getValueByKey(json, "RequestDelay"), JSONObjectUtil.getValueByKey(json, "TransTimes"), JSONObjectUtil.getValueByKey(json, "TransInterval"), JSONObjectUtil.getValueByKey(json, "TransTables"), JSONObjectUtil.getValueByKey(json, "Realtime"), JSONObjectUtil.getValueByKey(json, "SessionID"), JSONObjectUtil.getValueByKey(json, "TimeoutSec"));
            } else {
                retInfo = "406";
            }
        }
        catch (Exception e) {
            this.log.error("push  error", (Throwable)e);
            retInfo = "406";
        }
        return retInfo;
    }

    public String cdata(String sn, String table, String tableName, String authType, String count, String options, String data, String type, int port, String sessionId) {
        String rs = "OK";
        if (!"all".equals(options)) {
            String devJsonInfo = this.admsCacheManager.getDeviceInfo(sn);
            if (StringUtils.isBlank((CharSequence)devJsonInfo)) {
                return "406";
            }
            if (table == null && authType != null) {
                table = "AuthType";
            }
            table = table != null ? table : "ask";
            this.printLog("cdata", data);
            switch (table) {
                case "rtlog": {
                    break;
                }
                case "rtstate": {
                    break;
                }
                case "options": {
                    break;
                }
                case "tabledata": {
                    rs = this.dealTableData(sn, data, table, count, tableName, type, port, sessionId);
                    break;
                }
                case "AuthType": {
                    break;
                }
                case "ConnectState": {
                    break;
                }
                case "testdata": {
                    break;
                }
                case "testsignal": {
                    rs = "OK";
                    break;
                }
                case "ask": {
                    rs = "OK";
                    break;
                }
                default: {
                    rs = "406";
                }
            }
        }
        return rs;
    }

    public String getRequest(String sn, String cookiesToken) {
        String retInfo = "OK";
        this.admsDeviceService.updateDevOperateState(sn, "GET_RT_LOG", "0");
        String cmd = "";
        JSONObject devInfo = JSONObjectUtil.createJson(this.admsCacheManager.getDeviceInfo(sn));
        if (devInfo != null) {
            cmd = this.admsDeviceService.getCmd(sn, 10);
        }
        if (StringUtils.isNotBlank((CharSequence)cmd)) {
            retInfo = cmd;
        }
        return retInfo;
    }

    public String deviceCmd(String sn, String cookiesToken, String data) {
        this.printLog("cmd return", data);
        this.log.info("cmd return sn=" + sn + ",data=" + data);
        return this.admsDevCmdService.devReturnCmd(sn, data);
    }

    private String dealTableData(String sn, String data, String table, String count, String tableName, String type, int port, String sessionId) {
        String rs = "OK";
        try {
            boolean retValue;
            this.admsDeviceService.updateDevOperateState(sn, "DATA UPDATE", "0");
            int actualCount = StringUtils.isBlank((CharSequence)data) ? 0 : data.split("\r\n").length;
            rs = tableName + "=" + actualCount;
            if (actualCount == Integer.parseInt(count) && !(retValue = this.admsCacheManager.cacheAiUploadData(sn, table, tableName, count, data))) {
                rs = tableName + "=0";
            }
        }
        catch (Exception e) {
            this.log.error("Exception  error", (Throwable)e);
            rs = "406";
        }
        return rs;
    }

    public String querydata(String sn, String table, String count, int actualCount, String type, String data, String datafmt, String cmdId, String packcnt, String packidx, int port, String sessionId) {
        String retInfo = "OK";
        this.log.info("\u5b9e\u9645\u6761\u6570=" + actualCount + "  \u4e0a\u4f20\u6761\u6570=" + Integer.parseInt(count));
        if ("tabledata".equals(type) || "vmtable".equals(type)) {
            retInfo = table + "=" + count;
            if (actualCount == Integer.parseInt(count)) {
                JSONObject queryJson = new JSONObject();
                JSONObjectUtil.setKeyValue(queryJson, "type", type);
                JSONObjectUtil.setKeyValue(queryJson, "table", table);
                JSONObjectUtil.setKeyValue(queryJson, "count", count);
                JSONObjectUtil.setKeyValue(queryJson, "cmdId", cmdId);
                JSONObjectUtil.setKeyValue(queryJson, "packcnt", packcnt);
                JSONObjectUtil.setKeyValue(queryJson, "packIdx", packidx);
                JSONObjectUtil.setKeyValue(queryJson, "data", data);
                JSONObjectUtil.setKeyValue(queryJson, "sn", sn);
                if (!this.admsDeviceService.cacheDevQueryData(sn, queryJson.toString())) {
                    retInfo = table + "=0";
                    this.log.info("cache query data sn=" + sn + ",table=" + table + " to Redis failed!");
                }
            }
        } else if (("options".equals(type) || "count".equals(type)) && !"".equals(data.trim())) {
            Map<String, String> devOptions = DeviceDataUtil.formateStrToMap(data.trim(), ",");
            this.admsDeviceService.updateAccDeviceOptions(sn, devOptions, type, cmdId);
        }
        return retInfo;
    }

    public String rtdata(String sn, String type) throws Exception {
        JSONObject admsDevice = JSONObjectUtil.createJson(this.admsCacheManager.getDeviceInfo(sn));
        return this.dealRTData(admsDevice, type);
    }

    private String downFile(String sn, String datacode, String fileUrl) {
        boolean isB64Code = true;
        if (StringUtils.isNotBlank((CharSequence)datacode) && "original".equals(datacode)) {
            isB64Code = false;
        }
        String rs = null;
        URL url = null;
        HttpURLConnection httpUrl = null;
        InputStream is = null;
        ByteArrayOutputStream outStream = null;
        try {
            url = new URL(fileUrl);
            httpUrl = (HttpURLConnection)url.openConnection();
            httpUrl.connect();
            is = httpUrl.getInputStream();
            outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            rs = isB64Code ? Base64Utils.encodeToString((byte[])outStream.toByteArray()) : new String(outStream.toByteArray(), "");
        }
        catch (IOException e) {
            this.log.error("upgradeFirmware error", (Throwable)e);
            throw new ZKBusinessException("upgradeFirmware error");
        }
        finally {
            try {
                is.close();
                outStream.close();
                httpUrl.disconnect();
            }
            catch (IOException e) {
                this.log.error("upgradeFirmware error", (Throwable)e);
            }
        }
        return rs;
    }

    private String dealRTData(JSONObject admsDevice, String type) throws Exception {
        String rs = "OK";
        if ("time".equals(type)) {
            String retStr = "";
            Calendar cd = Calendar.getInstance();
            SimpleDateFormat gmtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            gmtFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            String str = gmtFormat.format(cd.getTime());
            SimpleDateFormat generalFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = generalFormat.parse(str);
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("Z");
            rs = retStr = String.format("DateTime=%d,ServerTZ=%s", DeviceDataUtil.enCodeTime(date), sdf.format(cal.getTime()));
        }
        return rs;
    }
}

