/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.cloud.sdk.util;

import com.zkteco.cloud.sdk.ApiException;
import com.zkteco.cloud.sdk.ZKCouldClient;
import com.zkteco.cloud.sdk.request.ApiAuthTokenCreateRequest;
import com.zkteco.cloud.sdk.request.ApiAuthTokenRefreshRequest;
import com.zkteco.cloud.sdk.resp.ObjectResponse;
import com.zkteco.cloud.sdk.response.ApiAuthTokenResponse;
import com.zkteco.cloud.sdk.util.EncrypAESUtil;

public class ZKCloudApiTokenUtil {
    public static ApiAuthTokenResponse authTokenCreateRequest(ZKCouldClient client, String appKey, String grantType) {
        try {
            ApiAuthTokenCreateRequest req = new ApiAuthTokenCreateRequest();
            String iv = new StringBuilder(appKey.substring(8, 24)).reverse().toString();
            String tempAppKey = "HMACSHA256$" + EncrypAESUtil.encryptHMACSHA256(appKey, iv);
            req.setAppKey(tempAppKey);
            req.setGrantType(grantType);
            ObjectResponse<ApiAuthTokenResponse> rsp1 = client.execute(req, null);
            return rsp1.getO();
        }
        catch (ApiException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ApiAuthTokenResponse authTokenRefreshRequest(ZKCouldClient client, String grantType, String refreshToken) {
        try {
            ApiAuthTokenRefreshRequest req = new ApiAuthTokenRefreshRequest();
            req.setRefreshToken(refreshToken);
            req.setGrantType(grantType);
            ObjectResponse<ApiAuthTokenResponse> rsp1 = client.execute(req, null);
            return rsp1.getO();
        }
        catch (ApiException e) {
            e.printStackTrace();
            return null;
        }
    }
}

