/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BaseMessageRemote;
import com.zkteco.zkbiosecurity.system.service.BaseMessageService;
import com.zkteco.zkbiosecurity.system.vo.BaseMessageItem;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/baseMessage.do"})
public class BaseMessageController
extends BaseController
implements BaseMessageRemote {
    private static final Logger log = LoggerFactory.getLogger(BaseMessageController.class);
    @Autowired
    private BaseMessageService baseMessageService;

    @RequiresPermissions(value={"system:baseMessage"})
    public ModelAndView index() {
        return new ModelAndView("system/baseMessage/baseMessage");
    }

    @RequiresPermissions(value={"system:baseMessage:add", "system:baseMessage:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.baseMessageService.getItemById(id));
        }
        return new ModelAndView("system/baseMessage/editBaseMessage");
    }

    @RequiresPermissions(value={"system:baseMessage:add", "system:baseMessage:edit"})
    public ZKResultMsg save(BaseMessageItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.baseMessageService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"system:baseMessage:refresh"})
    public DxGrid list(BaseMessageItem condition) {
        Pager pager = this.baseMessageService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"system:baseMessage:del"})
    public ZKResultMsg del(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        boolean ret = this.baseMessageService.deleteByIds(ids);
        if (!ret) {
            retMsg.setRet("fail");
            retMsg.setMsg(I18nUtil.i18nCode((String)"common_prompt_initDataCanNotDel", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ZKResultMsg getMessages(BaseMessageItem item) {
        ZKResultMsg ret = new ZKResultMsg();
        ret.setData((Object)this.baseMessageService.getSystemMsg());
        return ret;
    }

    public ZKResultMsg read(String id) {
        this.baseMessageService.alreadyRead(id);
        return ZKResultMsg.successMsg();
    }
}

