/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.wechat.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;

@From(after="WECHAT_MINI_PROGRAM mp LEFT JOIN WECHAT_PERSONALIZATION p ON mp.ID = p.WECHAT_ID")
@OrderBy(after="p.CREATE_TIME DESC")
@GridConfig(operate=true, winHeight=240, winWidth=450, operates={@GridOperate(type="edit", permission="wechat:personalization:auth", url="weChatPersonalization.do?authPersonalizationPage", label="common_op_edit"), @GridOperate(type="custom", permission="wechat:personalization:del", click="showDeleteConfirmPage", label="common_op_del")})
public class WeChatPersonalizationItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="p.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sortNo=0, show=false)
    private String id;
    @Column(name="mp.ID", equalTag="=")
    private String wechatId;
    @Column(name="mp.COMPANY_ID", equalTag="=")
    private String companyId;
    @Column(name="mp.NAME")
    @GridColumn(label="wechat_mini_program_name", width="200")
    private String miniProgramName;
    @Column(name="mp.MINI_PROGRAM_APP_TYPE")
    @GridColumn(label="wechat_mini_program_mini_program_app_type", width="100", format="0=wechat_mini_program_normal_mini_program_app,1=wechat_mini_program_park_central_mini_program_app,2=wechat_mini_program_vis_central_mini_program_app,3=wechat_mini_program_privatization_mini_program_app")
    private Integer miniProgramAppType;
    @Column(name="p.ENABLE")
    private Boolean enable;
    @Column(name="p.CUSTOMIZATION")
    @GridColumn(label="wechat_personalization_customization", width="200", format="true=common_yes,false=common_no")
    private Boolean customization;
    @Column(name="p.CUSTOMIZED_CONTENT")
    private String customizedContent;
    @GridColumn(label="wechat_personalization_customized_content", width="200")
    private String customizedContentText;
    @Column(name="p.CREATE_TIME")
    @GridColumn(label="wechat_personalization_auth_date", width="200")
    private Date authDate;
    @Column(name="p.WECHAT_ID IS NOT NULL")
    private Boolean isAuthorized;
    @Column(name="mp.ORIGINAL_ACCOUNTID", equalTag="=")
    private String originalId;
    @Condition(value="mp.CREATER_ID", equalTag="IN")
    private String creatorIdIn;
    @Condition(value="p.WECHAT_ID IS NOT NULL")
    private String authorized;
    @Condition(value="p.WECHAT_ID IS NULL")
    private String unauthorized;
    @Condition(value="p.ID", equalTag="IN")
    private String idIn;
    @Condition(value="mp.ID", equalTag="IN")
    private String wechatIdIn;

    public String getId() {
        return this.id;
    }

    public String getWechatId() {
        return this.wechatId;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public String getMiniProgramName() {
        return this.miniProgramName;
    }

    public Integer getMiniProgramAppType() {
        return this.miniProgramAppType;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public Boolean getCustomization() {
        return this.customization;
    }

    public String getCustomizedContent() {
        return this.customizedContent;
    }

    public String getCustomizedContentText() {
        return this.customizedContentText;
    }

    public Date getAuthDate() {
        return this.authDate;
    }

    public Boolean getIsAuthorized() {
        return this.isAuthorized;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public String getCreatorIdIn() {
        return this.creatorIdIn;
    }

    public String getAuthorized() {
        return this.authorized;
    }

    public String getUnauthorized() {
        return this.unauthorized;
    }

    public String getIdIn() {
        return this.idIn;
    }

    public String getWechatIdIn() {
        return this.wechatIdIn;
    }

    public WeChatPersonalizationItem setId(String id) {
        this.id = id;
        return this;
    }

    public WeChatPersonalizationItem setWechatId(String wechatId) {
        this.wechatId = wechatId;
        return this;
    }

    public WeChatPersonalizationItem setCompanyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    public WeChatPersonalizationItem setMiniProgramName(String miniProgramName) {
        this.miniProgramName = miniProgramName;
        return this;
    }

    public WeChatPersonalizationItem setMiniProgramAppType(Integer miniProgramAppType) {
        this.miniProgramAppType = miniProgramAppType;
        return this;
    }

    public WeChatPersonalizationItem setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    public WeChatPersonalizationItem setCustomization(Boolean customization) {
        this.customization = customization;
        return this;
    }

    public WeChatPersonalizationItem setCustomizedContent(String customizedContent) {
        this.customizedContent = customizedContent;
        return this;
    }

    public WeChatPersonalizationItem setCustomizedContentText(String customizedContentText) {
        this.customizedContentText = customizedContentText;
        return this;
    }

    public WeChatPersonalizationItem setAuthDate(Date authDate) {
        this.authDate = authDate;
        return this;
    }

    public WeChatPersonalizationItem setIsAuthorized(Boolean isAuthorized) {
        this.isAuthorized = isAuthorized;
        return this;
    }

    public WeChatPersonalizationItem setOriginalId(String originalId) {
        this.originalId = originalId;
        return this;
    }

    public WeChatPersonalizationItem setCreatorIdIn(String creatorIdIn) {
        this.creatorIdIn = creatorIdIn;
        return this;
    }

    public WeChatPersonalizationItem setAuthorized(String authorized) {
        this.authorized = authorized;
        return this;
    }

    public WeChatPersonalizationItem setUnauthorized(String unauthorized) {
        this.unauthorized = unauthorized;
        return this;
    }

    public WeChatPersonalizationItem setIdIn(String idIn) {
        this.idIn = idIn;
        return this;
    }

    public WeChatPersonalizationItem setWechatIdIn(String wechatIdIn) {
        this.wechatIdIn = wechatIdIn;
        return this;
    }

    public String toString() {
        return "WeChatPersonalizationItem(id=" + this.getId() + ", wechatId=" + this.getWechatId() + ", companyId=" + this.getCompanyId() + ", miniProgramName=" + this.getMiniProgramName() + ", miniProgramAppType=" + this.getMiniProgramAppType() + ", enable=" + this.getEnable() + ", customization=" + this.getCustomization() + ", customizedContent=" + this.getCustomizedContent() + ", customizedContentText=" + this.getCustomizedContentText() + ", authDate=" + this.getAuthDate() + ", isAuthorized=" + this.getIsAuthorized() + ", originalId=" + this.getOriginalId() + ", creatorIdIn=" + this.getCreatorIdIn() + ", authorized=" + this.getAuthorized() + ", unauthorized=" + this.getUnauthorized() + ", idIn=" + this.getIdIn() + ", wechatIdIn=" + this.getWechatIdIn() + ")";
    }
}

