/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ele.remote.EleTransactionRemote;
import com.zkteco.zkbiosecurity.ele.service.EleTransactionService;
import com.zkteco.zkbiosecurity.ele.vo.EleTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleTransactionController
extends ExportController
implements EleTransactionRemote {
    @Autowired
    private EleTransactionService eleTransactionService;

    @RequiresPermissions(value={"ele:transaction"})
    public ModelAndView index() {
        return new ModelAndView("ele/transaction/eleTransaction");
    }

    @RequiresPermissions(value={"ele:transaction:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleTransactionService.getItemById(id));
        }
        return new ModelAndView("ele/transaction/editEleTransaction");
    }

    @RequiresPermissions(value={"ele:transaction:edit"})
    public ZKResultMsg save(EleTransactionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleTransactionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:transaction:refresh"})
    public DxGrid list(EleTransactionItem condition) {
        Pager pager = this.eleTransactionService.loadTransactionByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:transaction:del"})
    public ZKResultMsg del(String ids) {
        this.eleTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ele:transaction:clearData"})
    @LogRequest(module="ele_module", object="common_leftMenu_transaction", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.eleTransactionService.deleteAllData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public TreeItem getFieldList(String filterField, String dataType) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        List fieldList = this.eleTransactionService.getFieldList(filterField, dataType);
        for (String str : fieldList) {
            item = new TreeItem();
            item.setId(str);
            item.setText(str);
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    @LogRequest(module="ele_module", object="common_leftMenu_transaction", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        EleTransactionItem eleTransactionItem = new EleTransactionItem();
        this.setConditionValue((BaseItem)eleTransactionItem);
        String sessionId = request.getSession().getId();
        String areaNames = this.eleTransactionService.getAreaNamesByAuthFilter(sessionId);
        String deptCodes = this.eleTransactionService.getDeptCodesByAuthFilter(sessionId);
        eleTransactionItem.setAreaNameIn(areaNames);
        eleTransactionItem.setDeptCodeIn(deptCodes);
        List itemList = this.eleTransactionService.getItemData(EleTransactionItem.class, (BaseItem)eleTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, EleTransactionItem.class);
    }

    public ZKResultMsg isFileExist(String vidLinkageHandle) {
        boolean isExist = this.eleTransactionService.isFileExist(vidLinkageHandle);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)String.valueOf(isExist)));
    }

    public ZKResultMsg viewVidLinkData(String vidLinkageHandle, String fileType) {
        return this.eleTransactionService.viewVidLinkData(vidLinkageHandle, fileType);
    }

    public ZKResultMsg getVideoFile(String id) {
        Map retMap = this.eleTransactionService.getVideoFileValidate(id);
        ZKResultMsg ret = (ZKResultMsg)retMap.get("ret");
        if (null != ret) {
            return I18nUtil.i18nMsg((ZKResultMsg)ret);
        }
        String filePath = retMap.get("filePath").toString();
        File file = (File)retMap.get("file");
        int index = filePath.lastIndexOf(File.separator);
        String fileName = filePath.substring(index + 1);
        if (file.isDirectory() && file.listFiles().length > 0) {
            File childFile = file.listFiles()[0];
            fileName = fileName.substring(0, fileName.lastIndexOf(".")) + childFile.getName().substring(childFile.getName().lastIndexOf("."));
        }
        this.response.setCharacterEncoding("utf-8");
        this.response.setContentType("multipart/form-data");
        this.response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
        try {
            int length;
            FileInputStream inputStream = new FileInputStream(filePath);
            ServletOutputStream os = this.response.getOutputStream();
            byte[] b = new byte[2048];
            while ((length = ((InputStream)inputStream).read(b)) > 0) {
                os.write(b, 0, length);
            }
            os.close();
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        return null;
    }
}

