/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleHolidayRemote;
import com.zkteco.zkbiosecurity.ele.service.EleHolidayService;
import com.zkteco.zkbiosecurity.ele.vo.EleHolidayItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleHolidayController
extends BaseController
implements EleHolidayRemote {
    private final int MAX_HOLIDAY_COUNT_PER_TYPE = 32;
    @Autowired
    private EleHolidayService eleHolidayService;

    @RequiresPermissions(value={"ele:holiday"})
    public ModelAndView index() {
        return new ModelAndView("ele/holiday/eleHoliday");
    }

    @RequiresPermissions(value={"ele:holiday:add", "ele:holiday:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleHolidayService.getItemById(id));
        }
        return new ModelAndView("ele/holiday/editEleHoliday");
    }

    @RequiresPermissions(value={"ele:holiday:add", "ele:holiday:edit"})
    @LogRequest(module="ele_module", object="common_leftMenu_holiday", opType="common_op_edit", requestParams={"name"}, opContent="common_holiday_name")
    public ZKResultMsg save(EleHolidayItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleHolidayService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:holiday:refresh"})
    public DxGrid list(EleHolidayItem condition) {
        Pager pager = this.eleHolidayService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:holiday:del"})
    @LogRequest(module="ele_module", object="common_leftMenu_holiday", opType="common_op_del", requestParams={"names"}, opContent="common_holiday_name")
    public ZKResultMsg del(String ids) {
        this.eleHolidayService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExist(String name) {
        return this.eleHolidayService.isExist(name);
    }

    public ZKResultMsg dataValid(EleHolidayItem eleHolidayItem) {
        String result = "true";
        Date nowDate = new Date();
        int holidayCount = this.eleHolidayService.getByCondition(new EleHolidayItem()).size();
        if (StringUtils.isNotBlank((CharSequence)eleHolidayItem.getId())) {
            --holidayCount;
        }
        if (holidayCount == 32) {
            result = I18nUtil.i18nCode((String)"common_holiday_countError", (Object[])new Object[]{String.valueOf(32)});
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
        }
        Date startDate = DateUtil.stringToDate((String)eleHolidayItem.getStartDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
        Date endDate = DateUtil.stringToDate((String)eleHolidayItem.getEndDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
        if (startDate.getTime() > endDate.getTime()) {
            result = I18nUtil.i18nCode((String)"common_startEndDateCompare", (Object[])new Object[0]);
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
        }
        if (DateUtil.getYear((Date)endDate) < DateUtil.getYear((Date)nowDate) || DateUtil.getYear((Date)startDate) < DateUtil.getYear((Date)nowDate) || DateUtil.getYear((Date)endDate) - DateUtil.getYear((Date)startDate) != 0) {
            result = I18nUtil.i18nCode((String)"common_holiday_fillError3", (Object[])new Object[0]);
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
        }
        List<Date> currentDate = this.getDateBetween(startDate, endDate);
        List<Date> existDate = this.getAllHolidaysDate(eleHolidayItem);
        for (Date date : currentDate) {
            if (!existDate.contains(date)) continue;
            result = I18nUtil.i18nCode((String)"common_holiday_fillError4", (Object[])new Object[]{DateUtil.dateToString((Date)date, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD)});
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
        }
        ArrayList monthAndDay = Lists.newArrayList();
        for (Date date : currentDate) {
            monthAndDay.add(DateUtil.getMonth((Date)date) + "-" + DateUtil.getDay((Date)date));
        }
        Set<List<String>> set = this.getAllMonthDay(eleHolidayItem);
        for (Date date : currentDate) {
            if (!set.contains(monthAndDay)) continue;
            result = I18nUtil.i18nCode((String)"common_holiday_fillError5", (Object[])new Object[]{String.valueOf(DateUtil.getMonth((Date)date)), String.valueOf(DateUtil.getDay((Date)date))});
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
    }

    public List<Date> getDateBetween(Date startDate, Date endDate) {
        ArrayList dateList = Lists.newArrayList();
        int delta = (int)((endDate.getTime() - startDate.getTime()) / 1000L / 24L / 60L / 60L);
        for (int d = 0; d < delta + 1; ++d) {
            dateList.add(new Date(startDate.getTime() + 86400000L * (long)d));
        }
        return dateList;
    }

    public List<Date> getAllHolidaysDate(EleHolidayItem eleHolidayItem) {
        HashSet allDate = Sets.newHashSet();
        ArrayList holidayList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)eleHolidayItem.getId())) {
            EleHolidayItem tempHoliday = new EleHolidayItem();
            tempHoliday.setNotInId(eleHolidayItem.getId());
            holidayList.addAll(this.eleHolidayService.getByCondition(tempHoliday));
        } else {
            List holidays = this.eleHolidayService.getByCondition(new EleHolidayItem());
            if (holidays != null && holidays.size() > 0) {
                holidayList.addAll(holidays);
            }
        }
        holidayList.stream().forEach(holiday -> {
            Date startDate = DateUtil.stringToDate((String)holiday.getStartDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
            Date endDate = DateUtil.stringToDate((String)holiday.getEndDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
            allDate.addAll(this.getDateBetween(startDate, endDate));
        });
        return Lists.newArrayList((Iterable)allDate);
    }

    public Set<List<String>> getAllMonthDay(EleHolidayItem eleHolidayItem) {
        EleHolidayItem tempHoliday = null;
        HashSet allDate = Sets.newHashSet();
        ArrayList allMonthDay = Lists.newArrayList();
        ArrayList allHolidaysList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)eleHolidayItem.getId())) {
            if (!eleHolidayItem.getIsLoopByYear().booleanValue()) {
                tempHoliday = new EleHolidayItem();
                tempHoliday.setNotInId(eleHolidayItem.getId());
                tempHoliday.setIsLoopByYear(Boolean.valueOf(true));
                allHolidaysList.addAll(this.eleHolidayService.getByCondition(tempHoliday));
            } else {
                tempHoliday = new EleHolidayItem();
                tempHoliday.setNotInId(eleHolidayItem.getId());
                allHolidaysList.addAll(this.eleHolidayService.getByCondition(tempHoliday));
            }
        } else if (!eleHolidayItem.getIsLoopByYear().booleanValue()) {
            tempHoliday = new EleHolidayItem();
            tempHoliday.setIsLoopByYear(Boolean.valueOf(true));
            allHolidaysList.addAll(this.eleHolidayService.getByCondition(tempHoliday));
        } else {
            allHolidaysList.addAll(this.eleHolidayService.getByCondition(new EleHolidayItem()));
        }
        allHolidaysList.stream().forEach(holiday -> {
            Date startDate = DateUtil.stringToDate((String)holiday.getStartDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
            Date endDate = DateUtil.stringToDate((String)holiday.getEndDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
            allDate.addAll(this.getDateBetween(startDate, endDate));
        });
        allDate.stream().forEach(date -> {
            String monthAndDay = DateUtil.getMonth((Date)date) + "-" + DateUtil.getDay((Date)date);
            allMonthDay.add(monthAndDay);
        });
        return new HashSet<List<String>>(allMonthDay);
    }
}

