/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.constants.EleConstants;
import com.zkteco.zkbiosecurity.ele.remote.EleDeviceVerifyModeRemote;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceVerifyModeService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class EleDeviceVerifyModeController
extends BaseController
implements EleDeviceVerifyModeRemote {
    @Autowired
    private EleDeviceVerifyModeService eleDeviceVerifyModeService;

    public ZKResultMsg getVerifyMode(String deviceId) {
        return new ZKResultMsg((Object)this.eleDeviceVerifyModeService.getVerifyModeList(deviceId));
    }

    public TreeItem getDeviceVerifyModeTree() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        Map verifyModesMap = EleConstants.VERIFY_MODE;
        Set keySet = verifyModesMap.keySet();
        Object[] keySetArray = keySet.toArray();
        Arrays.sort(keySetArray);
        for (Object key : keySetArray) {
            TreeItem item = new TreeItem();
            item.setId((String)verifyModesMap.get(key));
            item.setText(I18nUtil.i18nCode((String)((String)verifyModesMap.get(key)), (Object[])new Object[0]));
            item.setParent(new TreeItem("0"));
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }
}

