/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.jnlp.OptionsDefinitions;
import net.sourceforge.jnlp.about.AboutDialog;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.policyeditor.CustomPolicyViewer;
import net.sourceforge.jnlp.security.policyeditor.IndeterminateProgressDialog;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorAboutDialog;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorController;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorPermissions;
import net.sourceforge.jnlp.security.policyeditor.PolicyEntry;
import net.sourceforge.jnlp.security.policyeditor.PolicyIdentifier;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.docprovider.PolicyEditorTextsProvider;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.PlainTextFormatter;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.optionparser.OptionParser;
import net.sourceforge.jnlp.util.ui.SwingHelpers;
import net.sourceforge.swing.SwingUtils;
import sun.security.provider.PolicyParser;

public class PolicyEditor
extends JPanel {
    private boolean closed = false;
    private final Map<PolicyEditorPermissions, JCheckBox> checkboxMap = new TreeMap<PolicyEditorPermissions, JCheckBox>();
    private final List<JCheckBoxWithGroup> groupBoxList = new ArrayList<JCheckBoxWithGroup>(PolicyEditorPermissions.Group.values().length);
    private final JScrollPane scrollPane = new JScrollPane();
    private final DefaultListModel<PolicyIdentifier> listModel = new DefaultListModel();
    private final JList<PolicyIdentifier> list = new JList<PolicyIdentifier>(this.listModel);
    private final JButton okButton = new JButton();
    private final JButton closeButton = new JButton();
    private final JButton addEntryButton = new JButton();
    private final JButton removeEntryButton = new JButton();
    private final JFileChooser fileChooser;
    private CustomPolicyViewer cpViewer = null;
    private final WeakReference<PolicyEditor> parentPolicyEditor = new WeakReference<PolicyEditor>(this);
    public final PolicyEditorController policyEditorController = new PolicyEditorController();
    private final ActionListener okButtonAction;
    private final ActionListener addEntryButtonAction;
    private final ActionListener removeEntryButtonAction;
    private final ActionListener newButtonAction;
    private final ActionListener openButtonAction;
    private final ActionListener openDefaultButtonAction;
    private final ActionListener saveAsButtonAction;
    private final ActionListener viewCustomButtonAction;
    private final ActionListener modifyCodebaseButtonAction;
    private final ActionListener modifyPrincipalsButtonAction;
    private final ActionListener modifySignedByButtonAction;
    private final ActionListener copyEntryButtonAction;
    private final ActionListener pasteEntryButtonAction;
    private final ActionListener policyEditorHelpButtonAction;
    private final ActionListener aboutPolicyEditorButtonAction;
    private final ActionListener aboutItwButtonAction;
    private final ActionListener closeButtonAction;

    public PolicyEditor(String filepath) {
        this.setLayout(new GridBagLayout());
        for (PolicyEditorPermissions perm : PolicyEditorPermissions.values()) {
            JCheckBox box = new JCheckBox();
            box.setText(perm.getName());
            box.setToolTipText(perm.getDescription());
            this.checkboxMap.put(perm, box);
        }
        this.setFile(filepath);
        this.addDefaultAllAppletsIdentifier();
        this.setChangesMade(false);
        this.fileChooser = new JFileChooser(this.policyEditorController.getFile());
        this.fileChooser.setFileHidingEnabled(false);
        this.okButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int choice;
                if (PolicyEditor.this.policyEditorController.getFile() == null && (choice = PolicyEditor.this.fileChooser.showOpenDialog(PolicyEditor.this)) == 0) {
                    PolicyEditor.this.setFile(PolicyEditor.this.fileChooser.getSelectedFile().getAbsolutePath());
                }
                if (PolicyEditor.this.policyEditorController.getFile() != null) {
                    PolicyEditor.this.setChangesMade(true);
                    PolicyEditor.this.savePolicyFile();
                }
            }
        };
        this.okButton.setText(Translator.R("ButApply"));
        this.okButton.addActionListener(this.okButtonAction);
        this.addEntryButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyEditor.this.addNewIdentifierInteractive();
            }
        };
        this.addEntryButton.setText(Translator.R("PEAddEntry"));
        this.addEntryButton.addActionListener(this.addEntryButtonAction);
        this.removeEntryButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyEditor.this.removeIdentifier(PolicyEditor.this.getSelectedPolicyIdentifier());
            }
        };
        this.removeEntryButton.setText(Translator.R("PERemoveEntry"));
        this.removeEntryButton.addActionListener(this.removeEntryButtonAction);
        this.newButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PolicyEditor.this.promptOnSaveChangesMade(false)) {
                    return;
                }
                PolicyEditor.this.setFile(null);
                PolicyEditor.this.setChangesMade(false);
            }
        };
        this.openButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PolicyEditor.this.promptOnSaveChangesMade(true)) {
                    return;
                }
                int choice = PolicyEditor.this.fileChooser.showOpenDialog(PolicyEditor.this);
                if (choice == 0) {
                    PolicyEditor.this.setFile(PolicyEditor.this.fileChooser.getSelectedFile().getAbsolutePath());
                    PolicyEditor.this.openAndParsePolicyFile();
                }
            }
        };
        this.openDefaultButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!PolicyEditor.this.promptOnSaveChangesMade(true)) {
                    return;
                }
                try {
                    PolicyEditor.this.setFile(PolicyEditor.getDefaultPolicyFilePath());
                    PolicyEditor.this.getFile().createNewFile();
                }
                catch (IOException | URISyntaxException e) {
                    OutputController.getLogger().log(e);
                    return;
                }
                PolicyEditor.this.openAndParsePolicyFile();
            }
        };
        this.saveAsButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int choice = PolicyEditor.this.fileChooser.showSaveDialog(PolicyEditor.this);
                if (choice == 0) {
                    PolicyEditor.this.setFile(PolicyEditor.this.fileChooser.getSelectedFile().getAbsolutePath());
                    PolicyEditor.this.setChangesMade(true);
                    PolicyEditor.this.savePolicyFile();
                }
            }
        };
        this.modifyCodebaseButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newCodebase;
                if (PolicyEditor.this.getSelectedPolicyIdentifier().equals(PolicyIdentifier.ALL_APPLETS_IDENTIFIER)) {
                    return;
                }
                String oldCodebase = PolicyEditor.this.getSelectedPolicyIdentifier().getCodebase();
                do {
                    if ((newCodebase = JOptionPane.showInputDialog(PolicyEditor.this, Translator.R("PEModifyCodebase"), oldCodebase)) != null) continue;
                    return;
                } while (!PolicyEditor.validateCodebase(newCodebase));
                PolicyEditor.this.modifyCodebase(PolicyEditor.this.getSelectedPolicyIdentifier(), newCodebase);
            }
        };
        this.modifyPrincipalsButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PolicyEditor.this.getSelectedPolicyIdentifier().equals(PolicyIdentifier.ALL_APPLETS_IDENTIFIER)) {
                    return;
                }
                PrincipalsPanel panel = new PrincipalsPanel(PolicyEditor.this.getSelectedPolicyIdentifier().getPrincipals());
                int option = JOptionPane.showConfirmDialog(null, new Object[]{Translator.R("PEPrincipalsInputLabel"), panel}, Translator.R("PEEntryPrompt"), 2);
                if (option == 0) {
                    PolicyEditor.this.modifyPrincipals(PolicyEditor.this.getSelectedPolicyIdentifier(), panel.getPrincipals());
                }
            }
        };
        this.modifySignedByButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PolicyEditor.this.getSelectedPolicyIdentifier().equals(PolicyIdentifier.ALL_APPLETS_IDENTIFIER)) {
                    return;
                }
                String newSignedBy = JOptionPane.showInputDialog(PolicyEditor.this, Translator.R("PEModifySignedBy"), PolicyEditor.this.getSelectedPolicyIdentifier().getSignedBy());
                if (newSignedBy == null) {
                    return;
                }
                PolicyEditor.this.modifySignedBy(PolicyEditor.this.getSelectedPolicyIdentifier(), newSignedBy);
            }
        };
        this.copyEntryButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyEditor.this.copyEntry(PolicyEditor.this.getSelectedPolicyIdentifier());
            }
        };
        this.pasteEntryButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyIdentifier identifier = null;
                try {
                    identifier = PolicyEditorController.getPolicyEntryFromClipboard().getPolicyIdentifier();
                    PolicyEditor.this.pasteEntry(PolicyEditor.this.promptForPolicyIdentifier(identifier));
                }
                catch (UnsupportedFlavorException ufe) {
                    OutputController.getLogger().log(ufe);
                    PolicyEditor.this.showClipboardErrorDialog();
                }
                catch (PolicyParser.ParsingException pe) {
                    OutputController.getLogger().log(pe);
                    PolicyEditor.this.showInvalidPolicyExceptionDialog(identifier);
                }
                catch (IOException ioe) {
                    OutputController.getLogger().log(ioe);
                    PolicyEditor.this.showCouldNotAccessClipboardDialog();
                }
            }
        };
        this.viewCustomButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtils.invokeRunnableOrEnqueueLater(new Runnable(){

                    @Override
                    public void run() {
                        PolicyIdentifier policyIdentifier = PolicyEditor.this.getSelectedPolicyIdentifier();
                        if (policyIdentifier == null) {
                            return;
                        }
                        if (PolicyEditor.this.cpViewer == null) {
                            PolicyEditor.this.cpViewer = new CustomPolicyViewer(PolicyEditor.this, policyIdentifier);
                            PolicyEditor.this.cpViewer.setVisible(true);
                        } else {
                            PolicyEditor.this.cpViewer.toFront();
                            PolicyEditor.this.cpViewer.repaint();
                        }
                    }
                });
            }
        };
        this.policyEditorHelpButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new PolicyEditorAboutDialog(Translator.R("PEHelpDialogTitle"), Translator.R("PEHelpDialogContent")).setVisible(true);
            }
        };
        this.aboutPolicyEditorButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean modal = PolicyEditor.this.getModality();
                AboutDialog.display(modal, "policyeditor", AboutDialog.ShowPage.HELP);
            }
        };
        this.aboutItwButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean modal = PolicyEditor.this.getModality();
                AboutDialog.display(modal, "policyeditor");
            }
        };
        this.closeButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Window parentWindow = SwingUtils.getWindowAncestor(PolicyEditor.this);
                if (parentWindow instanceof PolicyEditorWindow) {
                    ((PolicyEditorWindow)((Object)parentWindow)).quit();
                }
            }
        };
        this.closeButton.setText(Translator.R("ButClose"));
        this.closeButton.addActionListener(this.closeButtonAction);
        this.setupLayout();
    }

    private static String getDefaultPolicyFilePath() throws URISyntaxException {
        return new File(new URI(PathsAndFiles.JAVA_POLICY.getFullPath())).getAbsolutePath();
    }

    private void addDefaultAllAppletsIdentifier() {
        this.addNewEntry(PolicyIdentifier.ALL_APPLETS_IDENTIFIER);
    }

    private boolean getModality() {
        boolean modal = false;
        for (Container parent = this; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JDialog)) continue;
            modal = ((JDialog)parent).isModal();
            break;
        }
        return modal;
    }

    private boolean promptOnSaveChangesMade(boolean async) {
        if (this.policyEditorController.changesMade()) {
            int save = JOptionPane.showConfirmDialog(this, Translator.R("PESaveChanges"));
            if (save == 0) {
                if (this.getFile() == null) {
                    int choice = this.fileChooser.showSaveDialog(this);
                    if (choice == 0) {
                        this.setFile(this.fileChooser.getSelectedFile().getAbsolutePath());
                    } else if (choice == 1) {
                        return false;
                    }
                }
                if (async) {
                    this.savePolicyFile();
                } else {
                    try {
                        this.policyEditorController.savePolicyFile();
                    }
                    catch (IOException e) {
                        this.showCouldNotSaveDialog();
                    }
                }
            } else if (save == 2) {
                return false;
            }
        }
        return true;
    }

    public void setFile(String filepath) {
        if (filepath != null) {
            this.policyEditorController.setFile(new File(filepath));
        } else {
            this.policyEditorController.setFile(null);
            this.resetEntries();
            this.addDefaultAllAppletsIdentifier();
        }
        this.setParentWindowTitle(this.getWindowTitleForStatus());
    }

    private void setParentWindowTitle(final String title) {
        SwingUtils.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                Window parent = SwingUtils.getWindowAncestor(PolicyEditor.this);
                if (!(parent instanceof PolicyEditorWindow)) {
                    return;
                }
                PolicyEditorWindow window = (PolicyEditorWindow)((Object)parent);
                window.setTitle(title);
            }
        });
    }

    private String getWindowTitleForStatus() {
        File file = this.getFile();
        String filepath = file != null ? file.getPath() : null;
        String titleAndPath = filepath != null ? Translator.R("PETitleWithPath", filepath) : Translator.R("PETitle");
        String result = this.policyEditorController.changesMade() ? Translator.R("PETitleWithChangesMade", titleAndPath) : titleAndPath;
        return result;
    }

    private PolicyIdentifier getSelectedPolicyIdentifier() {
        return this.list.getSelectedValue();
    }

    private static void preparePolicyEditorWindow(PolicyEditorWindow w, PolicyEditor e) {
        w.setModalityType(Dialog.ModalityType.MODELESS);
        w.setPolicyEditor(e);
        w.setTitle(Translator.R("PETitle"));
        w.setDefaultCloseOperation(0);
        w.setJMenuBar(PolicyEditor.createMenuBar(w.getPolicyEditor()));
        PolicyEditor.setupPolicyEditorWindow(w.asWindow(), w.getPolicyEditor());
    }

    private static void setupPolicyEditorWindow(final Window window, PolicyEditor editor) {
        window.add(editor);
        window.pack();
        editor.setVisible(true);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ((PolicyEditorWindow)((Object)window)).quit();
            }
        });
    }

    private static void policyEditorWindowQuit(Window window) {
        PolicyEditor editor = ((PolicyEditorWindow)((Object)window)).getPolicyEditor();
        editor.parentPolicyEditor.clear();
        if (editor.policyEditorController.changesMade()) {
            int save = JOptionPane.showConfirmDialog(window, Translator.R("PESaveChanges"));
            if (save == 0) {
                if (editor.policyEditorController.getFile() == null) {
                    int choice = editor.fileChooser.showSaveDialog(window);
                    if (choice == 0) {
                        editor.setFile(editor.fileChooser.getSelectedFile().getAbsolutePath());
                    } else if (choice == 1) {
                        return;
                    }
                }
                try {
                    editor.policyEditorController.savePolicyFile();
                }
                catch (IOException e) {
                    OutputController.getLogger().log(e);
                    editor.showCouldNotSaveDialog();
                    return;
                }
            } else if (save == 2) {
                return;
            }
        }
        editor.setClosed();
        window.dispose();
    }

    public static PolicyEditorWindow getPolicyEditorFrame(String filepath) {
        return new PolicyEditorFrame(new PolicyEditor(filepath));
    }

    public static PolicyEditorWindow getPolicyEditorDialog(String filepath) {
        return new PolicyEditorDialog(new PolicyEditor(filepath));
    }

    private void setClosed() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    void customPolicyViewerClosing() {
        this.cpViewer = null;
    }

    public void addNewEntry(final PolicyIdentifier identifier) {
        if (!PolicyEditor.validateCodebase(identifier.getCodebase())) {
            return;
        }
        this.policyEditorController.addIdentifier(identifier);
        SwingUtils.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                PolicyEditor.this.listModel.clear();
                for (PolicyIdentifier identifier2 : PolicyEditor.this.policyEditorController.getIdentifiers()) {
                    PolicyEditor.this.listModel.addElement(identifier2);
                }
                PolicyEditor.this.list.setSelectedValue(identifier, true);
                PolicyEditor.this.updateCheckboxes(identifier);
            }
        });
    }

    static PolicyIdentifier identifierFromCodebase(String codebase) {
        if (codebase.isEmpty() || codebase.equals(Translator.R("PEGlobalSettings"))) {
            return PolicyIdentifier.ALL_APPLETS_IDENTIFIER;
        }
        return new PolicyIdentifier(null, Collections.emptyList(), codebase);
    }

    private static boolean validateCodebase(String codebase) {
        if (codebase == null || codebase.isEmpty()) {
            return true;
        }
        try {
            new URL(codebase);
        }
        catch (MalformedURLException mue) {
            return false;
        }
        return true;
    }

    public File getFile() {
        return this.policyEditorController.getFile();
    }

    public void addNewIdentifierInteractive() {
        SwingUtils.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                PolicyIdentifier identifier = PolicyEditor.this.promptForPolicyIdentifier(PolicyIdentifier.ALL_APPLETS_IDENTIFIER);
                if (identifier == null) {
                    return;
                }
                PolicyEditor.this.addNewEntry(identifier);
            }
        });
    }

    private PolicyIdentifier promptForPolicyIdentifier(PolicyIdentifier initialValues) {
        PolicyIdentifier identifier = initialValues;
        JTextField codebase = new JTextField();
        JTextField signedBy = new JTextField();
        PrincipalsPanel principalsPanel = new PrincipalsPanel(Collections.emptySet());
        while (identifier.equals(initialValues) || identifier.equals(PolicyIdentifier.ALL_APPLETS_IDENTIFIER) || !PolicyEditor.validateCodebase(codebase.getText())) {
            codebase.setText(identifier.getCodebase());
            signedBy.setText(identifier.getSignedBy());
            int option = JOptionPane.showConfirmDialog(this, new Object[]{Translator.R("PECodebaseInputLabel"), codebase, Translator.R("PEPrincipalsInputLabel"), principalsPanel, Translator.R("PESignedByInputLabel"), signedBy}, Translator.R("PEEntryPrompt"), 2);
            if (option == 0) {
                String cb = codebase.getText().trim().isEmpty() ? null : codebase.getText().trim();
                String sb = signedBy.getText().trim().isEmpty() ? null : signedBy.getText().trim();
                identifier = new PolicyIdentifier(sb, principalsPanel.getPrincipals(), cb);
                if (identifier.equals(initialValues)) {
                    JOptionPane.showMessageDialog(null, Translator.R("PEInvalidIdentifier"));
                    continue;
                }
                if (!identifier.equals(PolicyIdentifier.ALL_APPLETS_IDENTIFIER)) continue;
                JOptionPane.showMessageDialog(null, Translator.R("PEIdentifierMatchesAll"));
                continue;
            }
            return null;
        }
        return identifier;
    }

    public void removeIdentifier(final PolicyIdentifier identifier) {
        if (identifier.equals(PolicyIdentifier.ALL_APPLETS_IDENTIFIER)) {
            return;
        }
        int previousIndex = this.list.getSelectedIndex() - 1;
        if (previousIndex < 0) {
            previousIndex = 0;
        }
        this.policyEditorController.removeIdentifier(identifier);
        final int fIndex = previousIndex;
        SwingUtils.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                PolicyEditor.this.listModel.removeElement(identifier);
                PolicyEditor.this.list.setSelectedIndex(fIndex);
            }
        });
        this.setChangesMade(true);
    }

    public void modifyCodebase(PolicyIdentifier identifier, String newCodebase) {
        PolicyIdentifier newIdentifier = new PolicyIdentifier(identifier.getSignedBy(), identifier.getPrincipals(), newCodebase);
        this.replaceIdentifier(identifier, newIdentifier);
    }

    public void modifyPrincipals(PolicyIdentifier identifier, List<PolicyParser.PrincipalEntry> principalEntries) {
        PolicyIdentifier newIdentifier = new PolicyIdentifier(identifier.getSignedBy(), principalEntries, identifier.getCodebase());
        this.replaceIdentifier(identifier, newIdentifier);
    }

    public void modifySignedBy(PolicyIdentifier identifier, String newSignedBy) {
        PolicyIdentifier newIdentifier = new PolicyIdentifier(newSignedBy, identifier.getPrincipals(), identifier.getCodebase());
        this.replaceIdentifier(identifier, newIdentifier);
    }

    private void replaceIdentifier(PolicyIdentifier oldIdentifier, PolicyIdentifier newIdentifier) {
        if (oldIdentifier.equals(PolicyIdentifier.ALL_APPLETS_IDENTIFIER) || newIdentifier.equals(PolicyIdentifier.ALL_APPLETS_IDENTIFIER)) {
            return;
        }
        Map<PolicyEditorPermissions, Boolean> permissions = this.getPermissions(oldIdentifier);
        Collection<PolicyParser.PermissionEntry> customPermissions = this.getCustomPermissions(oldIdentifier);
        this.removeIdentifier(oldIdentifier);
        this.addNewEntry(newIdentifier);
        for (Map.Entry<PolicyEditorPermissions, Boolean> entry : permissions.entrySet()) {
            this.setPermission(newIdentifier, entry.getKey(), entry.getValue());
        }
        for (PolicyParser.PermissionEntry permission : customPermissions) {
            this.addCustomPermission(newIdentifier, permission);
        }
        this.updateCheckboxes(newIdentifier);
    }

    public void copyEntry(PolicyIdentifier identifier) {
        if (!this.policyEditorController.getIdentifiers().contains(identifier)) {
            return;
        }
        this.policyEditorController.copyPolicyEntryToClipboard(identifier);
    }

    public void pasteEntry(PolicyIdentifier identifier) throws UnsupportedFlavorException, PolicyParser.ParsingException, IOException {
        this.addNewEntry(identifier);
        PolicyEntry policyEntry = PolicyEditorController.getPolicyEntryFromClipboard();
        PolicyEntry newEntry = new PolicyEntry.Builder().signedBy(identifier.getSignedBy()).principals(identifier.getPrincipals()).codebase(identifier.getCodebase()).permissions(policyEntry.getPermissions()).customPermissions(policyEntry.getCustomPermissions()).build();
        this.policyEditorController.addPolicyEntry(newEntry);
        this.setChangesMade(true);
        this.updateCheckboxes(identifier);
    }

    Set<String> getCodebases() {
        HashSet<String> codebases = new HashSet<String>();
        for (PolicyIdentifier identifier : this.policyEditorController.getIdentifiers()) {
            if (!PolicyEditor.isCodeBaseIdentifier(identifier)) continue;
            codebases.add(identifier.getCodebase());
        }
        return codebases;
    }

    static boolean isCodeBaseIdentifier(PolicyIdentifier identifier) {
        return !(identifier.getSignedBy() != null && !identifier.getSignedBy().isEmpty() || identifier.getPrincipals() != null && !identifier.getPrincipals().isEmpty() || identifier.getCodebase() == null);
    }

    public void setPermission(PolicyIdentifier identifier, PolicyEditorPermissions permission, boolean state) {
        this.policyEditorController.setPermission(identifier, permission, state);
    }

    public Map<PolicyEditorPermissions, Boolean> getPermissions(PolicyIdentifier identifier) {
        return this.policyEditorController.getPermissions(identifier);
    }

    public void addCustomPermission(PolicyIdentifier identifier, PolicyParser.PermissionEntry permission) {
        this.policyEditorController.addCustomPermission(identifier, permission);
    }

    public Collection<PolicyParser.PermissionEntry> getCustomPermissions(PolicyIdentifier identifier) {
        return this.policyEditorController.getCustomPermissions(identifier);
    }

    public void clearCustomPermissions(PolicyIdentifier identifier) {
        this.policyEditorController.clearCustomIdentifier(identifier);
    }

    private void updateCheckboxes(final PolicyIdentifier identifier) {
        SwingUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                PolicyEditor.this.updateCheckboxesImpl(identifier);
            }
        });
    }

    private void updateCheckboxesImpl(final PolicyIdentifier identifier) {
        if (!this.listModel.contains(identifier)) {
            return;
        }
        final Map<PolicyEditorPermissions, Boolean> map = this.policyEditorController.getCopyOfPermissions().get(identifier);
        for (final PolicyEditorPermissions perm : PolicyEditorPermissions.values()) {
            final JCheckBox box = this.checkboxMap.get(perm);
            for (ActionListener l : box.getActionListeners()) {
                box.removeActionListener(l);
            }
            boolean state = this.policyEditorController.getPermission(identifier, perm);
            for (JCheckBoxWithGroup jg : this.groupBoxList) {
                jg.setState(map);
            }
            box.setSelected(state);
            box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PolicyEditor.this.setChangesMade(true);
                    PolicyEditor.this.policyEditorController.setPermission(identifier, perm, box.isSelected());
                    for (JCheckBoxWithGroup jg : PolicyEditor.this.groupBoxList) {
                        jg.setState(map);
                    }
                }
            });
        }
    }

    private static void setButtonMnemonic(AbstractButton button, String mnemonic) {
        if (mnemonic.length() != 1) {
            OutputController.getLogger().log(OutputController.Level.WARNING_DEBUG, "Could not set mnemonic \"" + mnemonic + "\" for " + button);
            return;
        }
        char ch = mnemonic.charAt(0);
        button.setMnemonic(ch);
    }

    private static void setMenuItemAccelerator(JMenuItem menuItem, String accelerator) {
        KeyStroke ks = KeyStroke.getKeyStroke(accelerator);
        menuItem.setAccelerator(ks);
    }

    private static JMenuBar createMenuBar(final PolicyEditor editor) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Translator.R("PEFileMenu"));
        PolicyEditor.setButtonMnemonic(fileMenu, Translator.R("PEFileMenuMnemonic"));
        JMenuItem newItem = new JMenuItem(Translator.R("PENewMenuItem"));
        PolicyEditor.setButtonMnemonic(newItem, Translator.R("PENewMenuItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(newItem, Translator.R("PENewMenuItemAccelerator"));
        newItem.addActionListener(editor.newButtonAction);
        fileMenu.add(newItem);
        JMenuItem openItem = new JMenuItem(Translator.R("PEOpenMenuItem"));
        PolicyEditor.setButtonMnemonic(openItem, Translator.R("PEOpenMenuItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(openItem, Translator.R("PEOpenMenuItemAccelerator"));
        openItem.addActionListener(editor.openButtonAction);
        fileMenu.add(openItem);
        JMenuItem openDefaultItem = new JMenuItem(Translator.R("PEOpenDefaultMenuItem"));
        PolicyEditor.setButtonMnemonic(openDefaultItem, Translator.R("PEOpenDefaultMenuItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(openDefaultItem, Translator.R("PEOpenDefaultMenuItemAccelerator"));
        openDefaultItem.addActionListener(editor.openDefaultButtonAction);
        fileMenu.add(openDefaultItem);
        JMenuItem saveItem = new JMenuItem(Translator.R("PESaveMenuItem"));
        PolicyEditor.setButtonMnemonic(saveItem, Translator.R("PESaveMenuItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(saveItem, Translator.R("PESaveMenuItemAccelerator"));
        saveItem.addActionListener(editor.okButtonAction);
        fileMenu.add(saveItem);
        JMenuItem saveAsItem = new JMenuItem(Translator.R("PESaveAsMenuItem"));
        PolicyEditor.setButtonMnemonic(saveAsItem, Translator.R("PESaveAsMenuItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(saveAsItem, Translator.R("PESaveAsMenuItemAccelerator"));
        saveAsItem.addActionListener(editor.saveAsButtonAction);
        fileMenu.add(saveAsItem);
        fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem(Translator.R("PEExitMenuItem"));
        PolicyEditor.setButtonMnemonic(exitItem, Translator.R("PEExitMenuItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(exitItem, Translator.R("PEExitMenuItemAccelerator"));
        exitItem.addActionListener(editor.closeButtonAction);
        fileMenu.add(exitItem);
        menuBar.add(fileMenu);
        JMenu entryMenu = new JMenu(Translator.R("PEEntryMenu"));
        PolicyEditor.setButtonMnemonic(entryMenu, Translator.R("PEEntryMenuMnemonic"));
        JMenuItem addEntryItem = new JMenuItem(Translator.R("PEAddEntryItem"));
        PolicyEditor.setButtonMnemonic(addEntryItem, Translator.R("PEAddEntryItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(addEntryItem, Translator.R("PEAddEntryItemAccelerator"));
        addEntryItem.addActionListener(editor.addEntryButtonAction);
        entryMenu.add(addEntryItem);
        JMenuItem removeEntryItem = new JMenuItem(Translator.R("PERemoveEntryItem"));
        PolicyEditor.setButtonMnemonic(removeEntryItem, Translator.R("PERemoveEntryItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(removeEntryItem, Translator.R("PERemoveEntryItemAccelerator"));
        removeEntryItem.addActionListener(editor.removeEntryButtonAction);
        entryMenu.add(removeEntryItem);
        entryMenu.addSeparator();
        JMenu modifySubmenuItem = new JMenu(Translator.R("PEModifySubmenuItem"));
        PolicyEditor.setButtonMnemonic(modifySubmenuItem, Translator.R("PEModifySubmenuItemMnemonic"));
        JMenuItem modifyCodebaseItem = new JMenuItem(Translator.R("PEModifyCodebaseItem"));
        PolicyEditor.setButtonMnemonic(modifyCodebaseItem, Translator.R("PEModifyEntryCodebaseItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(modifyCodebaseItem, Translator.R("PEModifyEntryCodebaseItemAccelerator"));
        modifyCodebaseItem.addActionListener(editor.modifyCodebaseButtonAction);
        modifySubmenuItem.add(modifyCodebaseItem);
        JMenuItem modifyPrincipalsItem = new JMenuItem(Translator.R("PEModifyPrincipalsItem"));
        PolicyEditor.setButtonMnemonic(modifyPrincipalsItem, Translator.R("PEModifyEntryPrincipalsItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(modifyPrincipalsItem, Translator.R("PEModifyEntryPrincipalsItemAccelerator"));
        modifyPrincipalsItem.addActionListener(editor.modifyPrincipalsButtonAction);
        modifySubmenuItem.add(modifyPrincipalsItem);
        JMenuItem modifySignedByItem = new JMenuItem(Translator.R("PEModifySignedByItem"));
        PolicyEditor.setButtonMnemonic(modifySignedByItem, Translator.R("PEModifyEntrySignedByItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(modifySignedByItem, Translator.R("PEModifyEntrySignedByItemAccelerator"));
        modifySignedByItem.addActionListener(editor.modifySignedByButtonAction);
        modifySubmenuItem.add(modifySignedByItem);
        entryMenu.add(modifySubmenuItem);
        entryMenu.addSeparator();
        JMenuItem copyEntryItem = new JMenuItem(Translator.R("PECopyEntryItem"));
        PolicyEditor.setButtonMnemonic(copyEntryItem, Translator.R("PECopyEntryItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(copyEntryItem, Translator.R("PECopyEntryItemAccelerator"));
        copyEntryItem.addActionListener(editor.copyEntryButtonAction);
        entryMenu.add(copyEntryItem);
        menuBar.add(entryMenu);
        JMenuItem pasteEntryItem = new JMenuItem(Translator.R("PEPasteEntryItem"));
        PolicyEditor.setButtonMnemonic(pasteEntryItem, Translator.R("PEPasteEntryItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(pasteEntryItem, Translator.R("PEPasteEntryItemAccelerator"));
        pasteEntryItem.addActionListener(editor.pasteEntryButtonAction);
        entryMenu.add(pasteEntryItem);
        JMenu viewMenu = new JMenu(Translator.R("PEViewMenu"));
        PolicyEditor.setButtonMnemonic(viewMenu, Translator.R("PEViewMenuMnemonic"));
        JMenuItem customPermissionsItem = new JMenuItem(Translator.R("PECustomPermissionsItem"));
        PolicyEditor.setButtonMnemonic(customPermissionsItem, Translator.R("PECustomPermissionsItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(customPermissionsItem, Translator.R("PECustomPermissionsItemAccelerator"));
        customPermissionsItem.addActionListener(editor.viewCustomButtonAction);
        viewMenu.add(customPermissionsItem);
        menuBar.add(viewMenu);
        JMenu helpMenu = new JMenu(Translator.R("PEHelpMenu"));
        PolicyEditor.setButtonMnemonic(helpMenu, Translator.R("PEHelpMenuMnemonic"));
        JMenuItem aboutPolicyEditorItem = new JMenuItem(Translator.R("PEAboutPolicyEditorItem"));
        PolicyEditor.setButtonMnemonic(aboutPolicyEditorItem, Translator.R("PEAboutPolicyEditorItemMnemonic"));
        aboutPolicyEditorItem.addActionListener(editor.aboutPolicyEditorButtonAction);
        helpMenu.add(aboutPolicyEditorItem);
        JMenuItem aboutITW = new JMenuItem(Translator.R("CPTabAbout"));
        aboutITW.addActionListener(editor.aboutItwButtonAction);
        helpMenu.add(aboutITW);
        JMenuItem policyEditorHelpItem = new JMenuItem(Translator.R("PEPolicyEditorHelpItem"));
        PolicyEditor.setButtonMnemonic(policyEditorHelpItem, Translator.R("PEPolicyEditorHelpItemMnemonic"));
        policyEditorHelpItem.addActionListener(editor.policyEditorHelpButtonAction);
        helpMenu.addSeparator();
        helpMenu.add(policyEditorHelpItem);
        menuBar.add(helpMenu);
        InputMap listInputMap = editor.list.getInputMap();
        ActionMap listActionMap = editor.list.getActionMap();
        AbstractAction listCopyOverrideAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                editor.copyEntryButtonAction.actionPerformed(e);
            }
        };
        AbstractAction listPasteOverrideAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                editor.pasteEntryButtonAction.actionPerformed(e);
            }
        };
        listInputMap.put(copyEntryItem.getAccelerator(), "CopyEntryOverride");
        listActionMap.put("CopyEntryOverride", listCopyOverrideAction);
        listInputMap.put(pasteEntryItem.getAccelerator(), "PasteEntryOverride");
        listActionMap.put("PasteEntryOverride", listPasteOverrideAction);
        return menuBar;
    }

    private void setupLayout() {
        JLabel checkboxLabel = new JLabel();
        checkboxLabel.setText(Translator.R("PECheckboxLabel"));
        checkboxLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagConstraints checkboxLabelConstraints = new GridBagConstraints();
        checkboxLabelConstraints.gridx = 2;
        checkboxLabelConstraints.gridy = 0;
        checkboxLabelConstraints.fill = 2;
        this.add((Component)checkboxLabel, checkboxLabelConstraints);
        GridBagConstraints checkboxConstraints = new GridBagConstraints();
        checkboxConstraints.anchor = 21;
        checkboxConstraints.fill = 2;
        checkboxConstraints.weightx = 0.0;
        checkboxConstraints.weighty = 0.0;
        checkboxConstraints.gridx = 2;
        checkboxConstraints.gridy = 1;
        for (JCheckBox box : this.checkboxMap.values()) {
            if (PolicyEditorPermissions.Group.anyContains(box, this.checkboxMap)) continue;
            this.add((Component)box, checkboxConstraints);
            ++checkboxConstraints.gridx;
            if (checkboxConstraints.gridx <= 3) continue;
            checkboxConstraints.gridx = 2;
            ++checkboxConstraints.gridy;
        }
        for (PolicyEditorPermissions.Group g : PolicyEditorPermissions.Group.values()) {
            ++checkboxConstraints.gridy;
            checkboxConstraints.gridx = 2;
            final JCheckBoxWithGroup groupCh = new JCheckBoxWithGroup(g);
            this.groupBoxList.add(groupCh);
            final JPanel groupPanel = new JPanel(new GridBagLayout());
            groupPanel.setBorder(new LineBorder(Color.black));
            groupCh.setToolTipText(Translator.R("PEGRightClick"));
            groupCh.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3) {
                        PolicyEditor.this.toggleExpandedCheckboxGroupPanel(groupPanel);
                    }
                }
            });
            groupCh.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 525) {
                        PolicyEditor.this.toggleExpandedCheckboxGroupPanel(groupPanel);
                    }
                }
            });
            groupCh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PolicyIdentifier identifier = PolicyEditor.this.getSelectedPolicyIdentifier();
                    if (identifier == null) {
                        return;
                    }
                    LinkedList<ActionListener> backup = new LinkedList<ActionListener>();
                    for (ActionListener l : groupCh.getActionListeners()) {
                        backup.add(l);
                        groupCh.removeActionListener(l);
                    }
                    for (PolicyEditorPermissions p : groupCh.getGroup().getPermissions()) {
                        PolicyEditor.this.policyEditorController.setPermission(identifier, p, groupCh.isSelected());
                    }
                    PolicyEditor.this.setChangesMade(true);
                    PolicyEditor.this.updateCheckboxes(identifier);
                    for (ActionListener al : backup) {
                        groupCh.addActionListener(al);
                    }
                }
            });
            this.add((Component)groupCh, checkboxConstraints);
            ++checkboxConstraints.gridy;
            checkboxConstraints.gridx = 2;
            checkboxConstraints.gridwidth = 2;
            checkboxConstraints.fill = 1;
            this.add((Component)groupPanel, checkboxConstraints);
            GridBagConstraints groupCheckboxLabelConstraints = new GridBagConstraints();
            groupCheckboxLabelConstraints.anchor = 21;
            groupCheckboxLabelConstraints.weightx = 0.0;
            groupCheckboxLabelConstraints.weighty = 0.0;
            groupCheckboxLabelConstraints.gridx = 1;
            groupCheckboxLabelConstraints.gridy = 1;
            for (PolicyEditorPermissions p : g.getPermissions()) {
                groupPanel.add((Component)this.checkboxMap.get(p), groupCheckboxLabelConstraints);
                ++groupCheckboxLabelConstraints.gridx;
                if (groupCheckboxLabelConstraints.gridx <= 2) continue;
                groupCheckboxLabelConstraints.gridx = 1;
                ++groupCheckboxLabelConstraints.gridy;
            }
            groupPanel.setVisible(false);
            checkboxConstraints.gridwidth = 1;
        }
        JLabel entriesListLabel = new JLabel(Translator.R("PEEntriesLabel"));
        entriesListLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagConstraints listLabelConstraints = new GridBagConstraints();
        listLabelConstraints.fill = 2;
        listLabelConstraints.gridx = 0;
        listLabelConstraints.gridy = 0;
        this.add((Component)entriesListLabel, listLabelConstraints);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                PolicyEditor.this.updateCheckboxes(PolicyEditor.this.getSelectedPolicyIdentifier());
            }
        });
        this.list.setSelectionMode(0);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setViewportView(this.list);
        GridBagConstraints listConstraints = new GridBagConstraints();
        listConstraints.fill = 1;
        listConstraints.weightx = 1.0;
        listConstraints.weighty = 1.0;
        listConstraints.gridheight = checkboxConstraints.gridy + 1;
        listConstraints.gridwidth = 2;
        listConstraints.gridx = 0;
        listConstraints.gridy = 1;
        this.add((Component)this.scrollPane, listConstraints);
        GridBagConstraints addEntryButtonConstraints = new GridBagConstraints();
        addEntryButtonConstraints.fill = 2;
        addEntryButtonConstraints.gridx = 0;
        addEntryButtonConstraints.gridy = listConstraints.gridy + listConstraints.gridheight + 1;
        PolicyEditor.setButtonMnemonic(this.addEntryButton, Translator.R("PEAddEntryMnemonic"));
        this.add((Component)this.addEntryButton, addEntryButtonConstraints);
        GridBagConstraints removeEntryButtonConstraints = new GridBagConstraints();
        removeEntryButtonConstraints.fill = 2;
        removeEntryButtonConstraints.gridx = addEntryButtonConstraints.gridx + 1;
        removeEntryButtonConstraints.gridy = addEntryButtonConstraints.gridy;
        PolicyEditor.setButtonMnemonic(this.removeEntryButton, Translator.R("PERemoveEntryMnemonic"));
        this.removeEntryButton.setPreferredSize(this.addEntryButton.getPreferredSize());
        this.add((Component)this.removeEntryButton, removeEntryButtonConstraints);
        GridBagConstraints okButtonConstraints = new GridBagConstraints();
        okButtonConstraints.fill = 2;
        okButtonConstraints.gridx = removeEntryButtonConstraints.gridx + 2;
        okButtonConstraints.gridy = removeEntryButtonConstraints.gridy;
        this.add((Component)this.okButton, okButtonConstraints);
        GridBagConstraints cancelButtonConstraints = new GridBagConstraints();
        cancelButtonConstraints.fill = 2;
        cancelButtonConstraints.gridx = okButtonConstraints.gridx + 1;
        cancelButtonConstraints.gridy = okButtonConstraints.gridy;
        this.add((Component)this.closeButton, cancelButtonConstraints);
        this.setMinimumSize(this.getPreferredSize());
    }

    void setChangesMade(boolean b) {
        this.policyEditorController.setChangesMade(b);
        SwingUtils.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                PolicyEditor.this.setParentWindowTitle(PolicyEditor.this.getWindowTitleForStatus());
            }
        });
    }

    private void resetEntries() {
        this.listModel.clear();
        this.policyEditorController.clear();
    }

    public boolean isPerformingIO() {
        return this.policyEditorController.isPerformingIO();
    }

    public void openPolicyFileSynchronously() {
        if (this.getFile() == null) {
            return;
        }
        this.resetEntries();
        FileUtils.OpenFileResult ofr = FileUtils.testFilePermissions(this.getFile());
        if (ofr == FileUtils.OpenFileResult.FAILURE || ofr == FileUtils.OpenFileResult.NOT_FILE) {
            this.addDefaultAllAppletsIdentifier();
            OutputController.getLogger().log(Translator.R("PECouldNotOpen"));
        }
        if (ofr == FileUtils.OpenFileResult.CANT_WRITE) {
            OutputController.getLogger().log(Translator.R("RFileReadOnly"));
        }
        try {
            this.policyEditorController.openAndParsePolicyFile();
        }
        catch (IOException | PolicyParser.ParsingException e) {
            OutputController.getLogger().log(e);
            return;
        }
        for (PolicyIdentifier identifier : this.policyEditorController.getIdentifiers()) {
            if (this.listModel.contains(identifier)) continue;
            this.listModel.addElement(identifier);
        }
        this.addDefaultAllAppletsIdentifier();
        this.updateCheckboxes(PolicyIdentifier.ALL_APPLETS_IDENTIFIER);
        this.setChangesMade(false);
    }

    public void openAndParsePolicyFile() {
        if (this.getFile() == null) {
            return;
        }
        this.resetEntries();
        FileUtils.OpenFileResult ofr = FileUtils.testFilePermissions(this.getFile());
        if (ofr == FileUtils.OpenFileResult.FAILURE || ofr == FileUtils.OpenFileResult.NOT_FILE) {
            this.addDefaultAllAppletsIdentifier();
            if (this.policyEditorController.getFile().exists()) {
                FileUtils.showCouldNotOpenFilepathDialog(this, this.policyEditorController.getFile().getPath());
            }
            return;
        }
        if (ofr == FileUtils.OpenFileResult.CANT_WRITE) {
            FileUtils.showReadOnlyDialog(this);
        }
        final Window parentWindow = SwingUtils.getWindowAncestor(this);
        final IndeterminateProgressDialog progressIndicator = new IndeterminateProgressDialog(parentWindow, "Loading...");
        SwingWorker<Void, Void> openPolicyFileWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    if (parentWindow != null) {
                        SwingUtils.invokeRunnableOrEnqueueLater(new Runnable(){

                            @Override
                            public void run() {
                                progressIndicator.setLocationRelativeTo(parentWindow);
                                progressIndicator.setVisible(true);
                            }
                        });
                    }
                    PolicyEditor.this.policyEditorController.openAndParsePolicyFile();
                }
                catch (FileNotFoundException fnfe) {
                    OutputController.getLogger().log(fnfe);
                    FileUtils.showCouldNotOpenDialog(PolicyEditor.this, Translator.R("PECouldNotOpen"));
                }
                catch (IOException | PolicyParser.ParsingException e) {
                    OutputController.getLogger().log(e);
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RCantOpenFile", PolicyEditor.this.policyEditorController.getFile().getPath()));
                    FileUtils.showCouldNotOpenDialog(PolicyEditor.this, Translator.R("PECouldNotOpen"));
                }
                return null;
            }

            @Override
            public void done() {
                for (PolicyIdentifier identifier : PolicyEditor.this.policyEditorController.getIdentifiers()) {
                    if (PolicyEditor.this.listModel.contains(identifier)) continue;
                    PolicyEditor.this.listModel.addElement(identifier);
                }
                PolicyEditor.this.addDefaultAllAppletsIdentifier();
                PolicyEditor.this.updateCheckboxes(PolicyIdentifier.ALL_APPLETS_IDENTIFIER);
                progressIndicator.setVisible(false);
                progressIndicator.dispose();
                PolicyEditor.this.setChangesMade(false);
            }
        };
        openPolicyFileWorker.execute();
    }

    private void savePolicyFile() {
        int overwriteChanges = this.checkPolicyChangesWithDialog();
        switch (overwriteChanges) {
            case 0: {
                this.openAndParsePolicyFile();
                return;
            }
            case 1: {
                break;
            }
            case 2: {
                return;
            }
        }
        final Window parentWindow = SwingUtils.getWindowAncestor(this);
        final IndeterminateProgressDialog progressIndicator = new IndeterminateProgressDialog(parentWindow, "Saving...");
        SwingWorker<Void, Void> savePolicyFileWorker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() throws Exception {
                try {
                    if (parentWindow != null) {
                        SwingUtils.invokeRunnableOrEnqueueLater(new Runnable(){

                            @Override
                            public void run() {
                                progressIndicator.setLocationRelativeTo(parentWindow);
                                progressIndicator.setVisible(true);
                            }
                        });
                    }
                    PolicyEditor.this.policyEditorController.savePolicyFile();
                }
                catch (IOException e) {
                    OutputController.getLogger().log(e);
                    PolicyEditor.this.showCouldNotSaveDialog();
                }
                return null;
            }

            @Override
            public void done() {
                PolicyEditor.this.showChangesSavedDialog();
                progressIndicator.setVisible(false);
                progressIndicator.dispose();
                PolicyEditor.this.setChangesMade(false);
            }
        };
        savePolicyFileWorker.execute();
    }

    private void showChangesSavedDialog() {
        SwingUtils.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)PolicyEditor.this.parentPolicyEditor.get(), Translator.R("PEChangesSaved"));
            }
        });
    }

    private void showCouldNotSaveDialog() {
        SwingUtils.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)PolicyEditor.this.parentPolicyEditor.get(), Translator.R("PECouldNotSave"), Translator.R("Error"), 0);
            }
        });
    }

    private void showClipboardErrorDialog() {
        SwingUtils.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)PolicyEditor.this.parentPolicyEditor.get(), Translator.R("PEClipboardError"), Translator.R("Error"), 0);
            }
        });
    }

    private void showInvalidPolicyExceptionDialog(final PolicyIdentifier identifier) {
        SwingUtils.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)PolicyEditor.this.parentPolicyEditor.get(), Translator.R("PEInvalidPolicy", identifier.toString()), Translator.R("Error"), 0);
            }
        });
    }

    private void showCouldNotAccessClipboardDialog() {
        SwingUtils.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)PolicyEditor.this.parentPolicyEditor.get(), Translator.R("PEClipboardAccessError"), Translator.R("Error"), 0);
            }
        });
    }

    private int checkPolicyChangesWithDialog() {
        boolean changed;
        try {
            changed = this.policyEditorController.fileHasChanged();
        }
        catch (FileNotFoundException e) {
            OutputController.getLogger().log(e);
            JOptionPane.showMessageDialog(this, Translator.R("PEFileMissing"), Translator.R("PEFileModified"), 2);
            return 1;
        }
        catch (IOException e) {
            OutputController.getLogger().log(e);
            changed = true;
        }
        if (changed) {
            String policyFilePath;
            try {
                policyFilePath = this.policyEditorController.getFile().getCanonicalPath();
            }
            catch (IOException e) {
                OutputController.getLogger().log(e);
                policyFilePath = this.policyEditorController.getFile().getPath();
            }
            return JOptionPane.showConfirmDialog(this, Translator.R("PEFileModifiedDetail", policyFilePath, Translator.R("PEFileModified"), 1));
        }
        if (!this.policyEditorController.changesMade()) {
            return 2;
        }
        return 1;
    }

    private void toggleExpandedCheckboxGroupPanel(JPanel groupPanel) {
        groupPanel.setVisible(!groupPanel.isVisible());
        this.validate();
        Window w = SwingUtils.getWindowAncestor(this);
        if (w != null) {
            w.pack();
        }
    }

    public static void main(String[] args) {
        SwingUtils.setup();
        OptionParser optionParser = new OptionParser(args, OptionsDefinitions.getPolicyEditorOptions());
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.VERBOSE)) {
            JNLPRuntime.setDebug(true);
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.HELP1)) {
            PolicyEditorTextsProvider helpMessagesProvider = new PolicyEditorTextsProvider("utf-8", new PlainTextFormatter(), true, true);
            String HELP_MESSAGE = "\n";
            HELP_MESSAGE = JNLPRuntime.isDebug() ? HELP_MESSAGE + helpMessagesProvider.writeToString() : HELP_MESSAGE + helpMessagesProvider.prepare().getSynopsis() + helpMessagesProvider.getFormatter().getNewLine() + helpMessagesProvider.prepare().getOptions() + helpMessagesProvider.getFormatter().getNewLine();
            OutputController.getLogger().printOut(HELP_MESSAGE);
            return;
        }
        SwingHelpers.enableDefaultLaF();
        final String filepath = PolicyEditor.getFilePathArgument(optionParser);
        final String codebase = PolicyEditor.getCodebaseArgument(optionParser);
        final String signedBy = PolicyEditor.getSignedByArgument(optionParser);
        final Set<PolicyParser.PrincipalEntry> principals = PolicyEditor.getPrincipalsArgument(optionParser);
        SwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                PolicyEditorWindow frame = PolicyEditor.getPolicyEditorFrame(filepath);
                frame.getPolicyEditor().openPolicyFileSynchronously();
                frame.getPolicyEditor().addNewEntry(new PolicyIdentifier(signedBy, principals, codebase));
                frame.asWindow().setVisible(true);
            }
        });
    }

    static String getCodebaseArgument(OptionParser optionParser) {
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.CODEBASE)) {
            String codebase = optionParser.getParam(OptionsDefinitions.OPTIONS.CODEBASE);
            try {
                new URL(codebase);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(Translator.R("PEInvalidUrl", codebase), e);
            }
            return codebase;
        }
        return null;
    }

    static String getSignedByArgument(OptionParser optionParser) {
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.SIGNEDBY)) {
            String signedBy = optionParser.getParam(OptionsDefinitions.OPTIONS.SIGNEDBY);
            if (signedBy.isEmpty()) {
                throw new IllegalArgumentException(Translator.R("PESignedByEmpty"));
            }
            return signedBy;
        }
        return null;
    }

    static Set<PolicyParser.PrincipalEntry> getPrincipalsArgument(OptionParser optionParser) {
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.PRINCIPALS)) {
            List<String> rawPrincipals = optionParser.getParams(OptionsDefinitions.OPTIONS.PRINCIPALS);
            HashSet<PolicyParser.PrincipalEntry> principals = new HashSet<PolicyParser.PrincipalEntry>();
            for (int i = 0; i < rawPrincipals.size(); i += 2) {
                principals.add(new PolicyParser.PrincipalEntry(rawPrincipals.get(i), rawPrincipals.get(i + 1)));
            }
            return principals;
        }
        return Collections.emptySet();
    }

    static String getFilePathArgument(OptionParser optionParser) {
        boolean openDefaultFile = optionParser.hasOption(OptionsDefinitions.OPTIONS.DEFAULTFILE);
        boolean hasFileArgument = optionParser.hasOption(OptionsDefinitions.OPTIONS.FILE);
        boolean hasMainArgument = optionParser.mainArgExists();
        if (hasFileArgument && openDefaultFile || hasMainArgument && openDefaultFile) {
            throw new IllegalArgumentException(Translator.R("PEDefaultFileFilePathSpecifiedError"));
        }
        if (hasFileArgument && hasMainArgument) {
            throw new IllegalArgumentException(Translator.R("PEMainArgAndFileSwitchSpecifiedError"));
        }
        String filepath = null;
        if (hasFileArgument) {
            filepath = PolicyEditor.cleanFilePathArgument(optionParser.getParam(OptionsDefinitions.OPTIONS.FILE));
        } else if (hasMainArgument) {
            filepath = PolicyEditor.cleanFilePathArgument(optionParser.getMainArg());
        } else if (openDefaultFile) {
            try {
                filepath = PolicyEditor.getDefaultPolicyFilePath();
            }
            catch (URISyntaxException e) {
                OutputController.getLogger().log(e);
                throw new RuntimeException(e);
            }
        }
        return filepath;
    }

    private static String cleanFilePathArgument(String filepath) {
        if (filepath == null) {
            return null;
        }
        if (filepath.isEmpty() || filepath.trim().isEmpty()) {
            return null;
        }
        return filepath;
    }

    public static PolicyEditor createInstance(String filepath) {
        return new PolicyEditor(filepath);
    }

    private static class PolicyEditorDialog
    extends JDialog
    implements PolicyEditorWindow {
        private PolicyEditor editor;

        private PolicyEditorDialog(PolicyEditor editor) {
            PolicyEditor.preparePolicyEditorWindow(this, editor);
        }

        @Override
        public final void setTitle(String title) {
            super.setTitle(title);
        }

        @Override
        public final PolicyEditor getPolicyEditor() {
            return this.editor;
        }

        @Override
        public final void setPolicyEditor(PolicyEditor e) {
            this.editor = e;
        }

        @Override
        public final void setDefaultCloseOperation(int operation) {
            super.setDefaultCloseOperation(operation);
        }

        @Override
        public final void setJMenuBar(JMenuBar menu) {
            super.setJMenuBar(menu);
        }

        @Override
        public final Window asWindow() {
            return this;
        }

        @Override
        public void setModalityType(Dialog.ModalityType type) {
            super.setModalityType(type);
        }

        @Override
        public void quit() {
            PolicyEditor.policyEditorWindowQuit(this);
        }
    }

    private static class PolicyEditorFrame
    extends JFrame
    implements PolicyEditorWindow {
        private PolicyEditor editor;

        private PolicyEditorFrame(PolicyEditor editor) {
            this.setIconImages(ImageResources.INSTANCE.getApplicationImages());
            PolicyEditor.preparePolicyEditorWindow(this, editor);
        }

        @Override
        public final void setTitle(String title) {
            super.setTitle(title);
        }

        @Override
        public final PolicyEditor getPolicyEditor() {
            return this.editor;
        }

        @Override
        public final void setPolicyEditor(PolicyEditor e) {
            this.editor = e;
        }

        @Override
        public final void setDefaultCloseOperation(int operation) {
            super.setDefaultCloseOperation(operation);
        }

        @Override
        public final void setJMenuBar(JMenuBar menu) {
            super.setJMenuBar(menu);
        }

        @Override
        public final Window asWindow() {
            return this;
        }

        @Override
        public void setModalityType(Dialog.ModalityType type) {
        }

        @Override
        public void quit() {
            PolicyEditor.policyEditorWindowQuit(this);
        }
    }

    public static interface PolicyEditorWindow {
        public void setTitle(String var1);

        public void setDefaultCloseOperation(int var1);

        public PolicyEditor getPolicyEditor();

        public void setPolicyEditor(PolicyEditor var1);

        public void setJMenuBar(JMenuBar var1);

        public Window asWindow();

        public void setModalityType(Dialog.ModalityType var1);

        public void quit();
    }

    private static class PrincipalsPanel
    extends JPanel {
        private final DefaultListModel<PolicyParser.PrincipalEntry> principals = new DefaultListModel();

        public PrincipalsPanel(Collection<PolicyParser.PrincipalEntry> entries) {
            this.setLayout(new BoxLayout(this, 3));
            for (PolicyParser.PrincipalEntry principalEntry : entries) {
                this.principals.addElement(principalEntry);
            }
            final JList<PolicyParser.PrincipalEntry> principalsList = new JList<PolicyParser.PrincipalEntry>(this.principals);
            JScrollPane scrollPane = new JScrollPane(principalsList);
            JButton addButton = new JButton(Translator.R("PEAddPrincipal"));
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTextField className = new JTextField();
                    JTextField principalName = new JTextField();
                    int option = JOptionPane.showConfirmDialog(null, new Object[]{Translator.R("PEPrincipalClassNameInputLabel"), className, Translator.R("PEPrincipalPrincipalNameInputLabel"), principalName}, Translator.R("PEAddPrincipal"), 2);
                    if (option == 0) {
                        PolicyParser.PrincipalEntry entry = new PolicyParser.PrincipalEntry(className.getText(), principalName.getText());
                        principals.addElement(entry);
                    }
                }
            });
            JButton removeButton = new JButton(Translator.R("PERemovePrincipal"));
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    principals.removeElement(principalsList.getSelectedValue());
                }
            });
            JButton editButton = new JButton(Translator.R("PEEditPrincipal"));
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PolicyParser.PrincipalEntry entry = (PolicyParser.PrincipalEntry)principalsList.getSelectedValue();
                    if (entry == null) {
                        return;
                    }
                    JTextField className = new JTextField();
                    JTextField principalName = new JTextField();
                    className.setText(entry.getDisplayClass());
                    principalName.setText(entry.getDisplayName());
                    int option = JOptionPane.showConfirmDialog(null, new Object[]{Translator.R("PEPrincipalClassNameInputLabel"), className, Translator.R("PEPrincipalPrincipalNameInputLabel"), principalName}, Translator.R("PEEditPrincipal"), 2);
                    if (option == 0) {
                        principals.removeElement(entry);
                        PolicyParser.PrincipalEntry newEntry = new PolicyParser.PrincipalEntry(className.getText(), principalName.getText());
                        principals.addElement(newEntry);
                    }
                }
            });
            this.add(scrollPane);
            this.add(addButton);
            this.add(editButton);
            this.add(removeButton);
        }

        public List<PolicyParser.PrincipalEntry> getPrincipals() {
            ArrayList<PolicyParser.PrincipalEntry> entries = new ArrayList<PolicyParser.PrincipalEntry>(this.principals.size());
            for (PolicyParser.PrincipalEntry entry : Collections.list(this.principals.elements())) {
                entries.add(entry);
            }
            return entries;
        }
    }

    private static class JCheckBoxWithGroup
    extends JCheckBox {
        private final PolicyEditorPermissions.Group group;

        private JCheckBoxWithGroup(PolicyEditorPermissions.Group group) {
            super(group.getTitle());
            this.group = group;
        }

        public PolicyEditorPermissions.Group getGroup() {
            return this.group;
        }

        private void setState(Map<PolicyEditorPermissions, Boolean> map) {
            LinkedList<ActionListener> backup = new LinkedList<ActionListener>();
            for (ActionListener l : this.getActionListeners()) {
                backup.add(l);
                this.removeActionListener(l);
            }
            int i = this.group.getState(map);
            this.setBackground(this.getParent().getBackground());
            if (i > 0) {
                this.setSelected(true);
            }
            if (i < 0) {
                this.setSelected(false);
            }
            if (i == 0) {
                this.setBackground(Color.yellow);
                this.setSelected(false);
            }
            for (ActionListener al : backup) {
                this.addActionListener(al);
            }
        }
    }
}

