/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDStoreDetailRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDStoreDetailService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDStoreDetailItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDStoreDetailController
extends BaseController
implements PosIDStoreDetailRemote {
    @Autowired
    private PosIDStoreDetailService posIDStoreDetailService;

    @RequiresPermissions(value={"posid:storeDetail"})
    public ModelAndView index() {
        return new ModelAndView("posid/storeDetail/posIDStoreDetail");
    }

    @RequiresPermissions(value={"posid:storeDetail:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PosIDStoreDetailItem item = this.posIDStoreDetailService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("posid/storeDetail/editPosIDStoreDetail");
    }

    @RequiresPermissions(value={"posid:storeDetail:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_storeDetail", opType="common_op_edit", requestParams={"name"}, opContent="posid_storeDetail_name")
    public ZKResultMsg save(PosIDStoreDetailItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posIDStoreDetailService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:storeDetail:refresh"})
    public DxGrid list(PosIDStoreDetailItem codition) {
        Pager pager = this.posIDStoreDetailService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:storeDetail:del"})
    @LogRequest(module="posid_module", object="posid_leftMenu_storeDetail", opType="common_op_del", requestParams={"names"}, opContent="posid_storeDetail_name")
    public ZKResultMsg delete(String ids) {
        this.posIDStoreDetailService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validCode(String code) {
        PosIDStoreDetailItem item = this.posIDStoreDetailService.getItemByCode(code);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg photoUpload(MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
        ZKResultMsg zm = new ZKResultMsg();
        String fileName = System.currentTimeMillis() + "_" + new Random().nextInt(1000);
        if (file.getOriginalFilename().toLowerCase().matches(".*?(jpg|jpeg|png|bmp|gif)$")) {
            String photoPath = FileUtil.saveFileToServer((String)"posid", (String)"storeDetail", (String)(fileName + ".jpg"), (MultipartFile)file);
            zm.setData((Object)photoPath);
            zm.setRet("ok");
            zm.setMsg("posid_upload_success");
        } else {
            zm.setRet("fail");
            zm.setMsg("posid_this_type_not_supported");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zm);
    }

    public ZKResultMsg barCodeGetStoreDetail(PosIDStoreDetailItem codition) {
        PosIDStoreDetailItem item = this.posIDStoreDetailService.getItemByBrandCode(codition.getBrandCode());
        if (null != item) {
            return new ZKResultMsg((Object)item);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"posid_barcode_is_incorrect"));
    }

    public String checkBrandCode(String brandCode, String id) {
        if (brandCode == null) {
            return String.valueOf(true);
        }
        return String.valueOf(this.posIDStoreDetailService.checkBrandCode(brandCode, id));
    }
}

