/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDSplitTimeRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDSplitTimeService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDSplitTimeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDSplitTimeController
extends BaseController
implements PosIDSplitTimeRemote {
    @Autowired
    private PosIDSplitTimeService posIDSplitTimeService;

    @RequiresPermissions(value={"posid:splitTime"})
    public ModelAndView index() {
        return new ModelAndView("posid/splitTime/posIDSplitTime");
    }

    @RequiresPermissions(value={"posid:splitTime:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posIDSplitTimeService.getItemById(id));
        }
        return new ModelAndView("posid/splitTime/editPosIDSplitTime");
    }

    @RequiresPermissions(value={"posid:splitTime:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_splitTime", opType="common_op_new", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(PosIDSplitTimeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        boolean oldIsValid = Boolean.parseBoolean(this.request.getParameter("oldIsValid"));
        this.posIDSplitTimeService.saveItem(item, oldIsValid);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:splitTime:refresh"})
    public DxGrid list(PosIDSplitTimeItem codition) {
        Pager pager = this.posIDSplitTimeService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:splitTime:del"})
    @LogRequest(module="posid_module", object="posid_leftMenu_splitTime", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public ZKResultMsg delete(String ids) {
        this.posIDSplitTimeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg checkSplitTimeseg() {
        String id = this.request.getParameter("splitTimeId");
        String startStr = this.request.getParameter("startTime");
        String endStr = this.request.getParameter("endTime");
        boolean valid = Boolean.parseBoolean(this.request.getParameter("isValid"));
        return this.posIDSplitTimeService.checkTimeseg(id, startStr, endStr, valid);
    }
}

