/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.posid.remote.PosIDAllowanceLogRecordRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDAllowanceLogRecordService;
import com.zkteco.zkbiosecurity.posid.utils.PosIDAllowanceImportUtil;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAllowanceLogImportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAllowanceLogRecordExportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAllowanceLogRecordItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDAllowanceLogRecordController
extends ExportController
implements PosIDAllowanceLogRecordRemote {
    @Autowired
    private PosIDAllowanceLogRecordService posIDAllowanceLogRecordService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"posid:allowanceLogRecord"})
    public ModelAndView index() {
        return new ModelAndView("posid/allowanceLogRecord/posIDAllowanceLogRecord");
    }

    @RequiresPermissions(value={"posid:allowanceLogRecord:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posIDAllowanceLogRecordService.getItemById(id));
        }
        return new ModelAndView("posid/allowanceLogRecord/editPosIDAllowanceLogRecord");
    }

    @RequiresPermissions(value={"posid:allowanceLogRecord:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_allowance", opType="common_op_new", requestParams={"personPin"}, opContent="posid_card_personNum")
    public ZKResultMsg save(PosIDAllowanceLogRecordItem item) {
        ZKResultMsg res = this.posIDAllowanceLogRecordService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:allowanceLogRecord:refresh"})
    public DxGrid list(PosIDAllowanceLogRecordItem codition) {
        Pager pager = this.posIDAllowanceLogRecordService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:allowanceLogRecord:del"})
    @LogRequest(module="posid_module", object="posid_leftMenu_allowance", opType="common_op_del", requestParams={"pins"}, opContent="posid_card_personNum")
    public ZKResultMsg delete(String ids) {
        this.posIDAllowanceLogRecordService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"posid:allowanceLogRecord:setCheck"})
    public ModelAndView setCheck(String ids) {
        StringBuffer pinStringBuffer = new StringBuffer();
        StringBuffer nameStringBuffer = new StringBuffer();
        StringBuffer lastNameStringBuffer = new StringBuffer();
        String[] allowanceLogRecordIds = ids.split(",");
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            for (int i = 0; i < allowanceLogRecordIds.length; ++i) {
                PosIDAllowanceLogRecordItem temPosAllowanceLogRecord = this.posIDAllowanceLogRecordService.getItemById(allowanceLogRecordIds[i]);
                this.posIDAllowanceLogRecordService.buildPersonDept(temPosAllowanceLogRecord);
                if (i != allowanceLogRecordIds.length - 1) {
                    pinStringBuffer.append(temPosAllowanceLogRecord.getPersonPin() + ",");
                    nameStringBuffer.append(temPosAllowanceLogRecord.getPersonName() + ",");
                    lastNameStringBuffer.append(temPosAllowanceLogRecord.getPersonLastName() + ",");
                    continue;
                }
                pinStringBuffer.append(temPosAllowanceLogRecord.getPersonPin());
                nameStringBuffer.append(temPosAllowanceLogRecord.getPersonName() == null ? "" : temPosAllowanceLogRecord.getPersonName());
                lastNameStringBuffer.append(temPosAllowanceLogRecord.getPersonLastName() == null ? "" : temPosAllowanceLogRecord.getPersonLastName());
            }
            this.request.setAttribute("ids", (Object)ids);
            this.request.setAttribute("selectedPin", (Object)pinStringBuffer.toString());
            this.request.setAttribute("selectedName", (Object)nameStringBuffer.toString());
            this.request.setAttribute("ids", (Object)ids);
            this.request.setAttribute("selectedLastName", (Object)lastNameStringBuffer.toString());
        }
        return new ModelAndView("posid/allowanceLogRecord/setCheck");
    }

    @RequiresPermissions(value={"posid:allowanceLogRecord:setCheck"})
    @LogRequest(module="posid_module", object="posid_leftMenu_allowance", opType="posid_allowance_check", requestParams={"pins"}, opContent="posid_card_personNum")
    public ZKResultMsg check(String id) {
        String[] ids = this.request.getParameter("ids").split(",");
        ZKResultMsg zKResultMsg = this.posIDAllowanceLogRecordService.check(ids, false, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"posid:allowanceLogRecord:enable"})
    @LogRequest(module="posid_module", object="posid_leftMenu_allowance", opType="posid_allowance_checkAll", opContent="posid_allowance_checkAll")
    public ZKResultMsg enable() {
        int progress = 1;
        try {
            String sessionId = this.request.getSession().getId();
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.posIDAllowanceLogRecordService.enable(sessionId));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)e).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("enable Allowance Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    @RequiresPermissions(value={"posid:allowanceLogRecord:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        String queryCondition = request.getParameter("queryConditions");
        String[] conditionAry = queryCondition.replaceAll("%20", " ").split("&");
        PosIDAllowanceLogRecordItem posIDAllowanceLogRecordItem = new PosIDAllowanceLogRecordItem();
        this.setConditionValue((BaseItem)posIDAllowanceLogRecordItem);
        for (String condition : conditionAry) {
            String[] strAry;
            if (StringUtils.isBlank((CharSequence)condition) || !"receiveDate".equals((strAry = condition.split("="))[0])) continue;
            Date date = DateUtil.stringToDate((String)strAry[1], (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
            posIDAllowanceLogRecordItem.setReceiveDate(date);
        }
        if (posIDAllowanceLogRecordItem.getMoney() != null) {
            posIDAllowanceLogRecordItem.setMoney(Integer.valueOf(posIDAllowanceLogRecordItem.getMoney() * 100));
        }
        List posIDAllowanceLogRecordExportItemList = this.posIDAllowanceLogRecordService.loadListByAuthFilter(posIDAllowanceLogRecordItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(posIDAllowanceLogRecordExportItemList, PosIDAllowanceLogRecordExportItem.class);
    }

    @RequiresPermissions(value={"posid:allowanceLogRecord:export"})
    public void exportTemplet(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        HashMap map = new HashMap();
        HashMap<String, String> jsonColumn = new HashMap<String, String>();
        JSONObject json = new JSONObject(true);
        json.put("accountNo", (Object)I18nUtil.i18nCode((String)"posid_card_accountNum", (Object[])new Object[0]));
        json.put("money", (Object)I18nUtil.i18nCode((String)"posid_allowance_money", (Object[])new Object[0]));
        json.put("allowType", (Object)I18nUtil.i18nCode((String)"posid_card_subsidyType", (Object[])new Object[0]));
        json.put("arrivalTime", (Object)I18nUtil.i18nCode((String)"posid_allowance_arrival_date", (Object[])new Object[0]));
        json.put("remark", (Object)I18nUtil.i18nCode((String)"common_remark", (Object[])new Object[0]));
        jsonColumn.put("jsonColumn", json.toJSONString());
        map.put("jsonColumn", jsonColumn);
        ArrayList<PosIDAllowanceLogImportItem> itemList = new ArrayList<PosIDAllowanceLogImportItem>();
        PosIDAllowanceLogImportItem item = new PosIDAllowanceLogImportItem();
        item.setAccountNo("1");
        item.setMoney(Integer.valueOf(20));
        item.setAllowType(Integer.valueOf(0));
        item.setArrivalTime(DateUtil.getDate((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD));
        item.setRemark(I18nUtil.i18nCode((String)"posid_import_template_remark", (Object[])new Object[0]));
        itemList.add(item);
        this.excelExport(itemList, PosIDAllowanceLogImportItem.class, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List<PosIDAllowanceLogRecordItem> itemList = PosIDAllowanceImportUtil.excelImport(upload.getInputStream(), PosIDAllowanceLogRecordItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.posIDAllowanceLogRecordService.importData(itemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)e).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import Allowance Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }
}

