/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDAdvertRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDAdvertService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAdvertItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDAdvertController
extends ExportController
implements PosIDAdvertRemote {
    @Autowired
    private PosIDAdvertService posIDAdvertService;

    @RequiresPermissions(value={"posid:advert"})
    public ModelAndView index() {
        return new ModelAndView("posid/advert/posIDAdvert");
    }

    @RequiresPermissions(value={"posid:advert:add"})
    public ModelAndView edit(String id) {
        return new ModelAndView("posid/advert/editPosIDAdvert");
    }

    @RequiresPermissions(value={"posid:advert:refresh"})
    public DxGrid list(PosIDAdvertItem codition) {
        Pager pager = this.posIDAdvertService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:advert:add"})
    public ZKResultMsg save(PosIDAdvertItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posIDAdvertService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg photoUpload(MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
        ZKResultMsg zm = new ZKResultMsg();
        String fileName = System.currentTimeMillis() + "_" + new Random().nextInt(1000);
        if (file.getOriginalFilename().toLowerCase().matches(".*?(jpg|jpeg|png|bmp|gif)$")) {
            String photoPath = FileUtil.saveFileToServer((String)"posID", (String)"advert", (String)(fileName + ".jpg"), (MultipartFile)file);
            zm.setData((Object)photoPath);
            zm.setRet("ok");
            zm.setMsg("posid_upload_success");
        } else {
            zm.setRet("fail");
            zm.setMsg("posid_this_type_not_supported");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zm);
    }

    @RequiresPermissions(value={"posid:advert:del"})
    public ZKResultMsg delete(String ids) {
        this.posIDAdvertService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validCode(Integer code) {
        PosIDAdvertItem posIDAdvertItem = this.posIDAdvertService.getItemByCode(code);
        boolean rs = posIDAdvertItem == null;
        return rs + "";
    }

    public String validSort(Integer sort) {
        PosIDAdvertItem posIDAdvertItem = this.posIDAdvertService.getItemBySort(sort);
        boolean rs = posIDAdvertItem == null;
        return rs + "";
    }
}

