/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDAccountKindRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountKindService;
import com.zkteco.zkbiosecurity.posid.service.PosIDSystemParamService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAccountKindItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDAccountKindController
extends BaseController
implements PosIDAccountKindRemote {
    @Autowired
    private PosIDAccountKindService posIDAccountKindService;
    @Autowired
    private PosIDSystemParamService posIDSystemParamService;

    @RequiresPermissions(value={"posid:accountKind"})
    public ModelAndView index() {
        return new ModelAndView("posid/accountKind/posIDAccountKind");
    }

    @RequiresPermissions(value={"posid:accountKind:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posIDAccountKindService.getItemById(id));
        } else {
            PosIDAccountKindItem item = new PosIDAccountKindItem();
            String highLimit = this.posIDSystemParamService.getValByName("posid.highLimit");
            item.setDateMaxMoney(Integer.valueOf(0));
            item.setPerMaxMoney(Integer.valueOf(0));
            item.setMealMaxMoney(Integer.valueOf(0));
            item.setLessMoney(Integer.valueOf(0));
            item.setMaxMoney(Integer.valueOf(highLimit));
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("highLimit", (Object)highLimit);
        }
        return new ModelAndView("posid/accountKind/editPosIDAccountKind");
    }

    @RequiresPermissions(value={"posid:accountKind:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_icCard", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(PosIDAccountKindItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posIDAccountKindService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:accountKind:refresh"})
    public DxGrid list(PosIDAccountKindItem codition) {
        Pager pager = this.posIDAccountKindService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:accountKind:del"})
    @LogRequest(module="posid_module", object="posid_leftMenu_icCard", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg delete(String ids) {
        this.posIDAccountKindService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getAccountKindList() {
        List items = this.posIDAccountKindService.getAccountKindList();
        return new ZKResultMsg((Object)items);
    }

    public String validCode(String code) {
        PosIDAccountKindItem item = this.posIDAccountKindService.getItemByCode(code);
        boolean rs = item == null;
        return rs + "";
    }

    public TreeItem tree() {
        List posIDAccountKindItems = this.posIDAccountKindService.getByCondition(new PosIDAccountKindItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        for (PosIDAccountKindItem posAccountKind : posIDAccountKindItems) {
            item = new TreeItem();
            item.setId(posAccountKind.getId());
            item.setText(posAccountKind.getName());
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public Boolean validMaxMoney(String maxMoney) {
        String highLimit = this.posIDSystemParamService.getValByName("posid.highLimit");
        return Double.valueOf(maxMoney) <= Double.valueOf(highLimit);
    }
}

