/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.util.ArrayList;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Parser;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.Query;
import org.postgresql.core.v2.SimpleParameterList;

class V2Query
implements Query {
    private static final ParameterList NO_PARAMETERS = new SimpleParameterList(0, false);
    private final String[] fragments;
    private final boolean useEStringSyntax;

    V2Query(String query, boolean withParameters, ProtocolConnection pconn) {
        int i2;
        this.useEStringSyntax = pconn.getServerVersion() != null && pconn.getServerVersion().compareTo("8.1") > 0;
        boolean stdStrings = pconn.getStandardConformingStrings();
        if (!withParameters) {
            this.fragments = new String[]{query};
            return;
        }
        ArrayList<String> v2 = new ArrayList<String>();
        int lastParmEnd = 0;
        char[] aChars = query.toCharArray();
        block8: for (i2 = 0; i2 < aChars.length; ++i2) {
            switch (aChars[i2]) {
                case '\'': {
                    i2 = Parser.parseSingleQuotes(aChars, i2, stdStrings);
                    continue block8;
                }
                case '\"': {
                    i2 = Parser.parseDoubleQuotes(aChars, i2);
                    continue block8;
                }
                case '-': {
                    i2 = Parser.parseLineComment(aChars, i2);
                    continue block8;
                }
                case '/': {
                    i2 = Parser.parseBlockComment(aChars, i2);
                    continue block8;
                }
                case '$': {
                    i2 = Parser.parseDollarQuotes(aChars, i2);
                    continue block8;
                }
                case '?': {
                    v2.add(query.substring(lastParmEnd, i2));
                    lastParmEnd = i2 + 1;
                    continue block8;
                }
            }
        }
        v2.add(query.substring(lastParmEnd, query.length()));
        this.fragments = new String[v2.size()];
        for (i2 = 0; i2 < this.fragments.length; ++i2) {
            this.fragments[i2] = (String)v2.get(i2);
        }
    }

    @Override
    public ParameterList createParameterList() {
        if (this.fragments.length == 1) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.fragments.length - 1, this.useEStringSyntax);
    }

    @Override
    public String toString(ParameterList parameters) {
        StringBuffer sbuf = new StringBuffer(this.fragments[0]);
        for (int i2 = 1; i2 < this.fragments.length; ++i2) {
            if (parameters == null) {
                sbuf.append("?");
            } else {
                sbuf.append(parameters.toString(i2));
            }
            sbuf.append(this.fragments[i2]);
        }
        return sbuf.toString();
    }

    @Override
    public void close() {
    }

    String[] getFragments() {
        return this.fragments;
    }

    @Override
    public boolean isStatementDescribed() {
        return false;
    }
}

