/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ReplicationConnectionGroup;
import com.mysql.jdbc.jmx.ReplicationGroupManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationConnectionGroupManager {
    private static HashMap<String, ReplicationConnectionGroup> GROUP_MAP = new HashMap();
    private static ReplicationGroupManager mbean = new ReplicationGroupManager();
    private static boolean hasRegisteredJmx = false;

    public static synchronized ReplicationConnectionGroup getConnectionGroupInstance(String groupName) {
        if (GROUP_MAP.containsKey(groupName)) {
            return GROUP_MAP.get(groupName);
        }
        ReplicationConnectionGroup group = new ReplicationConnectionGroup(groupName);
        GROUP_MAP.put(groupName, group);
        return group;
    }

    public static void registerJmx() throws SQLException {
        if (hasRegisteredJmx) {
            return;
        }
        mbean.registerJmx();
        hasRegisteredJmx = true;
    }

    public static ReplicationConnectionGroup getConnectionGroup(String groupName) {
        return GROUP_MAP.get(groupName);
    }

    public static Collection<ReplicationConnectionGroup> getGroupsMatching(String group) {
        if (group == null || group.equals("")) {
            HashSet<ReplicationConnectionGroup> s2 = new HashSet<ReplicationConnectionGroup>();
            s2.addAll(GROUP_MAP.values());
            return s2;
        }
        HashSet<ReplicationConnectionGroup> s3 = new HashSet<ReplicationConnectionGroup>();
        ReplicationConnectionGroup o2 = GROUP_MAP.get(group);
        if (o2 != null) {
            s3.add(o2);
        }
        return s3;
    }

    public static void addSlaveHost(String group, String host) throws SQLException {
        Collection<ReplicationConnectionGroup> s2 = ReplicationConnectionGroupManager.getGroupsMatching(group);
        for (ReplicationConnectionGroup cg : s2) {
            cg.addSlaveHost(host);
        }
    }

    public static void removeSlaveHost(String group, String host) throws SQLException {
        ReplicationConnectionGroupManager.removeSlaveHost(group, host, true);
    }

    public static void removeSlaveHost(String group, String host, boolean closeGently) throws SQLException {
        Collection<ReplicationConnectionGroup> s2 = ReplicationConnectionGroupManager.getGroupsMatching(group);
        for (ReplicationConnectionGroup cg : s2) {
            cg.removeSlaveHost(host, closeGently);
        }
    }

    public static void promoteSlaveToMaster(String group, String newMasterHost) throws SQLException {
        Collection<ReplicationConnectionGroup> s2 = ReplicationConnectionGroupManager.getGroupsMatching(group);
        for (ReplicationConnectionGroup cg : s2) {
            cg.promoteSlaveToMaster(newMasterHost);
        }
    }

    public static long getSlavePromotionCount(String group) throws SQLException {
        Collection<ReplicationConnectionGroup> s2 = ReplicationConnectionGroupManager.getGroupsMatching(group);
        long promoted = 0L;
        for (ReplicationConnectionGroup cg : s2) {
            long tmp = cg.getNumberOfSlavePromotions();
            if (tmp <= promoted) continue;
            promoted = tmp;
        }
        return promoted;
    }

    public static void removeMasterHost(String group, String host) throws SQLException {
        ReplicationConnectionGroupManager.removeMasterHost(group, host, true);
    }

    public static void removeMasterHost(String group, String host, boolean closeGently) throws SQLException {
        Collection<ReplicationConnectionGroup> s2 = ReplicationConnectionGroupManager.getGroupsMatching(group);
        for (ReplicationConnectionGroup cg : s2) {
            cg.removeMasterHost(host, closeGently);
        }
    }

    public static String getRegisteredReplicationConnectionGroups() {
        Collection<ReplicationConnectionGroup> s2 = ReplicationConnectionGroupManager.getGroupsMatching(null);
        StringBuffer sb = new StringBuffer();
        String sep = "";
        for (ReplicationConnectionGroup cg : s2) {
            String group = cg.getGroupName();
            sb.append(sep);
            sb.append(group);
            sep = ",";
        }
        return sb.toString();
    }

    public static int getNumberOfMasterPromotion(String groupFilter) {
        int total = 0;
        Collection<ReplicationConnectionGroup> s2 = ReplicationConnectionGroupManager.getGroupsMatching(groupFilter);
        for (ReplicationConnectionGroup cg : s2) {
            total = (int)((long)total + cg.getNumberOfSlavePromotions());
        }
        return total;
    }

    public static int getConnectionCountWithHostAsSlave(String groupFilter, String host) {
        int total = 0;
        Collection<ReplicationConnectionGroup> s2 = ReplicationConnectionGroupManager.getGroupsMatching(groupFilter);
        for (ReplicationConnectionGroup cg : s2) {
            total += cg.getConnectionCountWithHostAsSlave(host);
        }
        return total;
    }

    public static int getConnectionCountWithHostAsMaster(String groupFilter, String host) {
        int total = 0;
        Collection<ReplicationConnectionGroup> s2 = ReplicationConnectionGroupManager.getGroupsMatching(groupFilter);
        for (ReplicationConnectionGroup cg : s2) {
            total += cg.getConnectionCountWithHostAsMaster(host);
        }
        return total;
    }

    public static Collection<String> getSlaveHosts(String groupFilter) {
        Collection<ReplicationConnectionGroup> s2 = ReplicationConnectionGroupManager.getGroupsMatching(groupFilter);
        ArrayList<String> hosts = new ArrayList<String>();
        for (ReplicationConnectionGroup cg : s2) {
            hosts.addAll(cg.getSlaveHosts());
        }
        return hosts;
    }

    public static Collection<String> getMasterHosts(String groupFilter) {
        Collection<ReplicationConnectionGroup> s2 = ReplicationConnectionGroupManager.getGroupsMatching(groupFilter);
        ArrayList<String> hosts = new ArrayList<String>();
        for (ReplicationConnectionGroup cg : s2) {
            hosts.addAll(cg.getMasterHosts());
        }
        return hosts;
    }

    public static long getTotalConnectionCount(String group) {
        long connections = 0L;
        Collection<ReplicationConnectionGroup> s2 = ReplicationConnectionGroupManager.getGroupsMatching(group);
        for (ReplicationConnectionGroup cg : s2) {
            connections += cg.getTotalConnectionCount();
        }
        return connections;
    }

    public static long getActiveConnectionCount(String group) {
        long connections = 0L;
        Collection<ReplicationConnectionGroup> s2 = ReplicationConnectionGroupManager.getGroupsMatching(group);
        for (ReplicationConnectionGroup cg : s2) {
            connections += cg.getActiveConnectionCount();
        }
        return connections;
    }
}

