/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import java.util.logging.Level;

final class ScrollWindow {
    private TDSReaderMark[] rowMark;
    private boolean[] updatedRow;
    private boolean[] deletedRow;
    private int size = 0;
    private int maxRows = 0;
    private int currentRow;

    final int getMaxRows() {
        return this.maxRows;
    }

    final int getRow() {
        return this.currentRow;
    }

    ScrollWindow(int n2) {
        this.setSize(n2);
        this.reset();
    }

    private final void setSize(int n2) {
        assert (this.size != n2);
        this.size = n2;
        this.maxRows = n2;
        this.rowMark = new TDSReaderMark[n2];
        this.updatedRow = new boolean[n2];
        this.deletedRow = new boolean[n2];
    }

    final void clear() {
        for (int i2 = 0; i2 < this.rowMark.length; ++i2) {
            this.rowMark[i2] = null;
            this.updatedRow[i2] = false;
            this.deletedRow[i2] = false;
        }
        assert (this.size > 0);
        this.maxRows = this.size;
        this.reset();
    }

    final void reset() {
        this.currentRow = 0;
    }

    final void resize(int n2) {
        assert (n2 > 0);
        if (n2 != this.size) {
            this.setSize(n2);
        }
    }

    final String logCursorState() {
        return " currentRow:" + this.currentRow + " maxRows:" + this.maxRows;
    }

    final boolean next(SQLServerResultSet sQLServerResultSet) throws SQLServerException {
        if (SQLServerResultSet.logger.isLoggable(Level.FINER)) {
            SQLServerResultSet.logger.finer(sQLServerResultSet.toString() + this.logCursorState());
        }
        assert (0 <= this.currentRow && this.currentRow <= this.maxRows + 1);
        if (this.maxRows + 1 == this.currentRow) {
            return false;
        }
        if (this.currentRow >= 1) {
            this.updatedRow[this.currentRow - 1] = sQLServerResultSet.getUpdatedCurrentRow();
            this.deletedRow[this.currentRow - 1] = sQLServerResultSet.getDeletedCurrentRow();
        }
        ++this.currentRow;
        if (this.maxRows + 1 == this.currentRow) {
            sQLServerResultSet.fetchBufferNext();
            return false;
        }
        if (null != this.rowMark[this.currentRow - 1]) {
            sQLServerResultSet.fetchBufferReset(this.rowMark[this.currentRow - 1]);
            sQLServerResultSet.setUpdatedCurrentRow(this.updatedRow[this.currentRow - 1]);
            sQLServerResultSet.setDeletedCurrentRow(this.deletedRow[this.currentRow - 1]);
            return true;
        }
        if (sQLServerResultSet.fetchBufferNext()) {
            this.rowMark[this.currentRow - 1] = sQLServerResultSet.fetchBufferMark();
            if (SQLServerResultSet.logger.isLoggable(Level.FINEST)) {
                SQLServerResultSet.logger.finest(sQLServerResultSet.toString() + " Set mark " + this.rowMark[this.currentRow - 1] + " for row " + this.currentRow);
            }
            return true;
        }
        this.maxRows = this.currentRow - 1;
        return false;
    }

    final void previous(SQLServerResultSet sQLServerResultSet) throws SQLServerException {
        if (SQLServerResultSet.logger.isLoggable(Level.FINER)) {
            SQLServerResultSet.logger.finer(sQLServerResultSet.toString() + this.logCursorState());
        }
        assert (0 <= this.currentRow && this.currentRow <= this.maxRows + 1);
        if (0 == this.currentRow) {
            return;
        }
        if (this.currentRow <= this.maxRows) {
            assert (this.currentRow >= 1);
            this.updatedRow[this.currentRow - 1] = sQLServerResultSet.getUpdatedCurrentRow();
            this.deletedRow[this.currentRow - 1] = sQLServerResultSet.getDeletedCurrentRow();
        }
        --this.currentRow;
        if (0 == this.currentRow) {
            return;
        }
        assert (null != this.rowMark[this.currentRow - 1]);
        sQLServerResultSet.fetchBufferReset(this.rowMark[this.currentRow - 1]);
        sQLServerResultSet.setUpdatedCurrentRow(this.updatedRow[this.currentRow - 1]);
        sQLServerResultSet.setDeletedCurrentRow(this.deletedRow[this.currentRow - 1]);
    }
}

