/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.ReaderInputStream;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerClobAsciiOutputStream;
import com.microsoft.sqlserver.jdbc.SQLServerClobWriter;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class SQLServerClobBase
implements Serializable {
    private String value;
    private final SQLCollation sqlCollation;
    private boolean isClosed = false;
    private ArrayList<Closeable> activeStreams = new ArrayList(1);
    SQLServerConnection con;
    private final Logger logger;
    private final String traceID = this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46)) + ":" + SQLServerClobBase.nextInstanceID();
    private static int baseID = 0;

    public final String toString() {
        return this.traceID;
    }

    private static synchronized int nextInstanceID() {
        return ++baseID;
    }

    abstract JDBCType getJdbcType();

    private String getDisplayClassName() {
        String string = this.getJdbcType().className();
        return string.substring(1 + string.lastIndexOf(46));
    }

    SQLServerClobBase(SQLServerConnection sQLServerConnection, String string, SQLCollation sQLCollation, Logger logger) {
        this.con = sQLServerConnection;
        this.value = string;
        this.sqlCollation = sQLCollation;
        this.logger = logger;
        if (logger.isLoggable(Level.FINE)) {
            String string2 = null != sQLServerConnection ? sQLServerConnection.toString() : "null connection";
            logger.fine(this.toString() + " created by (" + string2 + ")");
        }
    }

    public void free() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (!this.isClosed) {
            if (null != this.activeStreams) {
                for (Closeable closeable : this.activeStreams) {
                    try {
                        closeable.close();
                    }
                    catch (IOException iOException) {
                        this.logger.fine(this.toString() + " ignored IOException closing stream " + closeable + ": " + iOException.getMessage());
                    }
                }
                this.activeStreams = null;
            }
            this.value = null;
            this.isClosed = true;
        }
    }

    private final void checkClosed() throws SQLServerException {
        if (this.isClosed) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_isFreed"));
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(new Object[]{this.getDisplayClassName()}), null, true);
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        BufferedInputStream bufferedInputStream;
        this.checkClosed();
        if (null != this.sqlCollation && !this.sqlCollation.supportsAsciiConversion()) {
            DataTypes.throwConversionError(this.getDisplayClassName(), "AsciiStream");
        }
        try {
            bufferedInputStream = new BufferedInputStream(new ReaderInputStream(new StringReader(this.value), "US-ASCII", this.value.length()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLServerException(unsupportedEncodingException.getMessage(), null, 0, (Throwable)unsupportedEncodingException);
        }
        this.activeStreams.add(bufferedInputStream);
        return bufferedInputStream;
    }

    public Reader getCharacterStream() throws SQLException {
        this.checkClosed();
        StringReader stringReader = new StringReader(this.value);
        this.activeStreams.add(stringReader);
        return stringReader;
    }

    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    public String getSubString(long l2, int n2) throws SQLException {
        Object[] objectArray;
        MessageFormat messageFormat;
        this.checkClosed();
        if (l2 < 1L) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (n2 < 0) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (--l2 > (long)this.value.length()) {
            l2 = this.value.length();
        }
        if ((long)n2 > (long)this.value.length() - l2) {
            n2 = (int)((long)this.value.length() - l2);
        }
        return this.value.substring((int)l2, (int)l2 + n2);
    }

    public long length() throws SQLException {
        this.checkClosed();
        return this.value.length();
    }

    public long position(Clob clob, long l2) throws SQLException {
        this.checkClosed();
        if (l2 < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            Object[] objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (null == clob) {
            return -1L;
        }
        return this.position(clob.getSubString(1L, (int)clob.length()), l2);
    }

    public long position(String string, long l2) throws SQLException {
        this.checkClosed();
        if (l2 < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            Object[] objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (null == string) {
            return -1L;
        }
        int n2 = this.value.indexOf(string, (int)(l2 - 1L));
        if (-1 != n2) {
            return n2 + 1;
        }
        return -1L;
    }

    public void truncate(long l2) throws SQLException {
        this.checkClosed();
        if (l2 < 0L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (l2 <= Integer.MAX_VALUE && (long)this.value.length() > l2) {
            this.value = this.value.substring(0, (int)l2);
        }
    }

    public OutputStream setAsciiStream(long l2) throws SQLException {
        this.checkClosed();
        if (l2 < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            Object[] objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        return new SQLServerClobAsciiOutputStream(this, l2);
    }

    public Writer setCharacterStream(long l2) throws SQLException {
        this.checkClosed();
        if (l2 < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            Object[] objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        return new SQLServerClobWriter(this, l2);
    }

    public int setString(long l2, String string) throws SQLException {
        this.checkClosed();
        if (null == string) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_cantSetNull"), null, true);
        }
        return this.setString(l2, string, 0, string.length());
    }

    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        Object[] objectArray;
        Serializable serializable;
        this.checkClosed();
        if (null == string) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_cantSetNull"), null, true);
        }
        if (n2 < 0 || n2 > string.length()) {
            serializable = new MessageFormat(SQLServerException.getErrString("R_invalidOffset"));
            objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)serializable).format(objectArray), null, true);
        }
        if (n3 < 0 || n3 > string.length() - n2) {
            serializable = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n3)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)serializable).format(objectArray), null, true);
        }
        if (l2 < 1L || l2 > (long)(this.value.length() + 1)) {
            serializable = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)serializable).format(objectArray), null, true);
        }
        if ((long)n3 >= (long)this.value.length() - --l2) {
            DataTypes.getCheckedLength(this.con, this.getJdbcType(), l2 + (long)n3, false);
            assert (l2 + (long)n3 <= Integer.MAX_VALUE);
            serializable = new StringBuilder((int)l2 + n3);
            ((StringBuilder)serializable).append(this.value.substring(0, (int)l2));
            ((StringBuilder)serializable).append(string.substring(n2, n2 + n3));
            this.value = ((StringBuilder)serializable).toString();
        } else {
            serializable = new StringBuilder(this.value.length());
            ((StringBuilder)serializable).append(this.value.substring(0, (int)l2));
            ((StringBuilder)serializable).append(string.substring(n2, n2 + n3));
            ((StringBuilder)serializable).append(this.value.substring((int)l2 + n3));
            this.value = ((StringBuilder)serializable).toString();
        }
        return n3;
    }
}

