/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ELE_FLOOR t LEFT JOIN ELE_DEVICE d ON d.ID=t.DEV_ID")
@OrderBy(after="d.CREATE_TIME ASC, t.FLOOR_NO ASC")
@GridConfig(operate=false, idField="id")
public class EleLevelSelectFloorItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.FLOOR_NO")
    @GridColumn(label="ele_floor_number", sortNo=1, width="120")
    private Short floorNo;
    @Column(name="t.NAME")
    @GridColumn(label="ele_floor_name", sortNo=2, width="*")
    private String floorName;
    @Column(name="d.DEV_ALIAS")
    private String deviceAlias;
    @Column(name="d.SN")
    private String deviceSn;
    @Column(name="d.ID")
    private String deviceId;
    @Column(name="d.AUTH_AREA_ID")
    private String areaId;
    private String type;
    @Condition(value="t.ID NOT IN (SELECT elf.FLOOR_ID FROM ELE_LEVEL_FLOOR elf WHERE elf.LEVEL_ID = ''{0}'')")
    private String filterId;
    private String selectId;
    @Column(name="t.ID", equalTag="in")
    private String selectFloorIdsIn;
    @Column(name="t.ID", equalTag="not in")
    private String selectFloorIdsNotIn;
    private String levelId;
    @Condition(value="d.AUTH_AREA_ID IN (%s)", formatType="quote")
    private String areaIds;

    public String getId() {
        return this.id;
    }

    public Short getFloorNo() {
        return this.floorNo;
    }

    public String getFloorName() {
        return this.floorName;
    }

    public String getDeviceAlias() {
        return this.deviceAlias;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getType() {
        return this.type;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getSelectFloorIdsIn() {
        return this.selectFloorIdsIn;
    }

    public String getSelectFloorIdsNotIn() {
        return this.selectFloorIdsNotIn;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public String getAreaIds() {
        return this.areaIds;
    }

    public EleLevelSelectFloorItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleLevelSelectFloorItem setFloorNo(Short floorNo) {
        this.floorNo = floorNo;
        return this;
    }

    public EleLevelSelectFloorItem setFloorName(String floorName) {
        this.floorName = floorName;
        return this;
    }

    public EleLevelSelectFloorItem setDeviceAlias(String deviceAlias) {
        this.deviceAlias = deviceAlias;
        return this;
    }

    public EleLevelSelectFloorItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public EleLevelSelectFloorItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public EleLevelSelectFloorItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public EleLevelSelectFloorItem setType(String type) {
        this.type = type;
        return this;
    }

    public EleLevelSelectFloorItem setFilterId(String filterId) {
        this.filterId = filterId;
        return this;
    }

    public EleLevelSelectFloorItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public EleLevelSelectFloorItem setSelectFloorIdsIn(String selectFloorIdsIn) {
        this.selectFloorIdsIn = selectFloorIdsIn;
        return this;
    }

    public EleLevelSelectFloorItem setSelectFloorIdsNotIn(String selectFloorIdsNotIn) {
        this.selectFloorIdsNotIn = selectFloorIdsNotIn;
        return this;
    }

    public EleLevelSelectFloorItem setLevelId(String levelId) {
        this.levelId = levelId;
        return this;
    }

    public EleLevelSelectFloorItem setAreaIds(String areaIds) {
        this.areaIds = areaIds;
        return this;
    }

    public String toString() {
        return "EleLevelSelectFloorItem(id=" + this.getId() + ", floorNo=" + this.getFloorNo() + ", floorName=" + this.getFloorName() + ", deviceAlias=" + this.getDeviceAlias() + ", deviceSn=" + this.getDeviceSn() + ", deviceId=" + this.getDeviceId() + ", areaId=" + this.getAreaId() + ", type=" + this.getType() + ", filterId=" + this.getFilterId() + ", selectId=" + this.getSelectId() + ", selectFloorIdsIn=" + this.getSelectFloorIdsIn() + ", selectFloorIdsNotIn=" + this.getSelectFloorIdsNotIn() + ", levelId=" + this.getLevelId() + ", areaIds=" + this.getAreaIds() + ")";
    }
}

