/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ELE_FLOOR t LEFT JOIN ELE_DEVICE ed ON ed.ID = t.DEV_ID LEFT JOIN ELE_TIMESEG at ON at.ID = t.ACTIVE_TIMESEG_ID LEFT JOIN ELE_TIMESEG pt ON pt.ID = t.PASSMODE_TIMESEG_ID ")
@OrderBy(after="ed.CREATE_TIME ASC, t.FLOOR_NO ASC")
@GridConfig(operate=true, idField="id", winHeight=370, winWidth=400, operates={@GridOperate(type="edit", permission="ele:floor:edit", url="eleFloor.do?edit", label="common_op_edit")})
public class EleFloorItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40")
    private String id;
    @Column(name="t.FLOOR_NO")
    @GridColumn(label="ele_floor_number", width="150")
    private Short floorNo;
    @Column(name="t.NAME")
    @GridColumn(label="ele_floor_name", width="150", columnType="edit", editUrl="eleFloor.do?edit", editPermission="ele:floor:edit")
    private String name;
    @Column(name="ed.DEV_ALIAS")
    @GridColumn(label="common_ownedDev", width="150")
    private String deviceAlias;
    @Column(name="at.ID")
    private String activeTimeSegId;
    @Column(name="at.NAME")
    @GridColumn(label="ele_floor_activeTimeZone", width="150")
    private String activeTimeSeg;
    @Column(name="pt.ID")
    private String passModeTimeSegId;
    @Column(name="pt.NAME")
    private String passModeTimeSeg;
    @Column(name="t.LOCK_DELAY")
    private Short lockDelay;
    @Column(name="ed.ID")
    private String deviceId;
    @Condition(value="ed.AUTH_AREA_ID IN (%s)", formatType="quote")
    private String areaIdIn;
    @Condition(value="t.ID", equalTag="in")
    private String inId;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Column(name="ed.SN")
    private String deviceSn;
    @Condition(value="ed.ID IN (%s)", formatType="quote")
    private String devIdIn;

    public EleFloorItem() {
    }

    public EleFloorItem(Boolean equals) {
        super(equals);
    }

    public EleFloorItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public EleFloorItem(String id, Short floorNo, String name, Short lockDelay) {
        this.id = id;
        this.floorNo = floorNo;
        this.name = name;
        this.lockDelay = lockDelay;
    }

    public String getId() {
        return this.id;
    }

    public Short getFloorNo() {
        return this.floorNo;
    }

    public String getName() {
        return this.name;
    }

    public String getDeviceAlias() {
        return this.deviceAlias;
    }

    public String getActiveTimeSegId() {
        return this.activeTimeSegId;
    }

    public String getActiveTimeSeg() {
        return this.activeTimeSeg;
    }

    public String getPassModeTimeSegId() {
        return this.passModeTimeSegId;
    }

    public String getPassModeTimeSeg() {
        return this.passModeTimeSeg;
    }

    public Short getLockDelay() {
        return this.lockDelay;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getInId() {
        return this.inId;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getDevIdIn() {
        return this.devIdIn;
    }

    public EleFloorItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleFloorItem setFloorNo(Short floorNo) {
        this.floorNo = floorNo;
        return this;
    }

    public EleFloorItem setName(String name) {
        this.name = name;
        return this;
    }

    public EleFloorItem setDeviceAlias(String deviceAlias) {
        this.deviceAlias = deviceAlias;
        return this;
    }

    public EleFloorItem setActiveTimeSegId(String activeTimeSegId) {
        this.activeTimeSegId = activeTimeSegId;
        return this;
    }

    public EleFloorItem setActiveTimeSeg(String activeTimeSeg) {
        this.activeTimeSeg = activeTimeSeg;
        return this;
    }

    public EleFloorItem setPassModeTimeSegId(String passModeTimeSegId) {
        this.passModeTimeSegId = passModeTimeSegId;
        return this;
    }

    public EleFloorItem setPassModeTimeSeg(String passModeTimeSeg) {
        this.passModeTimeSeg = passModeTimeSeg;
        return this;
    }

    public EleFloorItem setLockDelay(Short lockDelay) {
        this.lockDelay = lockDelay;
        return this;
    }

    public EleFloorItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public EleFloorItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public EleFloorItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public EleFloorItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public EleFloorItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public EleFloorItem setDevIdIn(String devIdIn) {
        this.devIdIn = devIdIn;
        return this;
    }
}

