/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService.receiveFromCS;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.service.AuthUserService;
import com.zkteco.zkbiosecurity.auth.vo.AuthUserItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.MD5Util;
import com.zkteco.zkbiosecurity.park.bean.ParkWebsocketMsg;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkChangeShiftsService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceOpRecordService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingMeterService;
import com.zkteco.zkbiosecurity.park.service.ParkPavilioService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkWebsocketService;
import com.zkteco.zkbiosecurity.park.service.ParkWorkRecordService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkChangeShiftsItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPavilioItem;
import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import com.zkteco.zkbiosecurity.park.websocketService.DataCallFuntion;
import com.zkteco.zkbiosecurity.park.websocketService.IDataHandle;
import com.zkteco.zkbiosecurity.park.websocketService.sendToCS.ParkCSPavilioMsg;
import java.sql.Timestamp;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkCSLogin
implements IDataHandle {
    @Autowired
    private ParkPavilioService parkPavilioService;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private AuthUserService authUserService;
    @Autowired
    private ParkCSPavilioMsg parkCSPavilioMsg;
    @Autowired
    private ParkChangeShiftsService parkChangeShiftsService;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkWorkRecordService parkWorkRecordService;
    @Autowired
    private ParkWebsocketService parkWebsocketService;
    @Autowired
    private ParkParkingMeterService parkParkingMeterService;
    @Autowired
    private ParkDeviceOpRecordService parkDeviceOpRecordService;
    @Autowired
    private ParkParamsService parkParamsService;

    @DataCallFuntion(value="regedit")
    public void regeditClient(JSONObject msg) {
        JSONObject data = msg.getJSONObject("data");
        String code = data.getString("code");
        String pavilioIp = msg.getString("channelId");
        String msgId = msg.getString("msgId");
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("regedit");
        retMsg.setMsgId(msgId);
        boolean isNotExist = this.parkPavilioService.isNotExistCode(code);
        if (isNotExist) {
            retMsg.setRet(-1);
            retMsg.setData(I18nUtil.i18nCode((String)"park_csRegedit_codeError", (Object[])new Object[0]));
            this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
        } else {
            ParkPavilioItem pavilioItem = this.parkPavilioService.getPavilioByIpAddress(pavilioIp);
            if (ParkWebCommonUtil.isNotNull(pavilioItem) && pavilioItem.getClientMode().equals(ParkConstants.PAVILIO_WEB)) {
                retMsg.setRet(-4);
                retMsg.setData(I18nUtil.i18nCode((String)"park_csRegedit_repeatConfig", (Object[])new Object[0]));
                this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
            } else if (ParkWebCommonUtil.isNotNull(pavilioItem) && !pavilioItem.getRegistrationCode().equals(code)) {
                retMsg.setRet(-3);
                retMsg.setData(I18nUtil.i18nCode((String)"park_csRegedit_ipExisted", (Object[])new Object[0]));
                this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
            } else {
                boolean isAuth = false;
                ParkPavilioItem item = this.parkPavilioService.getPavilioByCode(code);
                if (ParkWebCommonUtil.isNull(item.getIpAddress())) {
                    isAuth = true;
                    this.parkPavilioService.updatePavilioState(item.getId(), pavilioIp);
                } else if (pavilioIp.equals(item.getIpAddress())) {
                    isAuth = true;
                    this.parkCacheService.set("park:pavilio_status_" + item.getId(), (Object)"online", 0L);
                } else {
                    retMsg.setRet(-5);
                    retMsg.setData(I18nUtil.i18nCode((String)"park_checkPassword_codeIsUse", (Object[])new Object[0]));
                    this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
                }
                if (isAuth) {
                    retMsg.setRet(1);
                    retMsg.setData("SUCCESS");
                    this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
                    this.parkCSPavilioMsg.syncPavilioInfoToCS(pavilioIp, true);
                    this.parkCSPavilioMsg.syncParkingSetInfoToCS(pavilioIp);
                    this.parkCSPavilioMsg.syncDiscountInfoToCS(pavilioIp, null);
                    this.parkCSPavilioMsg.syncAllCarTypeToCS(pavilioIp);
                    List deviceItems = this.parkDeviceService.getByPavilioIpAddress(pavilioIp);
                    if (ParkWebCommonUtil.isNotNull(deviceItems)) {
                        StringBuffer strBuf = new StringBuffer();
                        for (ParkDeviceItem devItem : deviceItems) {
                            JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devItem.getIpAddress());
                            devObj.put("pavilioIp", (Object)pavilioIp);
                            devObj.put("pavilioMode", (Object)"cs");
                            this.parkCacheService.setJson("park:dev_info_" + devItem.getIpAddress(), devObj, 0L);
                            strBuf.append(devItem.getId()).append(",");
                        }
                    }
                }
            }
        }
    }

    @DataCallFuntion(value="connectionTest")
    public void connectionTest(JSONObject msg) {
        String code = msg.getString("data");
        String pavilioIp = msg.getString("channelId");
        String msgId = msg.getString("msgId");
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("connectionTest");
        retMsg.setMsgId(msgId);
        boolean isNotExist = this.parkPavilioService.isNotExistCode(code);
        if (isNotExist) {
            retMsg.setRet(-1);
            retMsg.setData(I18nUtil.i18nCode((String)"park_csRegedit_codeError", (Object[])new Object[0]));
        } else {
            retMsg.setRet(1);
            retMsg.setData(I18nUtil.i18nCode((String)"park_csLogin_success", (Object[])new Object[0]));
        }
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }

    @DataCallFuntion(value="loginVerification")
    public void loginVerification(JSONObject msg) {
        JSONObject data = msg.getJSONObject("data");
        String userName = data.getString("userName");
        String passWord = data.getString("passWord");
        String pavilioIp = msg.getString("channelId");
        String msgId = msg.getString("msgId");
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("loginVerification");
        retMsg.setMsgId(msgId);
        AuthUserItem userItem = this.authUserService.getUserByNameAndLoginPwd(userName, passWord);
        if (ParkWebCommonUtil.isNull(userItem)) {
            retMsg.setRet(-1);
            retMsg.setData(I18nUtil.i18nCode((String)"park_csLogin_error", (Object[])new Object[0]));
        }
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }

    @DataCallFuntion(value="csLogin")
    public void login(JSONObject msg) {
        JSONObject data = msg.getJSONObject("data");
        String parkingAreaId = data.getString("parkingAreaId");
        String userName = data.getString("userName");
        String passWord = data.getString("passWord");
        String pavilioIp = msg.getString("channelId");
        String msgId = msg.getString("msgId");
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("csLogin");
        retMsg.setMsgId(msgId);
        AuthUserItem userItem = this.authUserService.getUserByNameAndLoginPwd(userName, passWord);
        if (ParkWebCommonUtil.isNotNull(userItem)) {
            JSONObject retData = new JSONObject();
            retMsg.setRet(1);
            retData.put("token", (Object)"");
            retData.put("persPersonId", (Object)userItem.getId());
            JSONObject shiftsInfo = this.getShiftsInfo(pavilioIp, userItem.getId());
            retData.put("shiftsInfo", (Object)shiftsInfo);
            retMsg.setData(JSONObject.toJSONString((Object)retData));
            this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
            this.parkRecordinService.sendMsgFreeParkingSpace(parkingAreaId);
        } else {
            retMsg.setRet(-1);
            retMsg.setData(I18nUtil.i18nCode((String)"park_csLogin_error", (Object[])new Object[0]));
            this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
        }
    }

    private JSONObject getShiftsInfo(String pavilioIp, String persPersonId) {
        ParkChangeShiftsItem item = this.parkChangeShiftsService.getCSPavilioShiftsInfo(pavilioIp, persPersonId);
        JSONObject retData = new JSONObject();
        retData.put("dutyId", (Object)item.getDutyId());
        retData.put("dutyName", (Object)item.getDutyName());
        retData.put("workRecordId", (Object)item.getWorkRecordId());
        retData.put("dutyStartTime", (Object)item.getStartTime());
        retData.put("dutyEndTime", (Object)item.getEndTime());
        retData.put("openByHandNum", (Object)item.getOpenByHandNum());
        retData.put("freeoutCarNum", (Object)item.getFreeoutCarNum());
        retData.put("discountAmount", (Object)item.getDiscountAmount());
        retData.put("turnover", (Object)item.getTurnover());
        retData.put("shiftDefinitionName", (Object)item.getShiftDefinitionName());
        return retData;
    }

    @DataCallFuntion(value="getChangeShift")
    public void getChangeShift(JSONObject msg) {
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String persPersonId = data.getString("persPersonId");
        String msgId = msg.getString("msgId");
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("changeShift");
        retMsg.setMsgId(msgId);
        retMsg.setRet(1);
        JSONObject retData = this.getShiftsInfo(pavilioIp, persPersonId);
        retMsg.setData(retData.toJSONString());
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }

    @DataCallFuntion(value="saveChangeShift")
    public void saveChangeShift(JSONObject msg) {
        JSONObject data = msg.getJSONObject("data");
        String pavilioIp = msg.getString("channelId");
        ParkChangeShiftsItem item = (ParkChangeShiftsItem)JSONObject.toJavaObject((JSON)data, ParkChangeShiftsItem.class);
        item.setStartTime(new Timestamp(data.getLongValue("dutyStartTime")));
        item.setEndTime(new Timestamp(data.getLongValue("dutyEndTime")));
        this.parkChangeShiftsService.saveItem(item);
        this.parkWorkRecordService.updateDutyStatus(pavilioIp);
    }

    @DataCallFuntion(value="modifyPassWord")
    public void modifyPassWord(JSONObject msg) {
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String persPersonId = data.getString("dutyId");
        String passWrod = data.getString("passWrod");
        String msgId = msg.getString("msgId");
        ZKResultMsg zkMsg = this.authUserService.changeUserPassword(persPersonId, MD5Util.entype((String)passWrod));
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("modifyPassWord");
        retMsg.setMsgId(msgId);
        if (!zkMsg.getRet().equals("ok")) {
            retMsg.setRet(-1);
        }
        retMsg.setData(zkMsg.getMsg());
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }
}

