/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService.Service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.park.bean.ParkCheckOutInfo;
import com.zkteco.zkbiosecurity.park.bean.ParkWebsocketMsg;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.enums.ParkViewEnum;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkWebSocketSDKClient;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkWebSocketSDKFun;
import com.zkteco.zkbiosecurity.park.sdkClient.protocol.Park485Protocol;
import com.zkteco.zkbiosecurity.park.sdkClient.protocol.ParkSendCmd;
import com.zkteco.zkbiosecurity.park.sdkClient.protocol.ZKLprBlackWhite;
import com.zkteco.zkbiosecurity.park.service.ParkAuthorizeService;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkCarNumberService;
import com.zkteco.zkbiosecurity.park.service.ParkCarTypeService;
import com.zkteco.zkbiosecurity.park.service.ParkChannelService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceOpRecordService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkDisplayDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingAreaService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingSpaceService;
import com.zkteco.zkbiosecurity.park.service.ParkPavilioService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinSideService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.service.ParkWebsocketService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkAuthorizeItem;
import com.zkteco.zkbiosecurity.park.vo.ParkBlackWhiteItem;
import com.zkteco.zkbiosecurity.park.vo.ParkCarNumberItem;
import com.zkteco.zkbiosecurity.park.vo.ParkChannelItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDiscountStrategyItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDisplayDeviceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingAreaItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPavilioItem;
import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import com.zkteco.zkbiosecurity.park.websocketService.sendToCS.ParkCSPavilioMsg;
import com.zkteco.zkbiosecurity.park.websocketService.sendToCS.ParkDeviceComm;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.websocket.ContainerProvider;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
@Order(value=83)
public class ParkWebsocketServiceImpl
implements ParkWebsocketService,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ParkWebsocketServiceImpl.class);
    private static VoiceAndViewThread voiceAndViewThread;
    private static boolean WEBSOCKETINIT;
    private static Session sdkSession;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkCarTypeService carTypeService;
    @Autowired
    private ParkWebSocketSDKFun webSocketSDKFun;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkCarNumberService parkCarNumberService;
    @Autowired
    private Park485Protocol park485Protocol;
    @Autowired
    private ParkSendCmd parkSendCmd;
    @Autowired
    private ParkParkingAreaService parkParkingAreaService;
    @Autowired
    private ParkAuthorizeService parkAuthorizeService;
    @Autowired
    private ParkParkingSpaceService parkParkingSpaceService;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkPavilioService parkPavilioService;
    @Autowired
    private ParkDeviceComm parkDeviceComm;
    @Autowired
    private ParkCSPavilioMsg parkCSPavilioMsg;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private ParkChannelService parkChannelService;
    @Autowired
    private ParkDeviceOpRecordService parkDeviceOpRecordService;
    @Autowired
    private SimpMessagingTemplate messagingTemplate;
    @Autowired
    private ParkDisplayDeviceService parkDisplayDeviceService;
    @Autowired
    private ParkRecordinSideService parkRecordinSideService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    private final int defaultScreemWidth = 128;
    private final int defaultScreemHeight = 32;

    public void run(String ... arg0) {
        new WebsocketServiceInit("ParkWebsocketServiceInitThread").start();
    }

    private void delOldDataFromRedis() {
        this.parkCacheService.dels("park:alldev_ip");
        this.parkCacheService.dels("park:areaid_");
        this.parkCacheService.dels("park:cartype_code_");
        this.parkCacheService.dels("park:dev_handle_");
        this.parkCacheService.dels("park:dev_info_");
        this.parkCacheService.dels("park:view_defa_content_");
        this.parkCacheService.dels("park:channel_");
        this.parkCacheService.dels("park:ws_msgid_");
        this.parkCacheService.dels("park:pavilio_mode_");
        this.parkCacheService.dels("park:parkingLot_");
        this.parkCacheService.dels("park:pavilio_status_");
        this.parkCacheService.dels("park:biosecurity_");
        this.parkCacheService.dels("park:channel_id_");
        this.parkCacheService.dels("park:displaydev_info_");
    }

    public void createSDKService() {
        String devIpStr = this.parkCacheService.getStr("park:alldev_ip");
        if (WEBSOCKETINIT && ParkWebCommonUtil.isNull(devIpStr)) {
            return;
        }
        List deviceItemAry = this.parkDeviceService.findAll();
        if (ParkWebCommonUtil.isNotNull(deviceItemAry) && sdkSession == null) {
            this.sdkService(deviceItemAry);
        }
    }

    public void sdkService(List<ParkDeviceItem> deviceItemAry) {
        List parkDisplayDeviceItemList;
        boolean connected = true;
        try {
            String uri = this.parkParamsService.getSDKURL();
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            sdkSession = container.connectToServer(ParkWebSocketSDKClient.class, new URI(uri));
            if (sdkSession != null) {
                log.info("PARK == SDK Websocket Connection Success SessionID = " + sdkSession.getId());
                this.webSocketSDKFun.setSession(sdkSession);
                this.webSocketSDKFun.setParameter("init");
            }
        }
        catch (Exception e) {
            connected = false;
            log.error("PARK == SDK Websocket Connection Failed ", (Throwable)e);
        }
        if (ParkWebCommonUtil.isNotNull(deviceItemAry)) {
            StringBuffer strBuf = new StringBuffer();
            for (ParkDeviceItem item : deviceItemAry) {
                strBuf.append(item.getIpAddress()).append(",");
                this.parkCacheService.set("park:alldev_ip", (Object)strBuf.toString(), 0L);
                String msgId = this.connDevWS(item);
                CompletableFuture.runAsync(() -> {
                    int operRet = this.parkCacheService.searchRedisByKey(msgId);
                    this.parkDeviceOpRecordService.saveItemByConnect(item, operRet);
                });
            }
        }
        if (connected && !CollectionUtil.isEmpty((Collection)(parkDisplayDeviceItemList = this.parkDisplayDeviceService.getByCondition(new ParkDisplayDeviceItem())))) {
            for (ParkDeviceItem item : parkDisplayDeviceItemList) {
                this.connectDisplayDevice((ParkDisplayDeviceItem)item, "init");
            }
            log.info("PARK == DisplayDevice Activate device status detection after connection");
            this.parkDisplayDeviceService.startDevReconnectScheduled();
        }
    }

    public Session getSDKSession() {
        if (sdkSession != null) {
            return sdkSession;
        }
        return null;
    }

    public void setSDKSession() {
        sdkSession = null;
    }

    public void setSDKPhotoSavePath() {
        this.webSocketSDKFun.setParameter("photoSavePath");
    }

    public void stopSDKWebsocketService() {
        try {
            if (this.getSDKSession() != null) {
                this.getSDKSession().close();
            }
            this.parkCacheService.dels("park:dev_handle_");
            this.parkCacheService.dels("park:view_defa_content_");
            this.parkCacheService.del("park:alldev_ip");
            this.parkCacheService.del("park:dev_info_");
            this.parkCacheService.del("park:channel_");
            this.parkCacheService.del("park:callback_voiceview_");
            this.parkCacheService.dels("park:ws_msgid_");
            this.parkCacheService.dels("park:pavilio_mode_");
            this.parkCacheService.dels("park:pavilio_status_");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String connDevWS(ParkDeviceItem deviceItem) {
        String msgId = "-1";
        JSONObject devObj = this.assembleJson(deviceItem);
        if (ParkWebCommonUtil.isNotNull(devObj)) {
            this.webSocketSDKFun.deviceOpen(devObj);
            msgId = devObj.getString("MsgId");
            log.info("PARK_DEVICE == Open The Device At Initialization IpAddress : " + deviceItem.getIpAddress() + " username : " + deviceItem.getUsername() + " password : " + deviceItem.getPassword() + " msgId : " + msgId);
        }
        return msgId;
    }

    public void reconnDevice(String devIp) {
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (ParkWebCommonUtil.isNotNull(devObj) && devObj.getString("state").equals("offLine") && devObj.getString("pavilioMode").equals("bs")) {
            JSONObject data = new JSONObject();
            data.put("DeviceType", (Object)devObj.getString("vendorsType"));
            data.put("LprDevType", (Object)devObj.getString("lprDevType"));
            data.put("IpAddr", (Object)devObj.getString("ipAddr"));
            data.put("Port", (Object)String.valueOf(devObj.getString("port")));
            data.put("UserName", (Object)devObj.getString("userName"));
            data.put("Password", (Object)devObj.getString("passWd"));
            data.put("P2PConn", (Object)devObj.getString("p2pConn"));
            data.put("DevUid", (Object)devObj.getString("devSn"));
            this.zsBuilderJson(devObj.getString("channelId"), devObj.getString("channelStatus"), data);
            JSONObject devParamJson = ParkWebCommonUtil.getBaseJson("OpenDevice");
            devParamJson.put("Data", (Object)data);
            String msgId = devParamJson.getString("MsgId");
            devObj.put("msgId", (Object)msgId);
            this.parkCacheService.setJson("park:dev_info_" + devIp, devObj, 0L);
            log.info("PARK_DEVICE == Device Reconnection IpAddr = " + devObj.getString("ipAddr") + " UserName = " + devObj.getString("userName") + " Password = " + devObj.getString("passWd") + " msgId = " + devObj.getString("msgId"));
            this.webSocketSDKFun.deviceOpen(devParamJson);
        }
    }

    private JSONObject assembleJson(ParkDeviceItem dev) {
        String isEnabled;
        String msgId = "";
        String pavilioMode = "bs";
        String pavilioIp = "";
        String channelId = "";
        String channelStatus = "";
        String parkingAreaId = "";
        JSONObject devParamJson = null;
        JSONObject data = new JSONObject();
        if (ParkWebCommonUtil.isNotNull(dev.getChannelId())) {
            ParkChannelItem channelItem = this.parkChannelService.getItemById(dev.getChannelId());
            channelId = dev.getChannelId();
            channelStatus = String.valueOf(channelItem.getState());
            parkingAreaId = channelItem.getParkingAreaId();
            ParkPavilioItem pavilioItem = this.parkPavilioService.getPavilioByChannelId(dev.getChannelId());
            pavilioIp = pavilioItem.getIpAddress();
            if (ParkConstants.PAVILIO_CS.equals(pavilioItem.getClientMode())) {
                pavilioMode = "cs";
            }
        }
        if (!pavilioMode.equals("cs")) {
            devParamJson = new JSONObject();
            data.put("DeviceType", (Object)dev.getVendorsType());
            data.put("LprDevType", (Object)(dev.getLprDeviceType() == null ? (short)0 : dev.getLprDeviceType()));
            data.put("IpAddr", (Object)dev.getIpAddress());
            data.put("Port", (Object)String.valueOf(dev.getPort()));
            data.put("UserName", (Object)dev.getUsername());
            data.put("Password", (Object)dev.getPassword());
            data.put("IsSupportCarRecog", (Object)"0");
            String sn = "";
            String isP2P = "0";
            if ("enable".equals(dev.getP2p())) {
                sn = dev.getSn();
                isP2P = "1";
            }
            data.put("DevUid", (Object)sn);
            data.put("P2PConn", (Object)isP2P);
            data.put("DetectionCar", (Object)"1");
            data.put("AntifakePlate", (Object)"1");
            data.put("RecogCarLogo", (Object)"0");
            data.put("RecogCarType", (Object)"0");
            data.put("RecogCarColor", (Object)"0");
            data.put("UnlicensedCar", (Object)"0");
            this.zsBuilderJson(channelId, channelStatus, data);
            devParamJson = ParkWebCommonUtil.getBaseJson("OpenDevice");
            devParamJson.put("Data", (Object)data);
            msgId = devParamJson.getString("MsgId");
        }
        String devIp = dev.getIpAddress();
        String string = isEnabled = dev.getStatus() == 1 ? "disable" : "enable";
        if (this.parkCacheService.exists("park:dev_info_" + devIp)) {
            JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
            long handle = devObj.getLong("handle");
            String keyStr = "park:view_defa_content_" + handle;
            if (this.parkCacheService.exists(keyStr)) {
                this.parkCacheService.del(keyStr);
            }
            if (this.parkCacheService.exists(keyStr = "park:dev_handle_" + handle)) {
                this.parkCacheService.del(keyStr);
            }
            this.parkCacheService.del("park:dev_info_" + devIp);
        }
        JSONObject devJson = new JSONObject();
        devJson.put("pavilioIp", (Object)pavilioIp);
        devJson.put("pavilioMode", (Object)pavilioMode);
        devJson.put("channelId", (Object)channelId);
        devJson.put("channelStatus", (Object)channelStatus);
        devJson.put("parkingAreaId", (Object)parkingAreaId);
        devJson.put("displayType", (Object)dev.getDisplayType());
        devJson.put("p2pConn", (Object)("enable".equals(dev.getP2p()) ? "1" : "0"));
        devJson.put("devSn", (Object)(dev.getSn() == null ? "" : dev.getSn()));
        devJson.put("ipAddr", (Object)dev.getIpAddress());
        devJson.put("port", (Object)dev.getPort());
        devJson.put("userName", (Object)dev.getUsername());
        devJson.put("passWd", (Object)dev.getPassword());
        devJson.put("enabled", (Object)isEnabled);
        devJson.put("handle", (Object)"0");
        devJson.put("state", (Object)"offLine");
        devJson.put("serialHand", (Object)"");
        devJson.put("vendorsType", (Object)dev.getVendorsType());
        devJson.put("carTeamSignal", (Object)false);
        devJson.put("lprDevType", (Object)(dev.getLprDeviceType() == null ? (short)0 : dev.getLprDeviceType()));
        devJson.put("msgId", (Object)msgId);
        this.parkCacheService.setJson("park:dev_info_" + devIp, devJson, 0L);
        return devParamJson;
    }

    public int addDevice(ParkDeviceItem item) {
        this.parkParamsService.setIP(item.getIpAddress());
        String msgId = this.connDevWS(item);
        int operRet = this.parkCacheService.searchRedisByKey(msgId);
        this.parkDeviceOpRecordService.saveItemByConnect(item, operRet);
        return operRet;
    }

    public String getFunlist(long handle) {
        return this.webSocketSDKFun.getFunlist(handle);
    }

    public String getDevVerInfo(long handle) {
        return this.webSocketSDKFun.getDevVerInfo(handle);
    }

    public boolean editDevice(String devIP, ParkDeviceItem item) {
        boolean ret = false;
        if (this.delDevice(devIP)) {
            this.addDevice(item);
            ret = true;
        }
        return ret;
    }

    public boolean delDevice(String devIp) {
        boolean ret = true;
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (ParkWebCommonUtil.isNotNull(devObj)) {
            String devHandle = devObj.getString("handle");
            if ("onLine".equals(devObj.get((Object)"state")) && ParkWebCommonUtil.isNotNull(devHandle)) {
                String msgId = this.webSocketSDKFun.deviceClose(Long.valueOf(devHandle));
                int operRet = this.parkCacheService.searchRedisByKey(msgId);
                ParkDeviceItem parkDeviceItem = this.parkDeviceService.getByIpAddress(devIp);
                this.parkDeviceOpRecordService.saveItemByClose(parkDeviceItem, operRet);
            }
            this.parkParamsService.delIP(devIp);
            String handleStr = "park:dev_handle_" + devObj.getString("handle");
            if (this.parkCacheService.exists(handleStr)) {
                this.parkCacheService.del(handleStr);
            }
            this.parkCacheService.del("park:dev_info_" + devIp);
        }
        return ret;
    }

    public int enableDevice(String devIp) {
        int ret = -1;
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (ParkWebCommonUtil.isNotNull(devObj)) {
            String handle = devObj.getString("handle");
            String msgId = this.webSocketSDKFun.isDeviceConnected(Long.valueOf(handle));
            ret = this.parkCacheService.searchRedisByKey(msgId);
            if (devObj.getString("enabled").equals("disable") && ret != -10001) {
                if (ret < 0) {
                    ParkDeviceItem parkDevice = this.parkDeviceService.getByIpAddress(devIp);
                    parkDevice.setStatus(ParkConstants.ENABLED);
                    ret = this.addDevice(parkDevice);
                } else {
                    devObj.put("enabled", (Object)"enable");
                    devObj.put("state", (Object)"onLine");
                    this.parkCacheService.setJson("park:dev_info_" + devIp, devObj, 0L);
                }
            }
        }
        return ret;
    }

    public int disableDevice(String devIp) {
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (ParkWebCommonUtil.isNotNull(devObj) && devObj.getString("enabled").equals("enable")) {
            devObj.put("enabled", (Object)"disable");
            this.parkCacheService.setJson("park:dev_info_" + devIp, devObj, 0L);
        }
        return 0;
    }

    public int deviceClose(long handle) {
        String msgId = this.webSocketSDKFun.deviceClose(handle);
        int ret = this.parkCacheService.searchRedisByKey(msgId);
        return ret;
    }

    public int setDeviceTime(String devIp) {
        int ret = 0;
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (ParkWebCommonUtil.isNotNull(devObj)) {
            long handle = Long.valueOf(devObj.getString("handle"));
            SimpleDateFormat dateformat = new SimpleDateFormat(DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
            String newTime = dateformat.format(new Date());
            String msgId = this.webSocketSDKFun.setDateTime(handle, newTime);
            ret = this.parkCacheService.searchRedisByKey(msgId);
        }
        return ret;
    }

    public int syncParams(String paramObj) {
        int ret = 0;
        if (this.webSocketSDKFun.getSession() != null) {
            String msgId = this.webSocketSDKFun.setOfflineParam(paramObj);
            ret = this.parkCacheService.searchRedisByKey(msgId);
        }
        return ret;
    }

    public int syncCharging(String paramObj) {
        int ret = 0;
        if (this.webSocketSDKFun.getSession() != null) {
            String msgId = this.webSocketSDKFun.setDeviceData(paramObj);
            ret = this.parkCacheService.searchRedisByKey(msgId);
        }
        return ret;
    }

    public String readParams(String paramObj) {
        String msgId = "-1";
        if (this.webSocketSDKFun.getSession() != null) {
            msgId = this.webSocketSDKFun.getOfflineParam(paramObj);
        }
        return msgId;
    }

    public String readPlateList(String paramObj) {
        String msgId = "-1";
        if (this.webSocketSDKFun.getSession() != null) {
            msgId = this.webSocketSDKFun.exportPlateList(paramObj);
        }
        return msgId;
    }

    public String getDeviceData(String paramObj) {
        String msgId = "-1";
        if (this.webSocketSDKFun.getSession() != null) {
            msgId = this.webSocketSDKFun.getDeviceData(paramObj);
        }
        return msgId;
    }

    public String readVersion() {
        String msgId = "-1";
        if (this.webSocketSDKFun.getSession() != null) {
            msgId = this.webSocketSDKFun.getSysInfo();
        }
        return msgId;
    }

    public String getDeviceDataCount(long handle, int type, int offset) {
        String msgId = "-1";
        if (this.webSocketSDKFun.getSession() != null) {
            JSONObject params = new JSONObject();
            params.put("Handle", (Object)handle);
            params.put("Type", (Object)type);
            params.put("Offset", (Object)offset);
            msgId = this.webSocketSDKFun.getDeviceDataCount(params);
        }
        return msgId;
    }

    public int cleanCharging(String paramObj) {
        int ret = 0;
        if (this.webSocketSDKFun.getSession() != null) {
            String msgId = this.webSocketSDKFun.clearDeviceData(paramObj);
            ret = this.parkCacheService.searchRedisByKey(msgId);
        }
        return ret;
    }

    public int resetFactory(String paramObj) {
        int ret = 0;
        if (this.webSocketSDKFun.getSession() != null) {
            String msgId = this.webSocketSDKFun.resetFactory(paramObj);
            ret = this.parkCacheService.searchRedisByKey(msgId);
        }
        return ret;
    }

    public void searchDev() {
        this.webSocketSDKFun.startFindDevice();
        this.parkDeviceComm.searchDev();
    }

    public void stopSearchDev() {
        this.webSocketSDKFun.stopFindDevice();
    }

    public int openChannelGate(String devIp, long handle, int chnId) {
        int ret = 0;
        if (StringUtils.isNotBlank((CharSequence)devIp)) {
            JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
            String pavilioMode = devObj.getString("pavilioMode");
            if ("bs".equals(pavilioMode)) {
                if ("onLine".equals(devObj.get((Object)"state"))) {
                    String msgId = this.webSocketSDKFun.openChannelGate(handle, chnId);
                    ret = this.parkCacheService.searchRedisByKey(msgId);
                } else {
                    ret = -1;
                }
            } else {
                String comm = this.parkDeviceComm.openGate(devIp, chnId);
                String pavilioIp = devObj.getString("pavilioIp");
                this.channelService.single(pavilioIp, comm);
            }
        }
        return ret;
    }

    public int saveSnapImageToJpeg(long handle, String filePathName) {
        int ret = 0;
        String msgId = this.webSocketSDKFun.saveSnapImage(handle, filePathName);
        ret = this.parkCacheService.searchRedisByKey(msgId);
        return ret;
    }

    public void sendMsg(String devIp, byte[] msg, int opType) {
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (ParkWebCommonUtil.isNotNull(devObj)) {
            String pavilioMode = devObj.getString("pavilioMode");
            if ("bs".equals(pavilioMode)) {
                if ("onLine".equals(devObj.get((Object)"state"))) {
                    this.webSocketSDKFun.serialSend(devObj.getLong("serialHand"), msg);
                }
            } else {
                String comm = this.parkDeviceComm.serialSend(devIp, msg, opType);
                String pavilioIp = devObj.getString("pavilioIp");
                this.channelService.single(pavilioIp, comm);
            }
        }
    }

    public int sendBlackWhites(long handle, int t, List<ParkBlackWhiteItem> blackWhiteItemAry, String opType) {
        if ("zh_CN".equals(LocaleMessageSourceUtil.language)) {
            int size = blackWhiteItemAry.size() * 24;
            int npos = 0;
            byte[] buffer = new byte[size];
            ZKLprBlackWhite zkBW = new ZKLprBlackWhite();
            for (ParkBlackWhiteItem blackWhite : blackWhiteItemAry) {
                zkBW = this.putCarNumber(blackWhite.getCarNumber(), blackWhite.getStartTime(), blackWhite.getEndTime());
                zkBW.Packet(buffer, npos);
                npos += 24;
            }
            String msgId = this.webSocketSDKFun.sendPlateList(handle, t, buffer, blackWhiteItemAry.size(), opType);
            return this.parkCacheService.searchRedisByKey(msgId);
        }
        int ret = 0;
        if ("ImportPlateList".equals(opType)) {
            ret = this.sendBlackWhitesForeign(handle, t, blackWhiteItemAry, "ClearPlateListExt");
            opType = "AddPlateListExt";
        } else {
            opType = opType + "Ext";
        }
        if (ret >= 0 && blackWhiteItemAry != null && !blackWhiteItemAry.isEmpty()) {
            ret = this.sendBlackWhitesForeign(handle, t, blackWhiteItemAry, opType);
        }
        return ret;
    }

    private int sendBlackWhitesForeign(long handle, int t, List<ParkBlackWhiteItem> parkBlackWhites, String opType) {
        ArrayList<JSONObject> plateInfos = new ArrayList<JSONObject>();
        if (ParkWebCommonUtil.isNotNull(parkBlackWhites)) {
            try {
                for (ParkBlackWhiteItem parkBlackWhiteItem : parkBlackWhites) {
                    JSONObject plateInfo = new JSONObject();
                    plateInfo.put("Plate", (Object)parkBlackWhiteItem.getCarNumber());
                    plateInfo.put("Name", (Object)"");
                    if (t == 0) {
                        SimpleDateFormat sdf = new SimpleDateFormat(DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                        plateInfo.put("FromDate", (Object)sdf.format(parkBlackWhiteItem.getStartTime()).split(" ")[0]);
                        plateInfo.put("ToDate", (Object)sdf.format(parkBlackWhiteItem.getEndTime()).split(" ")[0]);
                    } else {
                        plateInfo.put("FromDate", (Object)"0-0-0");
                        plateInfo.put("ToDate", (Object)"0-0-0");
                    }
                    plateInfos.add(plateInfo);
                }
            }
            catch (Exception exception) {
                log.error("sendAuthorizesForeign", (Throwable)exception);
            }
        }
        String msgId = this.webSocketSDKFun.sendPlateListForeign(handle, t, plateInfos, parkBlackWhites.size(), opType);
        return this.parkCacheService.searchRedisByKey(msgId);
    }

    public int sendAuthorizes(long handle, List<ParkAuthorizeItem> parkAuthorizes, String type) {
        if ("zh_CN".equals(LocaleMessageSourceUtil.language)) {
            int size = parkAuthorizes.size() * 24;
            int carNumSize = parkAuthorizes.size();
            int npos = 0;
            byte[] buffer = new byte[size];
            ZKLprBlackWhite zkBW = new ZKLprBlackWhite();
            for (ParkAuthorizeItem parkAuthorize : parkAuthorizes) {
                zkBW = this.putCarNumber(parkAuthorize.getCarNumber(), parkAuthorize.getStartTime(), parkAuthorize.getEndTime());
                zkBW.Packet(buffer, npos);
                npos += 24;
            }
            String msgId = this.webSocketSDKFun.sendPlateList(handle, ParkConstants.OPEN_TYPE_AUTH.shortValue(), buffer, carNumSize, type);
            return this.parkCacheService.searchRedisByKey(msgId);
        }
        int ret = 0;
        if ("ImportPlateList".equals(type)) {
            ret = this.sendAuthorizesForeign(handle, parkAuthorizes, "ClearPlateListExt");
            type = "AddPlateListExt";
        } else {
            type = type + "Ext";
        }
        if (ret >= 0 && parkAuthorizes != null && !parkAuthorizes.isEmpty()) {
            ret = this.sendAuthorizesForeign(handle, parkAuthorizes, type);
        }
        return ret;
    }

    private int sendAuthorizesForeign(long handle, List<ParkAuthorizeItem> parkAuthorizes, String opType) {
        ArrayList<JSONObject> plateInfos = new ArrayList<JSONObject>();
        if (ParkWebCommonUtil.isNotNull(parkAuthorizes)) {
            try {
                for (ParkAuthorizeItem parkAuthorizeItem : parkAuthorizes) {
                    JSONObject plateInfo = new JSONObject();
                    String carNumber = this.parkCarNumberService.getCarNumByAuthId(parkAuthorizeItem.getId());
                    plateInfo.put("Plate", (Object)carNumber);
                    plateInfo.put("Name", (Object)(ParkWebCommonUtil.isNotNull(parkAuthorizeItem.getPersonName()) ? parkAuthorizeItem.getPersonName() : ""));
                    SimpleDateFormat sdf = new SimpleDateFormat(DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                    plateInfo.put("FromDate", (Object)sdf.format(parkAuthorizeItem.getStartTime()).split(" ")[0]);
                    plateInfo.put("ToDate", (Object)sdf.format(parkAuthorizeItem.getEndTime()).split(" ")[0]);
                    plateInfos.add(plateInfo);
                }
            }
            catch (Exception exception) {
                log.error("sendAuthorizesForeign", (Throwable)exception);
            }
        }
        String msgId = this.webSocketSDKFun.sendPlateListForeign(handle, ParkConstants.OPEN_TYPE_AUTH.shortValue(), plateInfos, parkAuthorizes.size(), opType);
        return this.parkCacheService.searchRedisByKey(msgId);
    }

    private ZKLprBlackWhite putCarNumber(String carNumber, Date startTime, Date endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat(DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        ZKLprBlackWhite zkBW = new ZKLprBlackWhite();
        try {
            byte[] carNo = carNumber.getBytes("gb2312");
            byte[] license = new byte[16];
            for (int i = 0; i < carNo.length; ++i) {
                license[i] = carNo[i];
            }
            zkBW.szLicense = license;
            if (ParkWebCommonUtil.isNotNull(startTime)) {
                String startStr = sdf.format(startTime);
                String[] stratTime = startStr.split(" ");
                zkBW.fromDate.nYear = Short.parseShort(stratTime[0].split("-")[0]);
                zkBW.fromDate.nMonth = (char)Integer.parseInt(stratTime[0].split("-")[1]);
                zkBW.fromDate.nDay = (char)Integer.parseInt(stratTime[0].split("-")[2]);
            }
            if (ParkWebCommonUtil.isNotNull(endTime)) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(endTime);
                String endStr = sdf.format(calendar.getTime());
                String[] endTimeAry = endStr.split(" ");
                zkBW.toDate.nYear = Short.parseShort(endTimeAry[0].split("-")[0]);
                zkBW.toDate.nMonth = (char)Integer.parseInt(endTimeAry[0].split("-")[1]);
                zkBW.toDate.nDay = (char)Integer.parseInt(endTimeAry[0].split("-")[2]);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return zkBW;
    }

    public String getCarTeamSignal(long handle) {
        String msgId = this.webSocketSDKFun.getCarTeamSignal(handle);
        return msgId;
    }

    public int setCarTeamSignal(long handle, int signal) {
        String msgId = this.webSocketSDKFun.setCarTeamSignal(handle, signal);
        return this.parkCacheService.searchRedisByKey(msgId);
    }

    public void sendCommandNew(String devIp, String license, String displayCont, String voiceCont) {
        try {
            long handle;
            if (StringUtils.isNotBlank((CharSequence)voiceCont)) {
                byte[] codeByte = this.park485Protocol.getVoiceByteByCode(voiceCont);
                this.park485Protocol.sendVoice177(codeByte, devIp);
                Thread.sleep(200L);
            }
            if (ParkWebCommonUtil.isNotNull(handle = this.parkSendCmd.getHandle(devIp)) && handle != 0L) {
                Timestamp nowTime = new Timestamp(System.currentTimeMillis());
                Timestamp newTime = ParkWebCommonUtil.pastTime(nowTime, 0, -20);
                String handleStr = "park:view_defa_content_" + handle;
                if (this.parkCacheService.exists(handleStr)) {
                    this.parkCacheService.set(handleStr, (Object)String.valueOf(newTime.getTime()), 0L);
                    this.park485Protocol.setRealTimeDisplay174(license, displayCont, devIp);
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendCommandNewFor4Lines(String devIp, String license, String displayCont, String voiceCont) {
        try {
            long handle;
            if (StringUtils.isNotBlank((CharSequence)voiceCont)) {
                byte[] codeByte = this.park485Protocol.getVoiceByteByCode(voiceCont);
                this.park485Protocol.sendVoice177For4Lines(codeByte, devIp);
                Thread.sleep(200L);
            }
            if (ParkWebCommonUtil.isNotNull(handle = this.parkSendCmd.getHandle(devIp)) && handle != 0L) {
                Timestamp nowTime = new Timestamp(System.currentTimeMillis());
                Timestamp newTime = ParkWebCommonUtil.pastTime(nowTime, 0, -20);
                String handleStr = "park:view_defa_content_" + handle;
                if (this.parkCacheService.exists(handleStr)) {
                    this.parkCacheService.set(handleStr, (Object)String.valueOf(newTime.getTime()), 0L);
                    String companyName = this.parkParamsService.getCompanyName();
                    String viewCode = this.parkParamsService.getViewCode();
                    String currTime = ParkViewEnum.getFormatTime((String)viewCode);
                    this.park485Protocol.setRealTimeDisplay174For4Lines(companyName, currTime, license, displayCont, devIp);
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendCommandOld(String devIp, String license, String displayCont, String voiceCont) {
        try {
            if (StringUtils.isNotBlank((CharSequence)voiceCont)) {
                this.parkSendCmd.voiceInfo(voiceCont, devIp);
                Thread.sleep(200L);
            }
            this.parkSendCmd.viewInfo(license, displayCont, devIp);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void startVoiceAndViewThread() {
        if (Objects.isNull(voiceAndViewThread) || !voiceAndViewThread.isAlive()) {
            voiceAndViewThread = new VoiceAndViewThread("ParkVoiceAndViewThread");
            voiceAndViewThread.start();
        }
    }

    public void totalParkingSpaces() {
        boolean isFixedStatistical = this.parkParamsService.isFixedStatistical();
        List fieldList = null;
        fieldList = isFixedStatistical ? this.parkParkingAreaService.getOnSiteCarCount() : this.parkParkingAreaService.getOnSiteTempCarCount();
        this.statisticsParkingSpaces(fieldList);
    }

    public void totalParkingSpacesByAreaId(String parkingAreaId) {
        boolean isFixedStatistical = this.parkParamsService.isFixedStatistical();
        ArrayList<Object[]> fieldList = new ArrayList<Object[]>();
        if (isFixedStatistical) {
            int count = this.parkRecordinService.getCountByParkAreaId(parkingAreaId);
            Object[] object = new Object[]{parkingAreaId, count + ""};
            fieldList.add(object);
        } else {
            int count = this.parkRecordinService.getCountByParkAreaIdAndCarType(parkingAreaId, ParkConstants.CAR_TYPE_TEMP);
            Object[] object = new Object[]{parkingAreaId, count + ""};
            fieldList.add(object);
        }
        this.statisticsParkingSpaces(fieldList);
    }

    private void statisticsParkingSpaces(List<Object[]> fieldList) {
        block16: {
            boolean isShowSmallParkingLot;
            block15: {
                boolean isFixedStatistical = this.parkParamsService.isFixedStatistical();
                isShowSmallParkingLot = this.parkParamsService.isShowSmallParkingLot();
                if (!CollectionUtils.isNotEmpty(fieldList) || fieldList.size() <= 0) break block15;
                List parkParkingAreaItemList = this.parkParkingAreaService.getByCondition(new ParkParkingAreaItem());
                Map parkParkingAreaItemMap = CollectionUtil.listToKeyMap((Collection)parkParkingAreaItemList, ParkParkingAreaItem::getId);
                boolean isDisplayParkingSpace = this.parkParamsService.isDisplayParkingSpace();
                for (Object[] field : fieldList) {
                    List parkParkingAreaAry;
                    String areaId = field[0].toString();
                    ParkParkingAreaItem parkingArea = (ParkParkingAreaItem)parkParkingAreaItemMap.get(areaId);
                    int authCount = 0;
                    int smallSurplusCount = 0;
                    int smallParkingLot = 0;
                    int smallAuthCount = 0;
                    String recordinCount = field[1].toString();
                    if (isDisplayParkingSpace) {
                        authCount = this.parkParkingSpaceService.getCountByAreaIdAndStatus(areaId, ParkConstants.PARKINGSPACE_USED);
                    } else if (!isFixedStatistical) {
                        authCount = this.parkAuthorizeService.getValidAuthCountByAreaId(areaId);
                    }
                    if (isShowSmallParkingLot && parkingArea.getAreaType().equals(ParkConstants.PARKAREA_BIG)) {
                        List parkParkingAreaAry2 = this.parkParkingAreaService.getSmallParkingAreaByMaxParkingAreaId(parkingArea.getId());
                        if (ParkWebCommonUtil.isNotNull(parkParkingAreaAry2)) {
                            for (ParkParkingAreaItem parkParkingArea : parkParkingAreaAry2) {
                                Object recordinAry = null;
                                int authCountSmall = 0;
                                int recordinCountSmall = 0;
                                smallParkingLot += parkParkingArea.getParkingLot().intValue();
                                if (isFixedStatistical) {
                                    recordinCountSmall = this.parkRecordinService.getCountByParkAreaId(parkParkingArea.getId());
                                } else {
                                    recordinCountSmall = this.parkRecordinService.getCountByParkAreaIdAndCarType(parkParkingArea.getId(), ParkConstants.CAR_TYPE_TEMP);
                                    if (isDisplayParkingSpace) {
                                        authCountSmall = this.parkParkingSpaceService.getCountByAreaIdAndStatus(parkParkingArea.getId(), ParkConstants.PARKINGSPACE_USED);
                                    }
                                }
                                int surplusCountSmall = parkParkingArea.getParkingLot() - recordinCountSmall - authCountSmall;
                                smallSurplusCount += surplusCountSmall;
                            }
                        }
                    } else if (parkingArea.getAreaType().equals(ParkConstants.PARKAREA_BIG) && !isShowSmallParkingLot && ParkWebCommonUtil.isNotNull(parkParkingAreaAry = this.parkParkingAreaService.getSmallParkingAreaByMaxParkingAreaId(parkingArea.getId()))) {
                        List samllareaIds = parkParkingAreaAry.stream().map(ParkParkingAreaItem2 -> ParkParkingAreaItem2.getId()).collect(Collectors.toList());
                        smallAuthCount = this.parkAuthorizeService.getValidAuthCountByAreaIds(samllareaIds);
                        authCount -= smallAuthCount;
                    }
                    int surplusCount = parkingArea.getParkingLot() + smallSurplusCount - Integer.valueOf(recordinCount) - authCount;
                    this.parkCacheService.set("park:areaid_" + areaId, (Object)(surplusCount + ""), 0L);
                    this.parkCacheService.set("park:parkingLot_" + areaId, (Object)(parkingArea.getParkingLot() + smallParkingLot), 0L);
                    this.parkRecordinService.sendMsgFreeParkingSpace(areaId);
                }
                break block16;
            }
            List areaList = this.parkParkingAreaService.getAllParkingAreaExt();
            if (!ParkWebCommonUtil.isNotNull(areaList)) break block16;
            for (ParkParkingAreaItem area : areaList) {
                List parkParkingAreaAry;
                String areaId = area.getId();
                int smallParkingLot = 0;
                if (isShowSmallParkingLot && area.getAreaType().equals(ParkConstants.PARKAREA_BIG) && ParkWebCommonUtil.isNotNull(parkParkingAreaAry = this.parkParkingAreaService.getSmallParkingAreaByMaxParkingAreaId(areaId))) {
                    for (ParkParkingAreaItem parkParkingArea : parkParkingAreaAry) {
                        smallParkingLot += parkParkingArea.getParkingLot().intValue();
                    }
                }
                this.parkCacheService.set("park:areaid_" + areaId, (Object)area.getParkingLot().toString(), 0L);
                this.parkCacheService.set("park:parkingLot_" + areaId, (Object)(area.getParkingLot() + smallParkingLot), 0L);
                this.parkRecordinService.sendMsgFreeParkingSpace(areaId);
            }
        }
    }

    public void sendWebsocketMsg(String pavilioIP, ParkCheckOutInfo cheOutInfo) {
        cheOutInfo.setPavilioIP(pavilioIP);
        String comm = this.parkCSPavilioMsg.sendMsgToPavilio(cheOutInfo.getMsgType(), cheOutInfo);
        if (ParkWebCommonUtil.isNotNull(pavilioIP)) {
            boolean isCsClient = this.parkDeviceService.isCsClient(cheOutInfo.getIpAddress());
            if (isCsClient) {
                this.channelService.single(pavilioIP, comm);
            }
            this.messagingTemplate.convertAndSend((Object)("/topic/parkTerminalManage/message/" + pavilioIP), (Object)comm);
            if (cheOutInfo.getMsgType().equals("carInfo")) {
                if (isCsClient) {
                    this.channelService.broadcast("manager", comm);
                }
                this.messagingTemplate.convertAndSend((Object)"/topic/parkMonitorRoom/message", (Object)comm);
            }
        } else {
            List parkPavilioItemList = this.parkPavilioService.getByCondition(new ParkPavilioItem());
            for (ParkPavilioItem parkPavilioItem : parkPavilioItemList) {
                this.channelService.single(parkPavilioItem.getIpAddress(), comm);
                this.messagingTemplate.convertAndSend((Object)("/topic/parkTerminalManage/message/" + parkPavilioItem.getIpAddress()), (Object)comm);
            }
        }
    }

    public String getNumberCodeByUnit(BigDecimal num, int type) {
        return this.park485Protocol.getNumberCodeByUnit(num, type);
    }

    public String getAscllMoney(double money) {
        return this.parkSendCmd.getAscllMoney(money);
    }

    public String isDeviceConnected(long handle) {
        return this.webSocketSDKFun.isDeviceConnected(handle);
    }

    public void syncDeviceToCS(String pavilioIp, ParkDeviceItem item) {
        this.parkCSPavilioMsg.syncDeviceInfoToCS(pavilioIp, item);
    }

    public void syncChannelToCS(String pavilioIp, ParkChannelItem channelItem, String opType) {
        this.parkCSPavilioMsg.syncChannelInfoToCS(pavilioIp, channelItem, opType);
    }

    public void syncReleaToCS(String id, String name, String opType) {
        this.parkCSPavilioMsg.syncReleaInfoToCS(id, name, opType);
    }

    public void syncCarTypeToCS(String id, String name, Short carType, Short flag, String opType) {
        this.parkCSPavilioMsg.syncTempCarTypeToCS(id, name, carType, flag, opType);
    }

    public void syncShopToCS(String shopId, String shopName, List<ParkDiscountStrategyItem> discountAry, String opType) {
        this.parkCSPavilioMsg.syncShopInfo(shopId, shopName, discountAry, opType);
    }

    public void delPavilioToCS(String pavilioIp, String msg) {
        this.parkCSPavilioMsg.delPavilioToCS(pavilioIp, msg);
    }

    public void syncPavilioToCS(String pavilioIp) {
        this.parkCSPavilioMsg.syncPavilioInfoToCS(pavilioIp, false);
    }

    public void syncParamsToCS(String pavilioIp) {
        this.parkCSPavilioMsg.syncParkingSetInfoToCS(pavilioIp);
    }

    public String syncOfflineParams(String pavilioIp, String deviceIp, String paramObj) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("setOfflineParam");
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("params", JSONObject.parse((String)paramObj));
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String syncOfflineTime(String pavilioIp, String deviceIp) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("setDateTime");
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("dateTime", (Object)System.currentTimeMillis());
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String getParameter(String pavilioIp, String deviceIp) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("getDeviceFunList");
        msg.setData(deviceIp);
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String getDevVerInfo(String pavilioIp, String deviceIp) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("getDevVerInfo");
        msg.setData(deviceIp);
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String syncOfflineChargeParam(String pavilioIp, String deviceIp, String paramStr) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("setDeviceData");
        JSONObject paramObj = JSONObject.parseObject((String)paramStr);
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("type", (Object)paramObj.getInteger("Type"));
        data.put("count", (Object)paramObj.getInteger("Count"));
        data.put("dataBuf", (Object)paramObj.getString("DataBuf"));
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String syncOfflineBlackWhites(String pavilioIp, String deviceIp, int type, List<ParkBlackWhiteItem> blackWhiteItemAry, String opType) {
        int size = blackWhiteItemAry.size() * 24;
        int npos = 0;
        byte[] buffer = new byte[size];
        ZKLprBlackWhite zkBW = new ZKLprBlackWhite();
        for (ParkBlackWhiteItem blackWhite : blackWhiteItemAry) {
            zkBW = this.putCarNumber(blackWhite.getCarNumber(), blackWhite.getStartTime(), blackWhite.getEndTime());
            zkBW.Packet(buffer, npos);
            npos += 24;
        }
        String base64Str = Base64Util.encode((byte[])buffer);
        base64Str = base64Str.replaceAll("[\\s*\r\n]", "");
        ParkWebsocketMsg msg = new ParkWebsocketMsg(opType);
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("type", (Object)type);
        data.put("count", (Object)blackWhiteItemAry.size());
        data.put("plateList", (Object)base64Str);
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String syncOfflineAuth(String pavilioIp, String deviceIp, List<ParkAuthorizeItem> parkAuthorizes, String opType) {
        int size = 0;
        int carNumSize = 0;
        String mode = this.parkParamsService.getParkingLotModel();
        if (ParkWebCommonUtil.isNotNull(mode) && "many".equalsIgnoreCase(mode)) {
            for (ParkAuthorizeItem parkAuthorize : parkAuthorizes) {
                Set carNumSet = this.parkCarNumberService.getByAuthorId(parkAuthorize.getId());
                size += carNumSet.size() * 24;
                carNumSize += carNumSet.size();
            }
        } else {
            size += parkAuthorizes.size() * 24;
            carNumSize += parkAuthorizes.size();
        }
        int npos = 0;
        byte[] buffer = new byte[size];
        ZKLprBlackWhite zkBW = new ZKLprBlackWhite();
        String carNum = "";
        for (ParkAuthorizeItem parkAuthorize : parkAuthorizes) {
            if (ParkWebCommonUtil.isNotNull(mode) && "many".equalsIgnoreCase(mode)) {
                Set carNumItemSet = this.parkCarNumberService.getByAuthorId(parkAuthorize.getId());
                for (ParkCarNumberItem carNumItem : carNumItemSet) {
                    zkBW = this.putCarNumber(carNumItem.getCarNumber(), parkAuthorize.getStartTime(), parkAuthorize.getEndTime());
                    zkBW.Packet(buffer, npos);
                    npos += 24;
                }
                continue;
            }
            zkBW = this.putCarNumber(parkAuthorize.getCarNumber(), parkAuthorize.getStartTime(), parkAuthorize.getEndTime());
            zkBW.Packet(buffer, npos);
            npos += 24;
        }
        String base64Str = Base64Util.encode((byte[])buffer);
        base64Str = base64Str.replaceAll("[\\s*\r\n]", "");
        ParkWebsocketMsg msg = new ParkWebsocketMsg(opType);
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("type", (Object)ParkConstants.OPEN_TYPE_AUTH);
        data.put("count", (Object)carNumSize);
        data.put("plateList", (Object)base64Str);
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String getOfflineDeviceData(String pavilioIp, String deviceIp, int offset, int type, String funId) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg(funId);
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        if (!funId.equals("getDeviceData")) {
            data.put("type", (Object)type);
            data.put("offset", (Object)offset);
        }
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String getOfflineParam(String pavilioIp, String deviceIp) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("getOfflineParam");
        msg.setData(deviceIp);
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String getOfflinePlateList(String pavilioIp, String deviceIp, int type, int total) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("getOfflinePlateList");
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("type", (Object)type);
        data.put("count", (Object)total);
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String clearOfflineDeviceData(String pavilioIp, String deviceIp, int type, String opType) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg(opType);
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("type", (Object)type);
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public void resetFactoryWithOffline(String pavilioIp, String deviceIp, int type) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("resetFactoryWithOffline");
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("type", (Object)type);
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
    }

    public int connectDisplayDevice(ParkDisplayDeviceItem item, String type) {
        String msgId;
        int ret;
        JSONObject data = new JSONObject();
        data.put("IP", (Object)item.getIpAddress());
        data.put("CardType", (Object)"21");
        data.put("NetPort", (Object)"5005");
        data.put("ColorStyle", (Object)"1");
        data.put("ScreemHeight", (Object)32);
        data.put("ScreemWidth", (Object)128);
        JSONObject devInfo = this.parkCacheService.getJson("park:displaydev_info_" + item.getIpAddress());
        if (devInfo == null) {
            devInfo = new JSONObject((Map)data);
            devInfo.put("LineType", (Object)item.getLineType());
            devInfo.put("AreaId", (Object)item.getParkParkingAreaId());
            devInfo.put("Status", (Object)"offline");
            devInfo.put("ScreemNum", (Object)-1);
        }
        if ((ret = this.parkCacheService.searchRedisByKey(msgId = this.webSocketSDKFun.connectDisplayDevice("Park_EQ2013", data))) >= 0) {
            devInfo.put("Status", (Object)"online");
            devInfo.put("ScreemNum", (Object)ret);
        }
        if ("init".equals(type)) {
            this.parkCacheService.setJson("park:displaydev_info_" + item.getIpAddress(), devInfo, 0L);
            if (ret >= 0) {
                JSONObject close = new JSONObject();
                close.put("ScreemNum", (Object)ret);
                this.webSocketSDKFun.closeDisplayDevice("Park_EQ2013", close);
                this.totalParkingSpacesByAreaId(item.getParkParkingAreaId());
            }
        } else if (ret >= 0) {
            this.parkCacheService.setJson("park:displaydev_info_" + item.getIpAddress(), devInfo, 0L);
            if ("reconnect".equals(type)) {
                this.parkRecordinService.sendMsgFreeParkingSpace(item.getParkParkingAreaId());
            }
        }
        return ret;
    }

    public int sentDoubleLineDisplay(String ipAddress, String firstLine, String secondLine) {
        String screemNum = this.getScreemNum(ipAddress);
        if (Integer.valueOf(screemNum) > 0) {
            if (this.parkParamsService.printParkLogger()) {
                log.info("PARK_DISPALY_DEVICE_SENT firstLine = " + firstLine + " secondLine = " + secondLine);
            }
            JSONObject firstLineData = this.getSentData(screemNum, firstLine, 0);
            this.webSocketSDKFun.sentDisplayData("Park_EQ2013", firstLineData);
            JSONObject secondLineData = this.getSentData(screemNum, secondLine, 1);
            this.webSocketSDKFun.sentDisplayData("Park_EQ2013", secondLineData);
            return 0;
        }
        return -1;
    }

    public int sentSingleLineDisplay(String ipAddress, String content) {
        String screemNum = this.getScreemNum(ipAddress);
        if (Integer.valueOf(screemNum) > 0) {
            if (this.parkParamsService.printParkLogger()) {
                log.info("PARK_DISPALY_DEVICE_SENT firstLine = " + content);
            }
            JSONObject data = this.getSentData(screemNum, content, 2);
            this.webSocketSDKFun.sentDisplayData("Park_EQ2013", data);
            return 0;
        }
        return -1;
    }

    public int closeDisplayDevice(String ipAddress) {
        this.parkCacheService.del("park:displaydev_info_" + ipAddress);
        String screemNum = this.getScreemNum(ipAddress);
        if (Integer.valueOf(screemNum) > 0) {
            JSONObject data = new JSONObject();
            data.put("ScreemNum", (Object)screemNum);
            String msgId = this.webSocketSDKFun.closeDisplayDevice("Park_EQ2013", data);
            return this.parkCacheService.searchRedisByKey(msgId);
        }
        return -1;
    }

    private JSONObject getSentData(String screemNum, String text, int type) {
        JSONObject data = new JSONObject();
        data.put("ScreemNum", (Object)screemNum);
        data.put("Text", (Object)text);
        data.put("FontBold", (Object)0);
        data.put("FontItaic", (Object)0);
        data.put("FontUnderline", (Object)0);
        data.put("ColorFont", (Object)"0xFF");
        data.put("FontName", (Object)"\u5b8b\u4f53");
        data.put("AlignStyle", (Object)1);
        data.put("VAlignerStyle", (Object)1);
        data.put("RowSpace", (Object)0);
        data.put("Width", (Object)128);
        data.put("PosX", (Object)0);
        int fontSize = 10;
        int posY = 0;
        int height = 16;
        if (type == 1) {
            posY = height;
        } else if (type == 2) {
            fontSize = 13;
            height = 32;
        }
        data.put("PosY", (Object)posY);
        data.put("Height", (Object)height);
        data.put("FontSize", (Object)fontSize);
        return data;
    }

    public int getDisplayDeviceStatus(String ipAddress) {
        String screemNum = this.getScreemNum(ipAddress);
        if (Integer.valueOf(screemNum) > 0) {
            JSONObject data = new JSONObject();
            data.put("ScreemNum", (Object)screemNum);
            String msgId = this.webSocketSDKFun.getDisplayDeviceStatus("Park_EQ2013", data);
            return this.parkCacheService.searchRedisByKey(msgId);
        }
        return -1;
    }

    private String getScreemNum(String ipAddress) {
        String screemNum = "-1";
        JSONObject devInfo = this.parkCacheService.getJson("park:displaydev_info_" + ipAddress);
        if (devInfo != null) {
            screemNum = devInfo.getString("ScreemNum");
        }
        return screemNum;
    }

    private void zsBuilderJson(String channelId, String channelStatus, JSONObject data) {
        String lastTimeByChannelId = "";
        if ("zs-LPR".equals(data.getString("DeviceType"))) {
            if (StringUtils.isNotBlank((CharSequence)channelStatus)) {
                Short status = Short.valueOf(channelStatus);
                if (ParkConstants.CHANNEL_STATE_CART_IN.equals(status) || ParkConstants.CHANNEL_STATE_CAR_IN.equals(status)) {
                    lastTimeByChannelId = this.parkRecordinSideService.getRecordLastTimeByChannelId(channelId);
                    lastTimeByChannelId = lastTimeByChannelId == null ? "" : lastTimeByChannelId;
                    channelStatus = "0";
                } else {
                    lastTimeByChannelId = this.parkRecordoutService.getRecordLastTimeByChannelId(channelId);
                    lastTimeByChannelId = lastTimeByChannelId == null ? "" : lastTimeByChannelId;
                    channelStatus = "1";
                }
            }
            data.put("ChannelStatus", (Object)channelStatus);
            data.put("FromTime", (Object)lastTimeByChannelId);
        }
    }

    static {
        WEBSOCKETINIT = false;
    }

    class VoiceAndViewThread
    extends Thread {
        private volatile boolean stop = false;

        VoiceAndViewThread(String threadName) {
            super.setName(threadName);
        }

        public void stopThread() {
            Thread thisThread = Thread.currentThread();
            this.stop = true;
            thisThread.interrupt();
        }

        @Override
        public void run() {
            while (!this.stop) {
                Set keySet = ParkWebsocketServiceImpl.this.parkCacheService.keys("park:callback_voiceview_*");
                if (keySet.size() > 0) {
                    for (String key : keySet) {
                        JSONObject msgObj = ParkWebsocketServiceImpl.this.parkCacheService.getJson(key);
                        ParkWebsocketServiceImpl.this.parkCacheService.del(key);
                        String devIp = msgObj.getString("devIp");
                        Short devType = (short)msgObj.getIntValue("devType");
                        String content1 = msgObj.getString("content1");
                        String content2 = msgObj.getString("content2");
                        String voiceContNew = msgObj.getString("voiceContNew");
                        String voiceContOld = msgObj.getString("voiceContOld");
                        boolean isVoiceCarNumber = msgObj.getBoolean("isVoiceCarNumber");
                        this.sendVoiceAndView(devIp, devType, content1, content2, voiceContNew, voiceContOld, isVoiceCarNumber);
                    }
                    continue;
                }
                this.stopThread();
            }
        }

        private void sendVoiceAndView(String devIp, Short devType, String content1, String content2, String voiceContNew, String voiceContOld, boolean isVoiceCarNumber) {
            if (ParkConstants.LED_ONECOLOR.equals(devType)) {
                ParkWebsocketServiceImpl.this.sendCommandOld(devIp, content1, content2, voiceContOld);
            } else {
                if (isVoiceCarNumber && "zh_CN".equals(LocaleMessageSourceUtil.language) && ParkWebCommonUtil.isNotNull(content1) && !I18nUtil.i18nCode((String)"park_cmd_unknow", (Object[])new Object[0]).equals(content1) && !"Empty".equals(content1) && "true".equals(ParkWebsocketServiceImpl.this.parkParamsService.isVioceCarNumber())) {
                    voiceContNew = ParkWebsocketServiceImpl.this.park485Protocol.getCarNumberCode(content1) + voiceContNew;
                }
                if (ParkConstants.LED_TWOCOLOR.equals(devType)) {
                    ParkWebsocketServiceImpl.this.sendCommandNew(devIp, content1, content2, voiceContNew);
                } else {
                    ParkWebsocketServiceImpl.this.sendCommandNewFor4Lines(devIp, content1, content2, voiceContNew);
                }
            }
        }
    }

    class WebsocketServiceInit
    extends Thread {
        public WebsocketServiceInit(String name) {
            super(name);
        }

        @Override
        public void run() {
            if (!ParkWebsocketServiceImpl.this.parkCacheService.exists("park:logger")) {
                ParkWebsocketServiceImpl.this.parkCacheService.set("park:logger", (Object)"0", 0L);
            }
            ParkWebsocketServiceImpl.this.delOldDataFromRedis();
            String runMode = ParkWebsocketServiceImpl.this.parkParamsService.getRunMode();
            if ("lprCamera".equals(runMode)) {
                ParkWebsocketServiceImpl.this.createSDKService();
            }
            ParkWebsocketServiceImpl.this.carTypeService.setCarTypeToCache();
            ParkWebsocketServiceImpl.this.totalParkingSpaces();
            ParkWebsocketServiceImpl.this.parkPavilioService.setPavilioModeToCache();
            WEBSOCKETINIT = true;
        }
    }
}

