/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.sdkClient;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkSDKTasks;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkWebSocketSDKFun;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkWebsocketService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ParkCommonNotifyTask
implements ParkSDKTasks {
    private static final Logger log = LoggerFactory.getLogger(ParkCommonNotifyTask.class);
    private static final Logger logger = LoggerFactory.getLogger(ParkCommonNotifyTask.class);
    private static final int VZ_LPRC_ONLINE = 3;
    private static final int VZ_LPRC_OFFLINE = 4;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkWebSocketSDKFun webSocketSDKFun;
    @Autowired
    private ParkWebsocketService parkWebsocketService;

    @Override
    @Async(value="parkAsyncTaskExecutor")
    public void doTask(JSONObject json) {
        JSONObject dataObj = json.getJSONObject("Data");
        if (Integer.valueOf(dataObj.getString("ENotify")) == 3) {
            this.onGateRunStatusFun(dataObj);
        } else if (Integer.valueOf(dataObj.getString("ENotify")) == 4) {
            this.onCommonNotifyFun(dataObj);
        }
    }

    @Override
    public boolean match(JSONObject json) {
        return "OnCommonNotify".equalsIgnoreCase(json.getString("OpType"));
    }

    @Override
    public long order() {
        return Long.valueOf("20");
    }

    private void onCommonNotifyFun(JSONObject msgObj) {
        JSONObject devObj;
        logger.info("PARK_DEVICE == OnCommonNotifyFun Offline Callback msgObj = " + msgObj.toString());
        Long handle = Long.valueOf(msgObj.getString("Handle"));
        String devIp = this.parkCacheService.getStr("park:dev_handle_" + handle);
        if (ParkWebCommonUtil.isNotNull(devIp) && (devObj = this.parkCacheService.getJson("park:dev_info_" + devIp)).getString("enabled").equals("enable")) {
            logger.info("PARK_DEVICE == OnCommonNotifyFun Offline Callback Delete Redis View And Handle devIp = " + devIp);
            String keyStr = "park:view_defa_content_" + handle;
            if (this.parkCacheService.exists(keyStr)) {
                this.parkCacheService.del(keyStr);
            }
            if (this.parkCacheService.exists(keyStr = "park:dev_handle_" + handle)) {
                this.parkCacheService.del(keyStr);
            }
            devObj.put("handle", (Object)0);
            devObj.put("serialHand", (Object)0);
            devObj.put("carTeamSignal", (Object)false);
            String msgId = this.webSocketSDKFun.deviceClose(handle);
            int ret = this.parkCacheService.searchRedisByKey(msgId);
            if (ret <= 0) {
                logger.info("PARK_DEVICE == OnCommonNotifyFun Offline Callback Close Device Success devIp = " + devIp);
                devObj.put("state", (Object)"offLine");
            } else {
                logger.info("PARK_DEVICE == OnCommonNotifyFun Offline Callback Close Device Failure Try Again devIp = " + devIp);
                try {
                    Thread.sleep(10000L);
                    ret = this.parkCacheService.searchRedisByKey(msgId);
                    if (ret <= 0) {
                        logger.info("PARK_DEVICE == OnCommonNotifyFun Offline Callback Close Device Success devIp = " + devIp);
                        devObj.put("state", (Object)"offLine");
                    } else {
                        logger.info("PARK_DEVICE == OnCommonNotifyFun Offline Callback Close Device Failure ..." + devIp);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            logger.info("PARK_DEVICE == OnCommonNotifyFun Offline Callback Update Device Redis Info devObj = " + devObj.toString());
            this.parkCacheService.setJson("park:dev_info_" + devIp, devObj, 0L);
            this.parkWebsocketService.reconnDevice(devIp);
        }
    }

    private void onGateRunStatusFun(JSONObject msgObj) {
    }
}

