/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.List;
import mslinks.ShellLink;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.cache.CacheLRUWrapper;
import net.sourceforge.jnlp.security.dialogresults.AccessWarningPaneComplexReturn;
import net.sourceforge.jnlp.util.GenericDesktopEntry;
import net.sourceforge.jnlp.util.XDesktopEntry;
import net.sourceforge.jnlp.util.logging.OutputController;

public class WindowsDesktopEntry
implements GenericDesktopEntry {
    private final JNLPFile file;

    public WindowsDesktopEntry(JNLPFile file) {
        this.file = file;
    }

    @Override
    public String getDesktopIconFileName() {
        return XDesktopEntry.getDesktopIconName(this.file) + ".lnk";
    }

    private String getDesktopLnkPath() {
        return System.getenv("userprofile") + "/Desktop/" + this.getDesktopIconFileName();
    }

    @Override
    public File getDesktopIconFile() {
        return new File(this.getDesktopLnkPath());
    }

    @Override
    public void createShortcutOnWindowsDesktop() throws IOException {
        String path = this.getDesktopLnkPath();
        String JavaWsBin = XDesktopEntry.getJavaWsBin();
        String favIcon = this.getFavIcon();
        ShellLink sl = ShellLink.createLink(JavaWsBin).setCMDArgs(this.file.getSourceLocation().toString());
        if (favIcon != null) {
            favIcon = favIcon.substring(6);
            sl.setIconLocation(favIcon);
        }
        sl.saveTo(path);
        this.manageShortcutList(ManageMode.A, path);
    }

    @Override
    public void createWindowsMenu() throws IOException {
        String path = this.file.getInformation().getShortcut().getMenu().getSubMenu();
        if (path != null) {
            path = System.getenv("userprofile") + "/AppData/Roaming/Microsoft/Windows/Start Menu/Programs/" + path;
            File menuDir = new File(path);
            if (!menuDir.exists()) {
                menuDir.mkdir();
            }
            String JavaWsBin = XDesktopEntry.getJavaWsBin();
            String favIcon = this.getFavIcon();
            ShellLink sl = ShellLink.createLink(JavaWsBin).setCMDArgs(this.file.getSourceLocation().toString());
            ShellLink ul = ShellLink.createLink(JavaWsBin).setCMDArgs("-Xclearcache " + this.file.getFileLocation().toString());
            if (favIcon != null) {
                favIcon = favIcon.substring(6);
                sl.setIconLocation(favIcon);
                ul.setIconLocation(favIcon);
            }
            sl.saveTo(path + "/" + this.file.getInformation().getTitle() + ".lnk");
            ul.saveTo(path + "/Uninstall " + this.file.getInformation().getTitle() + ".lnk");
            this.manageShortcutList(ManageMode.A, path + "/" + this.file.getInformation().getTitle() + ".lnk");
            this.manageShortcutList(ManageMode.A, path + "/Uninstall " + this.file.getInformation().getTitle() + ".lnk");
        }
    }

    private void manageShortcutList(ManageMode mode, String path) throws IOException {
        if (!CacheLRUWrapper.getInstance().getWindowsShortcutList().exists()) {
            CacheLRUWrapper.getInstance().getWindowsShortcutList().createNewFile();
        }
        if (ManageMode.A == mode) {
            List<String> lines = Files.readAllLines(CacheLRUWrapper.getInstance().getWindowsShortcutList().toPath(), Charset.forName("UTF-8"));
            Iterator<String> it = lines.iterator();
            String sItem = "";
            Boolean fAdd = true;
            while (it.hasNext()) {
                sItem = it.next().toString();
                String[] sArray = sItem.split(",");
                String application = sArray[0];
                String sPath = sArray[1];
                if (!sPath.equalsIgnoreCase(path)) continue;
                fAdd = false;
                break;
            }
            if (fAdd.booleanValue()) {
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Adding sCut to list = " + sItem);
                String scInfo = this.file.getFileLocation().toString() + ",";
                scInfo = scInfo + path + "\r\n";
                Files.write(CacheLRUWrapper.getInstance().getWindowsShortcutList().toPath(), scInfo.getBytes(), StandardOpenOption.APPEND);
            }
        }
    }

    private String getFavIcon() {
        return XDesktopEntry.getFavIcon(this.file);
    }

    @Override
    public void createDesktopShortcuts(AccessWarningPaneComplexReturn.ShortcutResult menu, AccessWarningPaneComplexReturn.ShortcutResult desktop, boolean isSigned) {
        throw new UnsupportedOperationException("not suported on windows like systems");
    }

    @Override
    public void refreshExistingShortcuts(boolean desktop, boolean menu) {
        throw new UnsupportedOperationException("not suported on windows like systems");
    }

    @Override
    public File getGeneratedJnlpFileName() {
        throw new UnsupportedOperationException("not suported on windows like systems");
    }

    @Override
    public File getLinuxMenuIconFile() {
        throw new UnsupportedOperationException("not suported on windows like systems");
    }

    private static enum ManageMode {
        A;

    }
}

