/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorPermissions;
import net.sourceforge.jnlp.security.policyeditor.PolicyEntry;
import net.sourceforge.jnlp.security.policyeditor.PolicyFileModel;
import net.sourceforge.jnlp.security.policyeditor.PolicyIdentifier;
import sun.security.provider.PolicyParser;

public class PolicyEditorController {
    public final PolicyFileModel policyFile = new PolicyFileModel();
    private volatile boolean changesMade = false;
    private volatile boolean performingIO = false;

    boolean changesMade() {
        return this.changesMade;
    }

    void setChangesMade(boolean b) {
        this.changesMade = b;
    }

    boolean isPerformingIO() {
        return this.performingIO;
    }

    void setPerformingIO(boolean b) {
        this.performingIO = b;
    }

    public void setFile(File file) {
        boolean changedFile = this.policyFile.setFile(file);
        this.setChangesMade(changedFile);
    }

    public File getFile() {
        return this.policyFile.getFile();
    }

    public boolean fileHasChanged() throws IOException {
        return this.policyFile.hasChanged();
    }

    public boolean addIdentifier(PolicyIdentifier identifier) {
        boolean existed = this.policyFile.addIdentifier(identifier);
        if (!existed) {
            this.setChangesMade(true);
        }
        return existed;
    }

    public void removeIdentifier(PolicyIdentifier identifier) {
        this.setChangesMade(true);
        this.policyFile.removeIdentifier(identifier);
    }

    public SortedSet<PolicyIdentifier> getIdentifiers() {
        return new TreeSet<PolicyIdentifier>(this.policyFile.getIdentifiers());
    }

    public Map<PolicyIdentifier, Map<PolicyEditorPermissions, Boolean>> getCopyOfPermissions() {
        return this.policyFile.getCopyOfPermissions();
    }

    public void setPermission(PolicyIdentifier identifier, PolicyEditorPermissions permission, boolean state) {
        if (this.getPermission(identifier, permission) != state) {
            this.setChangesMade(true);
        }
        this.policyFile.setPermission(identifier, permission, state);
    }

    public boolean getPermission(PolicyIdentifier identifier, PolicyEditorPermissions permission) {
        return this.policyFile.getPermission(identifier, permission);
    }

    public Map<PolicyEditorPermissions, Boolean> getPermissions(PolicyIdentifier identifier) {
        this.policyFile.addIdentifier(identifier);
        return new HashMap<PolicyEditorPermissions, Boolean>(this.policyFile.getCopyOfPermissions().get(identifier));
    }

    public void clear() {
        this.setChangesMade(true);
        this.policyFile.clearPermissions();
    }

    public void clearPermissions() {
        this.setChangesMade(true);
        this.policyFile.clearPermissions();
    }

    public void addCustomPermissions(PolicyIdentifier identifier, Collection<PolicyParser.PermissionEntry> permissions) {
        if (!this.policyFile.getCopyOfCustomPermissions().containsKey(identifier) || !this.policyFile.getCopyOfCustomPermissions().get(identifier).equals(permissions)) {
            this.setChangesMade(true);
        }
        this.policyFile.addCustomPermissions(identifier, permissions);
    }

    public void addCustomPermission(PolicyIdentifier identifier, PolicyParser.PermissionEntry permission) {
        Map<PolicyIdentifier, Set<PolicyParser.PermissionEntry>> customs = this.policyFile.getCopyOfCustomPermissions();
        if (customs == null || !customs.containsKey(identifier) || customs.containsKey(identifier) && !customs.get(identifier).contains(permission)) {
            this.setChangesMade(true);
        }
        this.addCustomPermissions(identifier, Collections.singletonList(permission));
    }

    public Set<PolicyParser.PermissionEntry> getCustomPermissions(PolicyIdentifier identifier) {
        this.policyFile.addIdentifier(identifier);
        return new HashSet<PolicyParser.PermissionEntry>((Collection)this.policyFile.getCopyOfCustomPermissions().get(identifier));
    }

    public void addPolicyEntry(PolicyEntry policyEntry) {
        this.addIdentifier(policyEntry.getPolicyIdentifier());
        for (PolicyEditorPermissions permission : policyEntry.getPermissions()) {
            this.setPermission(policyEntry.getPolicyIdentifier(), permission, true);
        }
        this.addCustomPermissions(policyEntry.getPolicyIdentifier(), policyEntry.getCustomPermissions());
    }

    public void clearCustomPermissions() {
        this.setChangesMade(true);
        this.policyFile.clearCustomPermissions();
    }

    public void clearCustomIdentifier(PolicyIdentifier identifier) {
        this.setChangesMade(true);
        this.policyFile.clearCustomIdentifier(identifier);
    }

    public void openAndParsePolicyFile() throws IOException, PolicyParser.ParsingException {
        this.setPerformingIO(true);
        this.policyFile.openAndParsePolicyFile();
        this.setChangesMade(false);
        this.setPerformingIO(false);
    }

    public void savePolicyFile() throws IOException {
        this.setPerformingIO(true);
        this.policyFile.savePolicyFile();
        this.setChangesMade(false);
        this.setPerformingIO(false);
    }

    public void copyPolicyEntryToClipboard(PolicyIdentifier identifier) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        PolicyEntry policyEntry = this.getPolicyEntry(identifier);
        clipboard.setContents(policyEntry, null);
    }

    public PolicyEntry getPolicyEntry(PolicyIdentifier identifier) {
        HashSet<PolicyEditorPermissions> enabledPermissions = new HashSet<PolicyEditorPermissions>();
        for (Map.Entry<PolicyEditorPermissions, Boolean> entry : this.getPermissions(identifier).entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            enabledPermissions.add(entry.getKey());
        }
        return new PolicyEntry.Builder().identifier(identifier).permissions(enabledPermissions).customPermissions(this.getCustomPermissions(identifier)).build();
    }

    public static PolicyEntry getPolicyEntryFromClipboard() throws IOException, UnsupportedFlavorException, PolicyParser.ParsingException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        return (PolicyEntry)clipboard.getContents(null).getTransferData(PolicyEntry.POLICY_ENTRY_DATA_FLAVOR);
    }
}

