/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Utils {
    private static final Charset utf8Charset = Charset.forName("UTF-8");

    public static String toHexString(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i2 = 0; i2 < data.length; ++i2) {
            sb.append(Integer.toHexString(data[i2] >> 4 & 0xF));
            sb.append(Integer.toHexString(data[i2] & 0xF));
        }
        return sb.toString();
    }

    public static byte[] encodeUTF8(String str) {
        ByteBuffer buf = utf8Charset.encode(CharBuffer.wrap(str));
        byte[] b2 = new byte[buf.limit()];
        buf.get(b2, 0, buf.limit());
        return b2;
    }

    public static StringBuffer appendEscapedLiteral(StringBuffer sbuf, String value, boolean standardConformingStrings) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuffer(value.length() * 11 / 10);
        }
        if (standardConformingStrings) {
            for (int i2 = 0; i2 < value.length(); ++i2) {
                char ch = value.charAt(i2);
                if (ch == '\u0000') {
                    throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters."), PSQLState.INVALID_PARAMETER_VALUE);
                }
                if (ch == '\'') {
                    sbuf.append('\'');
                }
                sbuf.append(ch);
            }
        } else {
            for (int i3 = 0; i3 < value.length(); ++i3) {
                char ch = value.charAt(i3);
                if (ch == '\u0000') {
                    throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters."), PSQLState.INVALID_PARAMETER_VALUE);
                }
                if (ch == '\\' || ch == '\'') {
                    sbuf.append(ch);
                }
                sbuf.append(ch);
            }
        }
        return sbuf;
    }

    public static StringBuffer appendEscapedIdentifier(StringBuffer sbuf, String value) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuffer(2 + value.length() * 11 / 10);
        }
        sbuf.append('\"');
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char ch = value.charAt(i2);
            if (ch == '\u0000') {
                throw new PSQLException(GT.tr("Zero bytes may not occur in identifiers."), PSQLState.INVALID_PARAMETER_VALUE);
            }
            if (ch == '\"') {
                sbuf.append(ch);
            }
            sbuf.append(ch);
        }
        sbuf.append('\"');
        return sbuf;
    }
}

