/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.sql.SQLException;
import java.util.Properties;
import org.postgresql.core.Logger;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.v2.ConnectionFactoryImpl;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class ConnectionFactory {
    private static final Object[][] versions = new Object[][]{{"3", new org.postgresql.core.v3.ConnectionFactoryImpl()}, {"2", new ConnectionFactoryImpl()}};

    public static ProtocolConnection openConnection(HostSpec[] hostSpecs, String user, String database, Properties info, Logger logger) throws SQLException {
        String protoName = info.getProperty("protocolVersion");
        for (int i2 = 0; i2 < versions.length; ++i2) {
            ConnectionFactory factory;
            ProtocolConnection connection;
            String versionProtoName = (String)versions[i2][0];
            if (protoName != null && !protoName.equals(versionProtoName) || (connection = (factory = (ConnectionFactory)versions[i2][1]).openConnectionImpl(hostSpecs, user, database, info, logger)) == null) continue;
            return connection;
        }
        throw new PSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract ProtocolConnection openConnectionImpl(HostSpec[] var1, String var2, String var3, Properties var4, Logger var5) throws SQLException;
}

