/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLIdentifier;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.StreamType;
import com.microsoft.sqlserver.jdbc.TDS;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSPacket;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TDSReader {
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.Reader");
    private final String traceID;
    private final TDSChannel tdsChannel;
    private final SQLServerConnection con;
    private final TDSCommand command;
    private TDSPacket currentPacket;
    private TDSPacket lastPacket;
    private int payloadOffset;
    private int packetNum;
    private boolean isStreaming;
    private final byte[] valueBytes;
    private static int lastReaderID = 0;
    private static final byte[] SHILOH_ATTN_ACK_PATTERN = new byte[]{-3, 32, 0, -3, 0, 0, 0, 0, 0};
    private static final int[] SCALED_MULTIPLIERS = new int[]{10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    static final String guidTemplate = "NNNNNNNN-NNNN-NNNN-NNNN-NNNNNNNNNNNN";

    public final String toString() {
        return this.traceID;
    }

    final TDSCommand getCommand() {
        assert (null != this.command);
        return this.command;
    }

    final SQLServerConnection getConnection() {
        return this.con;
    }

    private static synchronized int nextReaderID() {
        return ++lastReaderID;
    }

    TDSReader(TDSChannel tDSChannel, SQLServerConnection sQLServerConnection, TDSCommand tDSCommand) {
        this.lastPacket = this.currentPacket = new TDSPacket(0);
        this.payloadOffset = 0;
        this.packetNum = 0;
        this.isStreaming = true;
        this.valueBytes = new byte[256];
        this.tdsChannel = tDSChannel;
        this.con = sQLServerConnection;
        this.command = tDSCommand;
        this.traceID = logger.isLoggable(Level.FINE) ? "TDSReader@" + TDSReader.nextReaderID() + " (" + sQLServerConnection.toString() + ")" : sQLServerConnection.toString();
    }

    final void throwInvalidTDS() throws SQLServerException {
        logger.severe(this.toString() + " got unexpected value in TDS response at offset:" + this.payloadOffset);
        this.con.throwInvalidTDS();
    }

    private final boolean ensurePayload() throws SQLServerException {
        if (this.payloadOffset == this.currentPacket.payloadLength && !this.nextPacket()) {
            return false;
        }
        assert (this.payloadOffset < this.currentPacket.payloadLength);
        return true;
    }

    private final boolean nextPacket() throws SQLServerException {
        assert (null != this.currentPacket);
        TDSPacket tDSPacket = this.currentPacket;
        assert (this.payloadOffset == tDSPacket.payloadLength);
        if (null == tDSPacket.next) {
            this.readPacket();
            if (null == tDSPacket.next) {
                return false;
            }
        }
        TDSPacket tDSPacket2 = tDSPacket.next;
        if (this.isStreaming) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Moving to next packet -- unlinking consumed packet");
            }
            tDSPacket.next = null;
        }
        this.currentPacket = tDSPacket2;
        this.payloadOffset = 0;
        return true;
    }

    final synchronized boolean readPacket() throws SQLServerException {
        int n2;
        int n3;
        int n4;
        if (null != this.command && !this.command.readingResponse()) {
            return false;
        }
        assert (this.tdsChannel.numMsgsRcvd < this.tdsChannel.numMsgsSent) : "numMsgsRcvd:" + this.tdsChannel.numMsgsRcvd + " should be less than numMsgsSent:" + this.tdsChannel.numMsgsSent;
        TDSPacket tDSPacket = new TDSPacket(this.con.getTDSPacketSize());
        for (n3 = 0; n3 < 8; n3 += n4) {
            n4 = this.tdsChannel.read(tDSPacket.header, n3, 8 - n3);
            if (n4 >= 0) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " Premature EOS in response. packetNum:" + this.packetNum + " headerBytesRead:" + n3);
            }
            this.con.terminate(3, 0 == this.packetNum && 0 == n3 ? SQLServerException.getErrString("R_noServerResponse") : SQLServerException.getErrString("R_truncatedServerResponse"));
        }
        n3 = Util.readUnsignedShortBigEndian(tDSPacket.header, 2);
        if (n3 < 8 || n3 > this.con.getTDSPacketSize()) {
            logger.warning(this.toString() + " TDS header contained invalid packet length:" + n3 + "; packet size:" + this.con.getTDSPacketSize());
            this.throwInvalidTDS();
        }
        tDSPacket.payloadLength = n3 - 8;
        this.tdsChannel.setSPID(Util.readUnsignedShortBigEndian(tDSPacket.header, 4));
        byte[] byArray = null;
        if (this.tdsChannel.isLoggingPackets()) {
            byArray = new byte[n3];
            System.arraycopy(tDSPacket.header, 0, byArray, 0, 8);
        }
        for (int i2 = 0; i2 < tDSPacket.payloadLength; i2 += n2) {
            n2 = this.tdsChannel.read(tDSPacket.payload, i2, tDSPacket.payloadLength - i2);
            if (n2 >= 0) continue;
            this.con.terminate(3, SQLServerException.getErrString("R_truncatedServerResponse"));
        }
        ++this.packetNum;
        this.lastPacket.next = tDSPacket;
        this.lastPacket = tDSPacket;
        if (this.tdsChannel.isLoggingPackets()) {
            System.arraycopy(tDSPacket.payload, 0, byArray, 8, tDSPacket.payloadLength);
            this.tdsChannel.logPacket(byArray, 0, n3, this.toString() + " received Packet:" + this.packetNum + " (" + tDSPacket.payloadLength + " bytes)");
        }
        if (tDSPacket.isEOM()) {
            ++this.tdsChannel.numMsgsRcvd;
            if (null != this.command) {
                this.command.onResponseEOM();
            }
        }
        return true;
    }

    final boolean lastPacketWasShilohAttentionAck() {
        boolean bl;
        assert (!this.con.isYukonOrLater());
        boolean bl2 = bl = 4 == this.lastPacket.header[0] && 1 == this.lastPacket.header[1] && SHILOH_ATTN_ACK_PATTERN.length == this.lastPacket.payloadLength;
        assert (this.lastPacket.payload.length >= this.lastPacket.payloadLength);
        for (int i2 = 0; bl && i2 < SHILOH_ATTN_ACK_PATTERN.length; ++i2) {
            if (SHILOH_ATTN_ACK_PATTERN[i2] == this.lastPacket.payload[i2]) continue;
            bl = false;
        }
        return bl;
    }

    final TDSReaderMark mark() {
        TDSReaderMark tDSReaderMark = new TDSReaderMark(this.currentPacket, this.payloadOffset);
        this.isStreaming = false;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + ": Buffering from: " + tDSReaderMark.toString());
        }
        return tDSReaderMark;
    }

    final void reset(TDSReaderMark tDSReaderMark) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + ": Resetting to: " + tDSReaderMark.toString());
        }
        this.currentPacket = tDSReaderMark.packet;
        this.payloadOffset = tDSReaderMark.payloadOffset;
    }

    final void stream() {
        this.isStreaming = true;
    }

    final int available() {
        int n2 = this.currentPacket.payloadLength - this.payloadOffset;
        TDSPacket tDSPacket = this.currentPacket.next;
        while (null != tDSPacket) {
            n2 += tDSPacket.payloadLength;
            tDSPacket = tDSPacket.next;
        }
        return n2;
    }

    final int peekTokenType() throws SQLServerException {
        if (!this.ensurePayload()) {
            return -1;
        }
        return this.currentPacket.payload[this.payloadOffset] & 0xFF;
    }

    final int readUnsignedByte() throws SQLServerException {
        if (!this.ensurePayload()) {
            this.throwInvalidTDS();
        }
        return this.currentPacket.payload[this.payloadOffset++] & 0xFF;
    }

    final short readShort() throws SQLServerException {
        if (this.payloadOffset + 2 <= this.currentPacket.payloadLength) {
            short s2 = Util.readShort(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 2;
            return s2;
        }
        return Util.readShort(this.readWrappedBytes(2), 0);
    }

    final int readUnsignedShort() throws SQLServerException {
        if (this.payloadOffset + 2 <= this.currentPacket.payloadLength) {
            int n2 = Util.readUnsignedShort(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 2;
            return n2;
        }
        return Util.readUnsignedShort(this.readWrappedBytes(2), 0);
    }

    final String readUnicodeString(int n2) throws SQLServerException {
        int n3 = 2 * n2;
        byte[] byArray = new byte[n3];
        this.readBytes(byArray, 0, n3);
        return Util.readUnicodeString(byArray, 0, n3);
    }

    final char readChar() throws SQLServerException {
        return (char)this.readShort();
    }

    final int readInt() throws SQLServerException {
        if (this.payloadOffset + 4 <= this.currentPacket.payloadLength) {
            int n2 = Util.readInt(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 4;
            return n2;
        }
        return Util.readInt(this.readWrappedBytes(4), 0);
    }

    final int readIntBigEndian() throws SQLServerException {
        if (this.payloadOffset + 4 <= this.currentPacket.payloadLength) {
            int n2 = Util.readIntBigEndian(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 4;
            return n2;
        }
        return Util.readIntBigEndian(this.readWrappedBytes(4), 0);
    }

    final long readUnsignedInt() throws SQLServerException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    final long readLong() throws SQLServerException {
        if (this.payloadOffset + 8 <= this.currentPacket.payloadLength) {
            long l2 = Util.readLong(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 8;
            return l2;
        }
        return Util.readLong(this.readWrappedBytes(8), 0);
    }

    final void readBytes(byte[] byArray, int n2, int n3) throws SQLServerException {
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            if (!this.ensurePayload()) {
                this.throwInvalidTDS();
            }
            if ((n5 = n3 - n4) > this.currentPacket.payloadLength - this.payloadOffset) {
                n5 = this.currentPacket.payloadLength - this.payloadOffset;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Reading " + n5 + " bytes from offset " + this.payloadOffset);
            }
            System.arraycopy(this.currentPacket.payload, this.payloadOffset, byArray, n2 + n4, n5);
            n4 += n5;
            this.payloadOffset += n5;
        }
    }

    final byte[] readWrappedBytes(int n2) throws SQLServerException {
        assert (n2 <= this.valueBytes.length);
        this.readBytes(this.valueBytes, 0, n2);
        return this.valueBytes;
    }

    final Object readDecimal(int n2, TypeInfo typeInfo, JDBCType jDBCType, StreamType streamType) throws SQLServerException {
        if (n2 > this.valueBytes.length) {
            logger.warning(this.toString() + " Invalid value length:" + n2);
            this.throwInvalidTDS();
        }
        this.readBytes(this.valueBytes, 0, n2);
        int n3 = 0 == this.valueBytes[0] ? -1 : 1;
        byte[] byArray = new byte[n2 - 1];
        for (int i2 = 1; i2 <= byArray.length; ++i2) {
            byArray[byArray.length - i2] = this.valueBytes[i2];
        }
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(n3, byArray), typeInfo.getScale());
        return DDC.convertBigDecimalToObject(bigDecimal, jDBCType, streamType);
    }

    final Object readMoney(int n2, JDBCType jDBCType, StreamType streamType) throws SQLServerException {
        BigInteger bigInteger;
        switch (n2) {
            case 8: {
                int n3 = this.readInt();
                int n4 = this.readInt();
                if (JDBCType.BINARY == jDBCType) {
                    byte[] byArray = new byte[8];
                    Util.writeIntBigEndian(n3, byArray, 0);
                    Util.writeIntBigEndian(n4, byArray, 4);
                    return byArray;
                }
                bigInteger = BigInteger.valueOf((long)n3 << 32 | (long)n4 & 0xFFFFFFFFL);
                break;
            }
            case 4: {
                if (JDBCType.BINARY == jDBCType) {
                    byte[] byArray = new byte[4];
                    Util.writeIntBigEndian(this.readInt(), byArray, 0);
                    return byArray;
                }
                bigInteger = BigInteger.valueOf(this.readInt());
                break;
            }
            default: {
                this.throwInvalidTDS();
                return null;
            }
        }
        return DDC.convertBigDecimalToObject(new BigDecimal(bigInteger, 4), jDBCType, streamType);
    }

    final Object readReal(int n2, JDBCType jDBCType, StreamType streamType) throws SQLServerException {
        if (4 != n2) {
            this.throwInvalidTDS();
        }
        return DDC.convertFloatToObject(Float.intBitsToFloat(this.readInt()), jDBCType, streamType);
    }

    final Object readFloat(int n2, JDBCType jDBCType, StreamType streamType) throws SQLServerException {
        if (8 != n2) {
            this.throwInvalidTDS();
        }
        return DDC.convertDoubleToObject(Double.longBitsToDouble(this.readLong()), jDBCType, streamType);
    }

    final Object readDateTime(int n2, Calendar calendar, JDBCType jDBCType, StreamType streamType) throws SQLServerException {
        int n3;
        int n4;
        switch (n2) {
            case 8: {
                n4 = this.readInt();
                int n5 = this.readInt();
                if (JDBCType.BINARY == jDBCType) {
                    byte[] byArray = new byte[8];
                    Util.writeIntBigEndian(n4, byArray, 0);
                    Util.writeIntBigEndian(n5, byArray, 4);
                    return byArray;
                }
                n3 = (n5 * 10 + 1) / 3;
                break;
            }
            case 4: {
                n4 = this.readUnsignedShort();
                int n6 = this.readUnsignedShort();
                if (JDBCType.BINARY == jDBCType) {
                    byte[] byArray = new byte[4];
                    Util.writeShortBigEndian((short)n4, byArray, 0);
                    Util.writeShortBigEndian((short)n6, byArray, 2);
                    return byArray;
                }
                n3 = n6 * 60 * 1000;
                break;
            }
            default: {
                this.throwInvalidTDS();
                return null;
            }
        }
        return DDC.convertTemporalToObject(jDBCType, SSType.DATETIME, calendar, n4, n3, 0);
    }

    final Object readDate(int n2, Calendar calendar, JDBCType jDBCType) throws SQLServerException {
        if (3 != n2) {
            this.throwInvalidTDS();
        }
        int n3 = this.readDaysIntoCE();
        return DDC.convertTemporalToObject(jDBCType, SSType.DATE, calendar, n3, 0L, 0);
    }

    final Object readTime(int n2, TypeInfo typeInfo, Calendar calendar, JDBCType jDBCType) throws SQLServerException {
        if (TDS.timeValueLength(typeInfo.getScale()) != n2) {
            this.throwInvalidTDS();
        }
        long l2 = this.readNanosSinceMidnight(typeInfo.getScale());
        return DDC.convertTemporalToObject(jDBCType, SSType.TIME, calendar, 0, l2, typeInfo.getScale());
    }

    final Object readDateTime2(int n2, TypeInfo typeInfo, Calendar calendar, JDBCType jDBCType) throws SQLServerException {
        if (TDS.datetime2ValueLength(typeInfo.getScale()) != n2) {
            this.throwInvalidTDS();
        }
        long l2 = this.readNanosSinceMidnight(typeInfo.getScale());
        int n3 = this.readDaysIntoCE();
        return DDC.convertTemporalToObject(jDBCType, SSType.DATETIME2, calendar, n3, l2, typeInfo.getScale());
    }

    final Object readDateTimeOffset(int n2, TypeInfo typeInfo, JDBCType jDBCType) throws SQLServerException {
        if (TDS.datetimeoffsetValueLength(typeInfo.getScale()) != n2) {
            this.throwInvalidTDS();
        }
        long l2 = this.readNanosSinceMidnight(typeInfo.getScale());
        int n3 = this.readDaysIntoCE();
        short s2 = this.readShort();
        return DDC.convertTemporalToObject(jDBCType, SSType.DATETIMEOFFSET, new GregorianCalendar(new SimpleTimeZone(s2 * 60 * 1000, ""), Locale.US), n3, l2, typeInfo.getScale());
    }

    private int readDaysIntoCE() throws SQLServerException {
        byte[] byArray = new byte[3];
        this.readBytes(byArray, 0, byArray.length);
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            n2 |= (byArray[i2] & 0xFF) << 8 * i2;
        }
        if (n2 < 0) {
            this.throwInvalidTDS();
        }
        return n2;
    }

    private long readNanosSinceMidnight(int n2) throws SQLServerException {
        assert (0 <= n2 && n2 <= 7);
        byte[] byArray = new byte[TDS.nanosSinceMidnightLength(n2)];
        this.readBytes(byArray, 0, byArray.length);
        long l2 = 0L;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            l2 |= ((long)byArray[i2] & 0xFFL) << 8 * i2;
        }
        if (0L > (l2 *= (long)SCALED_MULTIPLIERS[n2]) || l2 >= 864000000000L) {
            this.throwInvalidTDS();
        }
        return 100L * l2;
    }

    final Object readGUID(int n2, JDBCType jDBCType, StreamType streamType) throws SQLServerException {
        if (16 != n2) {
            this.throwInvalidTDS();
        }
        byte[] byArray = new byte[16];
        this.readBytes(byArray, 0, 16);
        switch (jDBCType) {
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: {
                int n3;
                StringBuilder stringBuilder = new StringBuilder(guidTemplate.length());
                for (n3 = 0; n3 < 4; ++n3) {
                    stringBuilder.append(Util.hexChars[(byArray[3 - n3] & 0xF0) >> 4]);
                    stringBuilder.append(Util.hexChars[byArray[3 - n3] & 0xF]);
                }
                stringBuilder.append('-');
                for (n3 = 0; n3 < 2; ++n3) {
                    stringBuilder.append(Util.hexChars[(byArray[5 - n3] & 0xF0) >> 4]);
                    stringBuilder.append(Util.hexChars[byArray[5 - n3] & 0xF]);
                }
                stringBuilder.append('-');
                for (n3 = 0; n3 < 2; ++n3) {
                    stringBuilder.append(Util.hexChars[(byArray[7 - n3] & 0xF0) >> 4]);
                    stringBuilder.append(Util.hexChars[byArray[7 - n3] & 0xF]);
                }
                stringBuilder.append('-');
                for (n3 = 0; n3 < 2; ++n3) {
                    stringBuilder.append(Util.hexChars[(byArray[8 + n3] & 0xF0) >> 4]);
                    stringBuilder.append(Util.hexChars[byArray[8 + n3] & 0xF]);
                }
                stringBuilder.append('-');
                for (n3 = 0; n3 < 6; ++n3) {
                    stringBuilder.append(Util.hexChars[(byArray[10 + n3] & 0xF0) >> 4]);
                    stringBuilder.append(Util.hexChars[byArray[10 + n3] & 0xF]);
                }
                try {
                    return DDC.convertStringToObject(stringBuilder.toString(), "UTF-16LE", jDBCType, streamType);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorConvertingValue"));
                    throw new SQLServerException(messageFormat.format(new Object[]{"UNIQUEIDENTIFIER", jDBCType}), null, 0, (Throwable)unsupportedEncodingException);
                }
            }
        }
        if (StreamType.BINARY == streamType || StreamType.ASCII == streamType) {
            return new ByteArrayInputStream(byArray);
        }
        return byArray;
    }

    final SQLIdentifier readSQLIdentifier() throws SQLServerException {
        int n2 = this.readUnsignedByte();
        if (1 > n2 || n2 > 4) {
            this.throwInvalidTDS();
        }
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.readUnicodeString(this.readUnsignedShort());
        }
        SQLIdentifier sQLIdentifier = new SQLIdentifier();
        sQLIdentifier.setObjectName(stringArray[n2 - 1]);
        if (n2 >= 2) {
            sQLIdentifier.setSchemaName(stringArray[n2 - 2]);
        }
        if (n2 >= 3) {
            sQLIdentifier.setDatabaseName(stringArray[n2 - 3]);
        }
        if (4 == n2) {
            sQLIdentifier.setServerName(stringArray[n2 - 4]);
        }
        return sQLIdentifier;
    }

    final SQLCollation readCollation() throws SQLServerException {
        SQLCollation sQLCollation = null;
        try {
            sQLCollation = new SQLCollation(this);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.con.terminate(4, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        return sQLCollation;
    }

    final void skip(int n2) throws SQLServerException {
        assert (n2 >= 0);
        while (n2 > 0) {
            int n3;
            if (!this.ensurePayload()) {
                this.throwInvalidTDS();
            }
            if ((n3 = n2) > this.currentPacket.payloadLength - this.payloadOffset) {
                n3 = this.currentPacket.payloadLength - this.payloadOffset;
            }
            n2 -= n3;
            this.payloadOffset += n3;
        }
    }
}

