/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerBlob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

final class SQLServerBlobOutputStream
extends OutputStream {
    private SQLServerBlob parentBlob = null;
    private long currentPos;

    SQLServerBlobOutputStream(SQLServerBlob sQLServerBlob, long l2) {
        this.parentBlob = sQLServerBlob;
        this.currentPos = l2;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (null == byArray) {
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            int n4 = this.parentBlob.setBytes(this.currentPos, byArray, n2, n3);
            this.currentPos += (long)n4;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    @Override
    public void write(int n2) throws IOException {
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF)};
        this.write(byArray, 0, byArray.length);
    }
}

