/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.RenegotiationInfoExtension;
import sun.security.ssl.ServerNameExtension;
import sun.security.ssl.SignatureAlgorithmsExtension;
import sun.security.ssl.SupportedEllipticCurvesExtension;
import sun.security.ssl.SupportedEllipticPointFormatsExtension;
import sun.security.ssl.UnknownExtension;

final class HelloExtensions {
    private List<HelloExtension> extensions;
    private int encodedLength;

    HelloExtensions() {
        this.extensions = Collections.emptyList();
    }

    HelloExtensions(HandshakeInStream handshakeInStream) throws IOException {
        int n;
        int n2;
        this.extensions = new ArrayList<HelloExtension>();
        this.encodedLength = n2 + 2;
        for (n2 = handshakeInStream.getInt16(); n2 > 0; n2 -= n + 4) {
            int n3 = handshakeInStream.getInt16();
            n = handshakeInStream.getInt16();
            ExtensionType extensionType = ExtensionType.get(n3);
            Object object = extensionType == ExtensionType.EXT_SERVER_NAME ? new ServerNameExtension(handshakeInStream, n) : (extensionType == ExtensionType.EXT_SIGNATURE_ALGORITHMS ? new SignatureAlgorithmsExtension(handshakeInStream, n) : (extensionType == ExtensionType.EXT_ELLIPTIC_CURVES ? new SupportedEllipticCurvesExtension(handshakeInStream, n) : (extensionType == ExtensionType.EXT_EC_POINT_FORMATS ? new SupportedEllipticPointFormatsExtension(handshakeInStream, n) : (extensionType == ExtensionType.EXT_RENEGOTIATION_INFO ? new RenegotiationInfoExtension(handshakeInStream, n) : new UnknownExtension(handshakeInStream, n, extensionType)))));
            this.extensions.add((HelloExtension)object);
        }
        if (n2 != 0) {
            throw new SSLProtocolException("Error parsing extensions: extra data");
        }
    }

    List<HelloExtension> list() {
        return this.extensions;
    }

    void add(HelloExtension helloExtension) {
        if (this.extensions.isEmpty()) {
            this.extensions = new ArrayList<HelloExtension>();
        }
        this.extensions.add(helloExtension);
        this.encodedLength = -1;
    }

    HelloExtension get(ExtensionType extensionType) {
        for (HelloExtension helloExtension : this.extensions) {
            if (helloExtension.type != extensionType) continue;
            return helloExtension;
        }
        return null;
    }

    int length() {
        if (this.encodedLength >= 0) {
            return this.encodedLength;
        }
        if (this.extensions.isEmpty()) {
            this.encodedLength = 0;
        } else {
            this.encodedLength = 2;
            for (HelloExtension helloExtension : this.extensions) {
                this.encodedLength += helloExtension.length();
            }
        }
        return this.encodedLength;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        int n = this.length();
        if (n == 0) {
            return;
        }
        handshakeOutStream.putInt16(n - 2);
        for (HelloExtension helloExtension : this.extensions) {
            helloExtension.send(handshakeOutStream);
        }
    }

    void print(PrintStream printStream) throws IOException {
        for (HelloExtension helloExtension : this.extensions) {
            printStream.println(helloExtension.toString());
        }
    }
}

