/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import sun.misc.ASCIICaseInsensitiveComparator;

public class AbstractCharsetProvider
extends CharsetProvider {
    private Map<String, String> classMap = new TreeMap<String, String>(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
    private Map<String, String> aliasMap = new TreeMap<String, String>(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
    private Map<String, String[]> aliasNameMap = new TreeMap<String, String[]>(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
    private Map<String, SoftReference<Charset>> cache = new TreeMap<String, SoftReference<Charset>>(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
    private String packagePrefix;

    protected AbstractCharsetProvider() {
        this.packagePrefix = "sun.nio.cs";
    }

    protected AbstractCharsetProvider(String string) {
        this.packagePrefix = string;
    }

    private static <K, V> void put(Map<K, V> map, K k, V v) {
        if (!map.containsKey(k)) {
            map.put(k, v);
        }
    }

    private static <K, V> void remove(Map<K, V> map, K k) {
        V v = map.remove(k);
        assert (v != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void charset(String string, String string2, String[] stringArray) {
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            AbstractCharsetProvider.put(this.classMap, string, string2);
            for (int i = 0; i < stringArray.length; ++i) {
                AbstractCharsetProvider.put(this.aliasMap, stringArray[i], string);
            }
            AbstractCharsetProvider.put(this.aliasNameMap, string, stringArray);
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteCharset(String string, String[] stringArray) {
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            AbstractCharsetProvider.remove(this.classMap, string);
            for (int i = 0; i < stringArray.length; ++i) {
                AbstractCharsetProvider.remove(this.aliasMap, stringArray[i]);
            }
            AbstractCharsetProvider.remove(this.aliasNameMap, string);
            this.cache.clear();
        }
    }

    protected void init() {
    }

    private String canonicalize(String string) {
        String string2 = this.aliasMap.get(string);
        return string2 != null ? string2 : string;
    }

    private Charset lookup(String string) {
        Object object;
        SoftReference<Charset> softReference = this.cache.get(string);
        if (softReference != null && (object = softReference.get()) != null) {
            return object;
        }
        object = this.classMap.get(string);
        if (object == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(this.packagePrefix + "." + (String)object, true, this.getClass().getClassLoader());
            Charset charset = (Charset)clazz.newInstance();
            this.cache.put(string, new SoftReference<Charset>(charset));
            return charset;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Charset charsetForName(String string) {
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            this.init();
            return this.lookup(this.canonicalize(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterator<Charset> charsets() {
        ArrayList<String> arrayList;
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            this.init();
            arrayList = new ArrayList<String>(this.classMap.keySet());
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] aliases(String string) {
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            this.init();
            return this.aliasNameMap.get(string);
        }
    }

    static /* synthetic */ Charset access$000(AbstractCharsetProvider abstractCharsetProvider, String string) {
        return abstractCharsetProvider.lookup(string);
    }
}

