/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.remote.PosRefundRemote;
import com.zkteco.zkbiosecurity.pos.service.PosSystemParamService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosRefundController
extends BaseController
implements PosRefundRemote {
    @Autowired
    private PosSystemParamService posSystemParamService;

    @RequiresPermissions(value={"pos:refund"})
    public ModelAndView index() {
        return new ModelAndView("pos/refund/posRefund");
    }

    @RequiresPermissions(value={"pos:refund:edit"})
    public ModelAndView edit(String id) {
        Integer cardModel = Integer.valueOf(this.posSystemParamService.getValByName("pos.cardModel"));
        return new ModelAndView("pos/refund/editPosRefund", "cardModel", (Object)cardModel.toString());
    }

    @RequiresPermissions(value={"pos:refund:del"})
    @LogRequest(module="pos_module", object="pos_op_refund", opType="common_op_del", requestParams={"ids"}, opContent="pos_common_id")
    public ZKResultMsg delete(String ids) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

