/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.remote.PosBatchTimeRemote;
import com.zkteco.zkbiosecurity.pos.service.PosBatchTimeService;
import com.zkteco.zkbiosecurity.pos.vo.PosBatchTimeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosBatchTimeController
extends BaseController
implements PosBatchTimeRemote {
    @Autowired
    private PosBatchTimeService posBatchTimeService;

    @RequiresPermissions(value={"pos:batchTime"})
    public ModelAndView index() {
        return new ModelAndView("pos/batchTime/posBatchTime");
    }

    @RequiresPermissions(value={"pos:batchTime:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posBatchTimeService.getItemById(id));
        }
        return new ModelAndView("pos/batchTime/editPosBatchTime");
    }

    @RequiresPermissions(value={"pos:batchTime:edit"})
    @LogRequest(module="pos_module", object="pos_leftMenu_batchTime", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(PosBatchTimeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        boolean oldIsValid = Boolean.parseBoolean(this.request.getParameter("oldIsValid"));
        this.posBatchTimeService.saveItem(item, oldIsValid);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:batchTime:refresh"})
    public DxGrid list(PosBatchTimeItem codition) {
        Pager pager = this.posBatchTimeService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pos:batchTime:del"})
    @LogRequest(module="pos_module", object="pos_leftMenu_batchTime", opType="common_op_del", requestParams={"ids"}, opContent="pos_common_id")
    public ZKResultMsg delete(String ids) {
        this.posBatchTimeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getBatchTimeList() {
        return new ZKResultMsg((Object)this.posBatchTimeService.getBatchTimeList());
    }

    public ZKResultMsg checkTimeseg() {
        String id = this.request.getParameter("posBatchTimeId");
        String posBatchName = this.request.getParameter("posBatchName");
        String startStr = this.request.getParameter("startTime");
        String endStr = this.request.getParameter("endTime");
        boolean available = Boolean.parseBoolean(this.request.getParameter("available"));
        return this.posBatchTimeService.checkTimeseg(id, startStr, endStr, available, posBatchName);
    }
}

