/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.util;

import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.pers.api.vo.ApiPersPersonItem;
import com.zkteco.zkbiosecurity.pers.api.vo.AppPersonItem;
import com.zkteco.zkbiosecurity.pers.constants.ApiErrorConstant;
import com.zkteco.zkbiosecurity.pers.util.ValidatorsUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PersCheckUtil {
    public static final int OP_SUCCESS = 0;
    private static final int CARD_MAX_LEN = 200;
    private static final int NAME_MAX_LEN = 50;
    private static final int DEPT_CODE_MAX_LEN = 30;
    private static final int DEPT_NAME_MAX_LEN = 100;
    private static final int EMAIL_MAX_LEN = 100;
    private static final int ADDRESS_MAX_LEN = 200;
    private static final String IDENTITY_CARD_TYPE = "2";
    private static final String REGEX_NAME = "^[A-Za-z0-9\\u4e00-\\u9fa5]+$";
    private static final String REGEX_LETTER = "^[A-Za-z]+$";

    public static int checkPersonValid(ApiPersPersonItem apiPersPersonItem, Map<String, String> certMap) {
        int ret = PersCheckUtil.checkPersonPin(apiPersPersonItem.getPin());
        if (ret < 0) {
            return ret;
        }
        ret = PersCheckUtil.checkPersonName(apiPersPersonItem.getName());
        if (ret < 0) {
            return ret;
        }
        ret = PersCheckUtil.checkPersonLastName(apiPersPersonItem.getLastName());
        if (ret < 0) {
            return ret;
        }
        ret = PersCheckUtil.checkDeptCode(apiPersPersonItem.getDeptCode());
        if (ret < 0) {
            return ret;
        }
        ret = PersCheckUtil.checkDeptName(apiPersPersonItem.getDeptName());
        if (ret < 0) {
            return ret;
        }
        ret = PersCheckUtil.checkCert(apiPersPersonItem.getCertType(), apiPersPersonItem.getCertNumber(), certMap);
        if (ret < 0) {
            return ret;
        }
        if (StringUtils.isNotBlank((CharSequence)apiPersPersonItem.getGender()) && !apiPersPersonItem.getGender().equalsIgnoreCase("F") && !apiPersPersonItem.getGender().equalsIgnoreCase("M")) {
            return ApiErrorConstant.ERROR_CODE_PERS_GENDER_INVALID;
        }
        if (StringUtils.isNotBlank((CharSequence)apiPersPersonItem.getBirthday()) && !ValidatorsUtils.isDate(apiPersPersonItem.getBirthday())) {
            return ApiErrorConstant.ERROR_CODE_PERS_BIRTHDAY_INVALID;
        }
        if ("zh_CN".equals(LocaleMessageSourceUtil.language) && StringUtils.isNotBlank((CharSequence)apiPersPersonItem.getMobilePhone()) && !ValidatorsUtils.isMobilePhone(apiPersPersonItem.getMobilePhone())) {
            return ApiErrorConstant.ERROR_CODE_PERS_PHONE_INVALID;
        }
        if (StringUtils.isNotBlank((CharSequence)apiPersPersonItem.getEmail()) && (!ValidatorsUtils.isEmail(apiPersPersonItem.getEmail()) || apiPersPersonItem.getEmail().length() > 100)) {
            return ApiErrorConstant.ERROR_CODE_PERS_EMAIL_INVALID;
        }
        if (StringUtils.isNotBlank((CharSequence)apiPersPersonItem.getHireDate()) && !ValidatorsUtils.isDate(apiPersPersonItem.getHireDate())) {
            return ApiErrorConstant.ERROR_CODE_PERS_HIRE_DATE_INVALID;
        }
        if (StringUtils.isNotBlank((CharSequence)apiPersPersonItem.getCardNos()) && apiPersPersonItem.getCardNos().length() > 200) {
            return ApiErrorConstant.ERROR_CODE_PERS_CARD_NUMBER_TOO_LONG;
        }
        return ret;
    }

    public static int checkPersonPin(String pin) {
        if (StringUtils.isBlank((CharSequence)pin)) {
            return ApiErrorConstant.ERROR_CODE_PERS_PIN_NULL;
        }
        if (!ValidatorsUtils.isAlphanumeric(pin)) {
            return ApiErrorConstant.ERROR_CODE_PERS_PIN_INVALID;
        }
        if (pin.length() > 23) {
            return ApiErrorConstant.ERROR_CODE_PERS_PIN_TOO_LONG;
        }
        return 0;
    }

    public static int checkPersonName(String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (StringUtils.isNotBlank((CharSequence)name) && name.length() > 50) {
                return ApiErrorConstant.ERROR_CODE_PERS_NAME_TOO_LONG;
            }
            if (ValidatorsUtils.isSpecialChar(name)) {
                return ApiErrorConstant.ERROR_CODE_PERS_NAME_INVALID;
            }
        }
        return 0;
    }

    public static int checkPersonLastName(String lastName) {
        if (StringUtils.isNotBlank((CharSequence)lastName)) {
            if (lastName.length() > 50) {
                return ApiErrorConstant.ERROR_CODE_PERS_LAST_NAME_TOO_LONG;
            }
            if (ValidatorsUtils.isSpecialChar(lastName)) {
                return ApiErrorConstant.ERROR_CODE_PERS_LAST_NAME_INVALID;
            }
        }
        return 0;
    }

    public static int checkDeptCode(String deptCode) {
        if (StringUtils.isBlank((CharSequence)deptCode)) {
            return ApiErrorConstant.ERROR_CODE_DEPT_CODE_NULL;
        }
        if (deptCode.length() > 30) {
            return ApiErrorConstant.ERROR_CODE_DEPT_CODE_TOO_LONG;
        }
        if (!ValidatorsUtils.isAlphanumeric(deptCode)) {
            return ApiErrorConstant.ERROR_CODE_DEPT_CODE_INVALID;
        }
        return 0;
    }

    public static int checkDeptName(String deptName) {
        if (StringUtils.isNotBlank((CharSequence)deptName)) {
            if (deptName.length() > 100) {
                return ApiErrorConstant.ERROR_CODE_DEPT_NAME_TOO_LONG;
            }
            if (ValidatorsUtils.isSpecialChar(deptName)) {
                return ApiErrorConstant.ERROR_CODE_DEPT_NAME_INVALID;
            }
        }
        return 0;
    }

    public static int checkCert(String certType, String certNumber, Map<String, String> certTypeMap) {
        if (StringUtils.isNotBlank((CharSequence)certType) || StringUtils.isNotBlank((CharSequence)certNumber)) {
            if (StringUtils.isNotBlank((CharSequence)certType) && StringUtils.isBlank((CharSequence)certNumber)) {
                return ApiErrorConstant.ERROR_CODE_PERS_CERT_NUMBER_NULL;
            }
            if (StringUtils.isNotBlank((CharSequence)certNumber) && StringUtils.isBlank((CharSequence)certType)) {
                return ApiErrorConstant.ERROR_CODE_PERS_CERT_TYPE_NULL;
            }
            if (certTypeMap != null && certTypeMap.get(certType) == null) {
                return ApiErrorConstant.ERROR_CODE_PERS_CERT_TYPE_NOT_EXIST;
            }
            if (IDENTITY_CARD_TYPE.equals(certType) && !ValidatorsUtils.checkCertType(certNumber)) {
                return ApiErrorConstant.ERROR_CODE_PERS_IDENTITY_CARD_INVALID;
            }
        }
        return 0;
    }

    public static void checkAppPerson(AppPersonItem appPersonItem, Map<String, String> paramMap) {
        int ret;
        String pin = appPersonItem.getPin();
        String mobile = appPersonItem.getMobile();
        String name = appPersonItem.getName();
        String lastName = appPersonItem.getLastName();
        String gender = appPersonItem.getGender();
        String familyAddress = appPersonItem.getFamilyAddress();
        String cardNos = appPersonItem.getCardNos();
        String email = appPersonItem.getEmail();
        PersCheckUtil.checkPin(pin);
        if (StringUtils.isBlank((CharSequence)mobile) && StringUtils.isBlank((CharSequence)email)) {
            throw ZKBusinessException.errorException((String)"pers_h5_emailOrPhoneNull", (Object[])new Object[0]);
        }
        if ("zh_CN".equals(LocaleMessageSourceUtil.language) && StringUtils.isNotBlank((CharSequence)mobile) && !ValidatorsUtils.isMobilePhone(mobile)) {
            throw ZKBusinessException.errorException((String)"pers_h5_personMobileInvalid", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)email) && (!ValidatorsUtils.isEmail(email) || email.length() > 100)) {
            throw ZKBusinessException.errorException((String)"common_email_inputEmailError", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            ret = PersCheckUtil.checkPersonName(name);
            if (ret < 0 && ret == ApiErrorConstant.ERROR_CODE_PERS_NAME_TOO_LONG) {
                throw ZKBusinessException.errorException((String)"pers_h5_personNameTooLong", (Object[])new Object[0]);
            }
            if (ret < 0 && ret == ApiErrorConstant.ERROR_CODE_PERS_NAME_INVALID) {
                throw ZKBusinessException.errorException((String)"pers_h5_personNameInvalid", (Object[])new Object[0]);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)lastName)) {
            ret = PersCheckUtil.checkPersonLastName(lastName);
            if (ret < 0 && ret == ApiErrorConstant.ERROR_CODE_PERS_LAST_NAME_TOO_LONG) {
                throw ZKBusinessException.errorException((String)"pers_h5_personLastNameTooLong", (Object[])new Object[0]);
            }
            if (ret < 0 && ret == ApiErrorConstant.ERROR_CODE_PERS_LAST_NAME_INVALID) {
                throw ZKBusinessException.errorException((String)"pers_h5_personLastNameInvalid", (Object[])new Object[0]);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)gender) && !gender.equalsIgnoreCase("F") && !gender.equalsIgnoreCase("M")) {
            throw ZKBusinessException.errorException((String)"pers_h5_personGenderInvalid", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)appPersonItem.getBirthday()) && !ValidatorsUtils.isDate(appPersonItem.getBirthday())) {
            throw ZKBusinessException.errorException((String)"pers_h5_dateInvalid", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)cardNos) && cardNos.length() > 200) {
            throw ZKBusinessException.errorException((String)"pers_h5_cardNoTooLong", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)familyAddress) && familyAddress.length() > 200) {
            throw ZKBusinessException.errorException((String)"pers_h5_familyAddressTooLong", (Object[])new Object[0]);
        }
    }

    private static void checkPin(String pin) {
        if (StringUtils.isBlank((CharSequence)pin)) {
            throw ZKBusinessException.errorException((String)"pers_import_pinNotEmpty", (Object[])new Object[0]);
        }
        if (pin.length() > 9) {
            throw ZKBusinessException.errorException((String)"pers_h5_personPinTooLong", (Object[])new Object[]{9});
        }
        if (pin.length() == 9 && (pin.startsWith("8") || pin.startsWith("9"))) {
            throw ZKBusinessException.errorException((String)"pers_h5_personPinInValid", (Object[])new Object[0]);
        }
        if (pin.startsWith("0")) {
            throw ZKBusinessException.errorException((String)"pers_h5_personPinNotStartWithZero", (Object[])new Object[0]);
        }
        if (!ValidatorsUtils.isNumberStr(pin)) {
            throw ZKBusinessException.errorException((String)"pers_h5_personPinFormatNumber", (Object[])new Object[0]);
        }
    }
}

