/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.pers.remote.PersPositionRemote;
import com.zkteco.zkbiosecurity.pers.service.PersPositionService;
import com.zkteco.zkbiosecurity.pers.util.PersExportTemplateUtil;
import com.zkteco.zkbiosecurity.pers.vo.PersPositionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersPositionController
extends ExportController
implements PersPositionRemote {
    @Autowired
    private PersPositionService persPositionService;
    @Autowired
    private PersExportTemplateUtil persExportTemplateUtil;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"pers:position"})
    public ModelAndView index() {
        return new ModelAndView("pers/position/persPosition");
    }

    @RequiresPermissions(value={"pers:position:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PersPositionItem item = this.persPositionService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("pers/position/editPersPosition");
    }

    @RequiresPermissions(value={"pers:position:edit"})
    @LogRequest(module="pers_module", object="pers_position", opType="common_op_edit", requestParams={"code"}, opContent="pers_position_code")
    public ZKResultMsg save(PersPositionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.persPositionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pers:position"})
    public DxGrid list(PersPositionItem condition) {
        if (StringUtils.isNotBlank((CharSequence)condition.getParentId())) {
            condition.setInId(this.persPositionService.getPositionIdsByParentId(condition.getParentId()));
            condition.setParentId(null);
        }
        Pager pager = this.persPositionService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pers:position:del"})
    @LogRequest(module="pers_module", object="pers_position", opType="common_op_del", requestParams={"name"}, opContent="pers_position_name")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.persPositionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String isExist(@RequestParam(value="code") String code) {
        return String.valueOf(this.persPositionService.getItemByCode(code) == null);
    }

    public ZKResultMsg isNameExist(@RequestParam(value="name") String name, @RequestParam(value="id") String id, @RequestParam(value="parentId") String parentId) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.persPositionService.isPositionNameExist(id, parentId, name)));
    }

    public TreeItem tree() {
        List demoDepartmentItems = this.persPositionService.getByCondition(new PersPositionItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (PersPositionItem depart : demoDepartmentItems) {
            item = new TreeItem();
            item.setId(depart.getId());
            item.setText(depart.getName());
            pItem = depart.getParentId() != null ? new TreeItem(depart.getParentId()) : new TreeItem("0");
            item.setParent(pItem);
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public void exportTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonObject = JSONObject.parseObject((String)request.getParameter("jsonColumn"), (Feature[])new Feature[]{Feature.OrderedField});
        HashMap<String, String> commentMap = new HashMap<String, String>();
        Iterator iterator = jsonObject.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "code": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]));
                    break;
                }
                case "name": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]));
                    break;
                }
                case "parentCode": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]));
                }
            }
        }
        this.persExportTemplateUtil.templateExport(request, response, commentMap);
    }

    public void export(HttpServletRequest req, HttpServletResponse resp) {
        String exportType = this.request.getParameter("exportType");
        String recordStart = this.request.getParameter("recordstart");
        String recordCount = this.request.getParameter("recordcount");
        int beginIndex = 0;
        int endIndex = 30000;
        if (exportType.equals("3") && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            beginIndex = Integer.valueOf(recordStart);
            beginIndex = beginIndex > 0 ? beginIndex - 1 : 0;
            int maxCount = Integer.valueOf(recordCount) > 30000 ? 30000 : Integer.valueOf(recordCount);
            endIndex = beginIndex + maxCount - 1;
        }
        PersPositionItem positionItem = new PersPositionItem();
        this.setConditionValue((BaseItem)positionItem);
        List list = this.persPositionService.getPersPositionItemData(PersPositionItem.class, (BaseItem)positionItem, beginIndex, endIndex);
        this.excelExport(list, PersPositionItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), PersPositionItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.persPositionService.importExcel(itemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import PersPosition Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }
}

